// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a transit gateway.
 */
class TransitGateway private constructor(builder: BuilderImpl) {
    /**
     * The creation time.
     */
    val creationTime: Instant? = builder.creationTime
    /**
     * The description of the transit gateway.
     */
    val description: String? = builder.description
    /**
     * The transit gateway options.
     */
    val options: TransitGatewayOptions? = builder.options
    /**
     * The ID of the Amazon Web Services account that owns the transit gateway.
     */
    val ownerId: String? = builder.ownerId
    /**
     * The state of the transit gateway.
     */
    val state: TransitGatewayState? = builder.state
    /**
     * The tags for the transit gateway.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The Amazon Resource Name (ARN) of the transit gateway.
     */
    val transitGatewayArn: String? = builder.transitGatewayArn
    /**
     * The ID of the transit gateway.
     */
    val transitGatewayId: String? = builder.transitGatewayId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): TransitGateway = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("TransitGateway(")
        append("creationTime=$creationTime,")
        append("description=$description,")
        append("options=$options,")
        append("ownerId=$ownerId,")
        append("state=$state,")
        append("tags=$tags,")
        append("transitGatewayArn=$transitGatewayArn,")
        append("transitGatewayId=$transitGatewayId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (options?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (transitGatewayArn?.hashCode() ?: 0)
        result = 31 * result + (transitGatewayId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as TransitGateway

        if (creationTime != other.creationTime) return false
        if (description != other.description) return false
        if (options != other.options) return false
        if (ownerId != other.ownerId) return false
        if (state != other.state) return false
        if (tags != other.tags) return false
        if (transitGatewayArn != other.transitGatewayArn) return false
        if (transitGatewayId != other.transitGatewayId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): TransitGateway = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): TransitGateway
        /**
         * The creation time.
         */
        fun creationTime(creationTime: Instant): FluentBuilder
        /**
         * The description of the transit gateway.
         */
        fun description(description: String): FluentBuilder
        /**
         * The transit gateway options.
         */
        fun options(options: TransitGatewayOptions): FluentBuilder
        /**
         * The ID of the Amazon Web Services account that owns the transit gateway.
         */
        fun ownerId(ownerId: String): FluentBuilder
        /**
         * The state of the transit gateway.
         */
        fun state(state: TransitGatewayState): FluentBuilder
        /**
         * The tags for the transit gateway.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the transit gateway.
         */
        fun transitGatewayArn(transitGatewayArn: String): FluentBuilder
        /**
         * The ID of the transit gateway.
         */
        fun transitGatewayId(transitGatewayId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The creation time.
         */
        var creationTime: Instant?
        /**
         * The description of the transit gateway.
         */
        var description: String?
        /**
         * The transit gateway options.
         */
        var options: TransitGatewayOptions?
        /**
         * The ID of the Amazon Web Services account that owns the transit gateway.
         */
        var ownerId: String?
        /**
         * The state of the transit gateway.
         */
        var state: TransitGatewayState?
        /**
         * The tags for the transit gateway.
         */
        var tags: List<Tag>?
        /**
         * The Amazon Resource Name (ARN) of the transit gateway.
         */
        var transitGatewayArn: String?
        /**
         * The ID of the transit gateway.
         */
        var transitGatewayId: String?

        fun build(): TransitGateway
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.TransitGatewayOptions] inside the given [block]
         */
        fun options(block: TransitGatewayOptions.DslBuilder.() -> kotlin.Unit) {
            this.options = TransitGatewayOptions.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var creationTime: Instant? = null
        override var description: String? = null
        override var options: TransitGatewayOptions? = null
        override var ownerId: String? = null
        override var state: TransitGatewayState? = null
        override var tags: List<Tag>? = null
        override var transitGatewayArn: String? = null
        override var transitGatewayId: String? = null

        constructor(x: TransitGateway) : this() {
            this.creationTime = x.creationTime
            this.description = x.description
            this.options = x.options
            this.ownerId = x.ownerId
            this.state = x.state
            this.tags = x.tags
            this.transitGatewayArn = x.transitGatewayArn
            this.transitGatewayId = x.transitGatewayId
        }

        override fun build(): TransitGateway = TransitGateway(this)
        override fun creationTime(creationTime: Instant): FluentBuilder = apply { this.creationTime = creationTime }
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun options(options: TransitGatewayOptions): FluentBuilder = apply { this.options = options }
        override fun ownerId(ownerId: String): FluentBuilder = apply { this.ownerId = ownerId }
        override fun state(state: TransitGatewayState): FluentBuilder = apply { this.state = state }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun transitGatewayArn(transitGatewayArn: String): FluentBuilder = apply { this.transitGatewayArn = transitGatewayArn }
        override fun transitGatewayId(transitGatewayId: String): FluentBuilder = apply { this.transitGatewayId = transitGatewayId }
    }
}
