// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an attachment between a resource and a transit gateway.
 */
class TransitGatewayAttachment private constructor(builder: BuilderImpl) {
    /**
     * The association.
     */
    val association: TransitGatewayAttachmentAssociation? = builder.association
    /**
     * The creation time.
     */
    val creationTime: Instant? = builder.creationTime
    /**
     * The ID of the resource.
     */
    val resourceId: String? = builder.resourceId
    /**
     * The ID of the Amazon Web Services account that owns the resource.
     */
    val resourceOwnerId: String? = builder.resourceOwnerId
    /**
     * The resource type. Note that the tgw-peering resource type has been deprecated.
     */
    val resourceType: TransitGatewayAttachmentResourceType? = builder.resourceType
    /**
     * The attachment state. Note that the initiating state has been deprecated.
     */
    val state: TransitGatewayAttachmentState? = builder.state
    /**
     * The tags for the attachment.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The ID of the attachment.
     */
    val transitGatewayAttachmentId: String? = builder.transitGatewayAttachmentId
    /**
     * The ID of the transit gateway.
     */
    val transitGatewayId: String? = builder.transitGatewayId
    /**
     * The ID of the Amazon Web Services account that owns the transit gateway.
     */
    val transitGatewayOwnerId: String? = builder.transitGatewayOwnerId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): TransitGatewayAttachment = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("TransitGatewayAttachment(")
        append("association=$association,")
        append("creationTime=$creationTime,")
        append("resourceId=$resourceId,")
        append("resourceOwnerId=$resourceOwnerId,")
        append("resourceType=$resourceType,")
        append("state=$state,")
        append("tags=$tags,")
        append("transitGatewayAttachmentId=$transitGatewayAttachmentId,")
        append("transitGatewayId=$transitGatewayId,")
        append("transitGatewayOwnerId=$transitGatewayOwnerId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = association?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (resourceOwnerId?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (transitGatewayAttachmentId?.hashCode() ?: 0)
        result = 31 * result + (transitGatewayId?.hashCode() ?: 0)
        result = 31 * result + (transitGatewayOwnerId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as TransitGatewayAttachment

        if (association != other.association) return false
        if (creationTime != other.creationTime) return false
        if (resourceId != other.resourceId) return false
        if (resourceOwnerId != other.resourceOwnerId) return false
        if (resourceType != other.resourceType) return false
        if (state != other.state) return false
        if (tags != other.tags) return false
        if (transitGatewayAttachmentId != other.transitGatewayAttachmentId) return false
        if (transitGatewayId != other.transitGatewayId) return false
        if (transitGatewayOwnerId != other.transitGatewayOwnerId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): TransitGatewayAttachment = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): TransitGatewayAttachment
        /**
         * The association.
         */
        fun association(association: TransitGatewayAttachmentAssociation): FluentBuilder
        /**
         * The creation time.
         */
        fun creationTime(creationTime: Instant): FluentBuilder
        /**
         * The ID of the resource.
         */
        fun resourceId(resourceId: String): FluentBuilder
        /**
         * The ID of the Amazon Web Services account that owns the resource.
         */
        fun resourceOwnerId(resourceOwnerId: String): FluentBuilder
        /**
         * The resource type. Note that the tgw-peering resource type has been deprecated.
         */
        fun resourceType(resourceType: TransitGatewayAttachmentResourceType): FluentBuilder
        /**
         * The attachment state. Note that the initiating state has been deprecated.
         */
        fun state(state: TransitGatewayAttachmentState): FluentBuilder
        /**
         * The tags for the attachment.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * The ID of the attachment.
         */
        fun transitGatewayAttachmentId(transitGatewayAttachmentId: String): FluentBuilder
        /**
         * The ID of the transit gateway.
         */
        fun transitGatewayId(transitGatewayId: String): FluentBuilder
        /**
         * The ID of the Amazon Web Services account that owns the transit gateway.
         */
        fun transitGatewayOwnerId(transitGatewayOwnerId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The association.
         */
        var association: TransitGatewayAttachmentAssociation?
        /**
         * The creation time.
         */
        var creationTime: Instant?
        /**
         * The ID of the resource.
         */
        var resourceId: String?
        /**
         * The ID of the Amazon Web Services account that owns the resource.
         */
        var resourceOwnerId: String?
        /**
         * The resource type. Note that the tgw-peering resource type has been deprecated.
         */
        var resourceType: TransitGatewayAttachmentResourceType?
        /**
         * The attachment state. Note that the initiating state has been deprecated.
         */
        var state: TransitGatewayAttachmentState?
        /**
         * The tags for the attachment.
         */
        var tags: List<Tag>?
        /**
         * The ID of the attachment.
         */
        var transitGatewayAttachmentId: String?
        /**
         * The ID of the transit gateway.
         */
        var transitGatewayId: String?
        /**
         * The ID of the Amazon Web Services account that owns the transit gateway.
         */
        var transitGatewayOwnerId: String?

        fun build(): TransitGatewayAttachment
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.TransitGatewayAttachmentAssociation] inside the given [block]
         */
        fun association(block: TransitGatewayAttachmentAssociation.DslBuilder.() -> kotlin.Unit) {
            this.association = TransitGatewayAttachmentAssociation.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var association: TransitGatewayAttachmentAssociation? = null
        override var creationTime: Instant? = null
        override var resourceId: String? = null
        override var resourceOwnerId: String? = null
        override var resourceType: TransitGatewayAttachmentResourceType? = null
        override var state: TransitGatewayAttachmentState? = null
        override var tags: List<Tag>? = null
        override var transitGatewayAttachmentId: String? = null
        override var transitGatewayId: String? = null
        override var transitGatewayOwnerId: String? = null

        constructor(x: TransitGatewayAttachment) : this() {
            this.association = x.association
            this.creationTime = x.creationTime
            this.resourceId = x.resourceId
            this.resourceOwnerId = x.resourceOwnerId
            this.resourceType = x.resourceType
            this.state = x.state
            this.tags = x.tags
            this.transitGatewayAttachmentId = x.transitGatewayAttachmentId
            this.transitGatewayId = x.transitGatewayId
            this.transitGatewayOwnerId = x.transitGatewayOwnerId
        }

        override fun build(): TransitGatewayAttachment = TransitGatewayAttachment(this)
        override fun association(association: TransitGatewayAttachmentAssociation): FluentBuilder = apply { this.association = association }
        override fun creationTime(creationTime: Instant): FluentBuilder = apply { this.creationTime = creationTime }
        override fun resourceId(resourceId: String): FluentBuilder = apply { this.resourceId = resourceId }
        override fun resourceOwnerId(resourceOwnerId: String): FluentBuilder = apply { this.resourceOwnerId = resourceOwnerId }
        override fun resourceType(resourceType: TransitGatewayAttachmentResourceType): FluentBuilder = apply { this.resourceType = resourceType }
        override fun state(state: TransitGatewayAttachmentState): FluentBuilder = apply { this.state = state }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun transitGatewayAttachmentId(transitGatewayAttachmentId: String): FluentBuilder = apply { this.transitGatewayAttachmentId = transitGatewayAttachmentId }
        override fun transitGatewayId(transitGatewayId: String): FluentBuilder = apply { this.transitGatewayId = transitGatewayId }
        override fun transitGatewayOwnerId(transitGatewayOwnerId: String): FluentBuilder = apply { this.transitGatewayOwnerId = transitGatewayOwnerId }
    }
}
