// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes the transit gateway multicast domain.
 */
class TransitGatewayMulticastDomain private constructor(builder: BuilderImpl) {
    /**
     * The time the transit gateway multicast domain was created.
     */
    val creationTime: Instant? = builder.creationTime
    /**
     * The options for the transit gateway multicast domain.
     */
    val options: TransitGatewayMulticastDomainOptions? = builder.options
    /**
     * The ID of the Amazon Web Services account that owns the transit gateway multicast domain.
     */
    val ownerId: String? = builder.ownerId
    /**
     * The state of the transit gateway multicast domain.
     */
    val state: TransitGatewayMulticastDomainState? = builder.state
    /**
     * The tags for the transit gateway multicast domain.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The ID of the transit gateway.
     */
    val transitGatewayId: String? = builder.transitGatewayId
    /**
     * The Amazon Resource Name (ARN) of the transit gateway multicast domain.
     */
    val transitGatewayMulticastDomainArn: String? = builder.transitGatewayMulticastDomainArn
    /**
     * The ID of the transit gateway multicast domain.
     */
    val transitGatewayMulticastDomainId: String? = builder.transitGatewayMulticastDomainId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): TransitGatewayMulticastDomain = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("TransitGatewayMulticastDomain(")
        append("creationTime=$creationTime,")
        append("options=$options,")
        append("ownerId=$ownerId,")
        append("state=$state,")
        append("tags=$tags,")
        append("transitGatewayId=$transitGatewayId,")
        append("transitGatewayMulticastDomainArn=$transitGatewayMulticastDomainArn,")
        append("transitGatewayMulticastDomainId=$transitGatewayMulticastDomainId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (options?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (transitGatewayId?.hashCode() ?: 0)
        result = 31 * result + (transitGatewayMulticastDomainArn?.hashCode() ?: 0)
        result = 31 * result + (transitGatewayMulticastDomainId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as TransitGatewayMulticastDomain

        if (creationTime != other.creationTime) return false
        if (options != other.options) return false
        if (ownerId != other.ownerId) return false
        if (state != other.state) return false
        if (tags != other.tags) return false
        if (transitGatewayId != other.transitGatewayId) return false
        if (transitGatewayMulticastDomainArn != other.transitGatewayMulticastDomainArn) return false
        if (transitGatewayMulticastDomainId != other.transitGatewayMulticastDomainId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): TransitGatewayMulticastDomain = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): TransitGatewayMulticastDomain
        /**
         * The time the transit gateway multicast domain was created.
         */
        fun creationTime(creationTime: Instant): FluentBuilder
        /**
         * The options for the transit gateway multicast domain.
         */
        fun options(options: TransitGatewayMulticastDomainOptions): FluentBuilder
        /**
         * The ID of the Amazon Web Services account that owns the transit gateway multicast domain.
         */
        fun ownerId(ownerId: String): FluentBuilder
        /**
         * The state of the transit gateway multicast domain.
         */
        fun state(state: TransitGatewayMulticastDomainState): FluentBuilder
        /**
         * The tags for the transit gateway multicast domain.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * The ID of the transit gateway.
         */
        fun transitGatewayId(transitGatewayId: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the transit gateway multicast domain.
         */
        fun transitGatewayMulticastDomainArn(transitGatewayMulticastDomainArn: String): FluentBuilder
        /**
         * The ID of the transit gateway multicast domain.
         */
        fun transitGatewayMulticastDomainId(transitGatewayMulticastDomainId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The time the transit gateway multicast domain was created.
         */
        var creationTime: Instant?
        /**
         * The options for the transit gateway multicast domain.
         */
        var options: TransitGatewayMulticastDomainOptions?
        /**
         * The ID of the Amazon Web Services account that owns the transit gateway multicast domain.
         */
        var ownerId: String?
        /**
         * The state of the transit gateway multicast domain.
         */
        var state: TransitGatewayMulticastDomainState?
        /**
         * The tags for the transit gateway multicast domain.
         */
        var tags: List<Tag>?
        /**
         * The ID of the transit gateway.
         */
        var transitGatewayId: String?
        /**
         * The Amazon Resource Name (ARN) of the transit gateway multicast domain.
         */
        var transitGatewayMulticastDomainArn: String?
        /**
         * The ID of the transit gateway multicast domain.
         */
        var transitGatewayMulticastDomainId: String?

        fun build(): TransitGatewayMulticastDomain
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.TransitGatewayMulticastDomainOptions] inside the given [block]
         */
        fun options(block: TransitGatewayMulticastDomainOptions.DslBuilder.() -> kotlin.Unit) {
            this.options = TransitGatewayMulticastDomainOptions.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var creationTime: Instant? = null
        override var options: TransitGatewayMulticastDomainOptions? = null
        override var ownerId: String? = null
        override var state: TransitGatewayMulticastDomainState? = null
        override var tags: List<Tag>? = null
        override var transitGatewayId: String? = null
        override var transitGatewayMulticastDomainArn: String? = null
        override var transitGatewayMulticastDomainId: String? = null

        constructor(x: TransitGatewayMulticastDomain) : this() {
            this.creationTime = x.creationTime
            this.options = x.options
            this.ownerId = x.ownerId
            this.state = x.state
            this.tags = x.tags
            this.transitGatewayId = x.transitGatewayId
            this.transitGatewayMulticastDomainArn = x.transitGatewayMulticastDomainArn
            this.transitGatewayMulticastDomainId = x.transitGatewayMulticastDomainId
        }

        override fun build(): TransitGatewayMulticastDomain = TransitGatewayMulticastDomain(this)
        override fun creationTime(creationTime: Instant): FluentBuilder = apply { this.creationTime = creationTime }
        override fun options(options: TransitGatewayMulticastDomainOptions): FluentBuilder = apply { this.options = options }
        override fun ownerId(ownerId: String): FluentBuilder = apply { this.ownerId = ownerId }
        override fun state(state: TransitGatewayMulticastDomainState): FluentBuilder = apply { this.state = state }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun transitGatewayId(transitGatewayId: String): FluentBuilder = apply { this.transitGatewayId = transitGatewayId }
        override fun transitGatewayMulticastDomainArn(transitGatewayMulticastDomainArn: String): FluentBuilder = apply { this.transitGatewayMulticastDomainArn = transitGatewayMulticastDomainArn }
        override fun transitGatewayMulticastDomainId(transitGatewayMulticastDomainId: String): FluentBuilder = apply { this.transitGatewayMulticastDomainId = transitGatewayMulticastDomainId }
    }
}
