// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the resources associated with the transit gateway multicast domain.
 */
class TransitGatewayMulticastDomainAssociation private constructor(builder: BuilderImpl) {
    /**
     * The ID of the resource.
     */
    val resourceId: String? = builder.resourceId
    /**
     * The ID of the Amazon Web Services account that owns the transit gateway multicast domain association resource.
     */
    val resourceOwnerId: String? = builder.resourceOwnerId
    /**
     * The type of resource, for example a VPC attachment.
     */
    val resourceType: TransitGatewayAttachmentResourceType? = builder.resourceType
    /**
     * The subnet associated with the transit gateway multicast domain.
     */
    val subnet: SubnetAssociation? = builder.subnet
    /**
     * The ID of the transit gateway attachment.
     */
    val transitGatewayAttachmentId: String? = builder.transitGatewayAttachmentId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): TransitGatewayMulticastDomainAssociation = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("TransitGatewayMulticastDomainAssociation(")
        append("resourceId=$resourceId,")
        append("resourceOwnerId=$resourceOwnerId,")
        append("resourceType=$resourceType,")
        append("subnet=$subnet,")
        append("transitGatewayAttachmentId=$transitGatewayAttachmentId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = resourceId?.hashCode() ?: 0
        result = 31 * result + (resourceOwnerId?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (subnet?.hashCode() ?: 0)
        result = 31 * result + (transitGatewayAttachmentId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as TransitGatewayMulticastDomainAssociation

        if (resourceId != other.resourceId) return false
        if (resourceOwnerId != other.resourceOwnerId) return false
        if (resourceType != other.resourceType) return false
        if (subnet != other.subnet) return false
        if (transitGatewayAttachmentId != other.transitGatewayAttachmentId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): TransitGatewayMulticastDomainAssociation = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): TransitGatewayMulticastDomainAssociation
        /**
         * The ID of the resource.
         */
        fun resourceId(resourceId: String): FluentBuilder
        /**
         * The ID of the Amazon Web Services account that owns the transit gateway multicast domain association resource.
         */
        fun resourceOwnerId(resourceOwnerId: String): FluentBuilder
        /**
         * The type of resource, for example a VPC attachment.
         */
        fun resourceType(resourceType: TransitGatewayAttachmentResourceType): FluentBuilder
        /**
         * The subnet associated with the transit gateway multicast domain.
         */
        fun subnet(subnet: SubnetAssociation): FluentBuilder
        /**
         * The ID of the transit gateway attachment.
         */
        fun transitGatewayAttachmentId(transitGatewayAttachmentId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ID of the resource.
         */
        var resourceId: String?
        /**
         * The ID of the Amazon Web Services account that owns the transit gateway multicast domain association resource.
         */
        var resourceOwnerId: String?
        /**
         * The type of resource, for example a VPC attachment.
         */
        var resourceType: TransitGatewayAttachmentResourceType?
        /**
         * The subnet associated with the transit gateway multicast domain.
         */
        var subnet: SubnetAssociation?
        /**
         * The ID of the transit gateway attachment.
         */
        var transitGatewayAttachmentId: String?

        fun build(): TransitGatewayMulticastDomainAssociation
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.SubnetAssociation] inside the given [block]
         */
        fun subnet(block: SubnetAssociation.DslBuilder.() -> kotlin.Unit) {
            this.subnet = SubnetAssociation.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var resourceId: String? = null
        override var resourceOwnerId: String? = null
        override var resourceType: TransitGatewayAttachmentResourceType? = null
        override var subnet: SubnetAssociation? = null
        override var transitGatewayAttachmentId: String? = null

        constructor(x: TransitGatewayMulticastDomainAssociation) : this() {
            this.resourceId = x.resourceId
            this.resourceOwnerId = x.resourceOwnerId
            this.resourceType = x.resourceType
            this.subnet = x.subnet
            this.transitGatewayAttachmentId = x.transitGatewayAttachmentId
        }

        override fun build(): TransitGatewayMulticastDomainAssociation = TransitGatewayMulticastDomainAssociation(this)
        override fun resourceId(resourceId: String): FluentBuilder = apply { this.resourceId = resourceId }
        override fun resourceOwnerId(resourceOwnerId: String): FluentBuilder = apply { this.resourceOwnerId = resourceOwnerId }
        override fun resourceType(resourceType: TransitGatewayAttachmentResourceType): FluentBuilder = apply { this.resourceType = resourceType }
        override fun subnet(subnet: SubnetAssociation): FluentBuilder = apply { this.subnet = subnet }
        override fun transitGatewayAttachmentId(transitGatewayAttachmentId: String): FluentBuilder = apply { this.transitGatewayAttachmentId = transitGatewayAttachmentId }
    }
}
