// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the  transit gateway multicast group resources.
 */
class TransitGatewayMulticastGroup private constructor(builder: BuilderImpl) {
    /**
     * The IP address assigned to the  transit gateway multicast group.
     */
    val groupIpAddress: String? = builder.groupIpAddress
    /**
     * Indicates that the resource is a  transit gateway multicast group member.
     */
    val groupMember: Boolean? = builder.groupMember
    /**
     * Indicates that the resource is a  transit gateway multicast group member.
     */
    val groupSource: Boolean? = builder.groupSource
    /**
     * The member type (for example, static).
     */
    val memberType: MembershipType? = builder.memberType
    /**
     * The ID of the transit gateway attachment.
     */
    val networkInterfaceId: String? = builder.networkInterfaceId
    /**
     * The ID of the resource.
     */
    val resourceId: String? = builder.resourceId
    /**
     * The ID of the Amazon Web Services account that owns the transit gateway multicast domain group resource.
     */
    val resourceOwnerId: String? = builder.resourceOwnerId
    /**
     * The type of resource, for example a VPC attachment.
     */
    val resourceType: TransitGatewayAttachmentResourceType? = builder.resourceType
    /**
     * The source type.
     */
    val sourceType: MembershipType? = builder.sourceType
    /**
     * The ID of the subnet.
     */
    val subnetId: String? = builder.subnetId
    /**
     * The ID of the transit gateway attachment.
     */
    val transitGatewayAttachmentId: String? = builder.transitGatewayAttachmentId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): TransitGatewayMulticastGroup = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("TransitGatewayMulticastGroup(")
        append("groupIpAddress=$groupIpAddress,")
        append("groupMember=$groupMember,")
        append("groupSource=$groupSource,")
        append("memberType=$memberType,")
        append("networkInterfaceId=$networkInterfaceId,")
        append("resourceId=$resourceId,")
        append("resourceOwnerId=$resourceOwnerId,")
        append("resourceType=$resourceType,")
        append("sourceType=$sourceType,")
        append("subnetId=$subnetId,")
        append("transitGatewayAttachmentId=$transitGatewayAttachmentId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = groupIpAddress?.hashCode() ?: 0
        result = 31 * result + (groupMember?.hashCode() ?: 0)
        result = 31 * result + (groupSource?.hashCode() ?: 0)
        result = 31 * result + (memberType?.hashCode() ?: 0)
        result = 31 * result + (networkInterfaceId?.hashCode() ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (resourceOwnerId?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (sourceType?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        result = 31 * result + (transitGatewayAttachmentId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as TransitGatewayMulticastGroup

        if (groupIpAddress != other.groupIpAddress) return false
        if (groupMember != other.groupMember) return false
        if (groupSource != other.groupSource) return false
        if (memberType != other.memberType) return false
        if (networkInterfaceId != other.networkInterfaceId) return false
        if (resourceId != other.resourceId) return false
        if (resourceOwnerId != other.resourceOwnerId) return false
        if (resourceType != other.resourceType) return false
        if (sourceType != other.sourceType) return false
        if (subnetId != other.subnetId) return false
        if (transitGatewayAttachmentId != other.transitGatewayAttachmentId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): TransitGatewayMulticastGroup = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): TransitGatewayMulticastGroup
        /**
         * The IP address assigned to the  transit gateway multicast group.
         */
        fun groupIpAddress(groupIpAddress: String): FluentBuilder
        /**
         * Indicates that the resource is a  transit gateway multicast group member.
         */
        fun groupMember(groupMember: Boolean): FluentBuilder
        /**
         * Indicates that the resource is a  transit gateway multicast group member.
         */
        fun groupSource(groupSource: Boolean): FluentBuilder
        /**
         * The member type (for example, static).
         */
        fun memberType(memberType: MembershipType): FluentBuilder
        /**
         * The ID of the transit gateway attachment.
         */
        fun networkInterfaceId(networkInterfaceId: String): FluentBuilder
        /**
         * The ID of the resource.
         */
        fun resourceId(resourceId: String): FluentBuilder
        /**
         * The ID of the Amazon Web Services account that owns the transit gateway multicast domain group resource.
         */
        fun resourceOwnerId(resourceOwnerId: String): FluentBuilder
        /**
         * The type of resource, for example a VPC attachment.
         */
        fun resourceType(resourceType: TransitGatewayAttachmentResourceType): FluentBuilder
        /**
         * The source type.
         */
        fun sourceType(sourceType: MembershipType): FluentBuilder
        /**
         * The ID of the subnet.
         */
        fun subnetId(subnetId: String): FluentBuilder
        /**
         * The ID of the transit gateway attachment.
         */
        fun transitGatewayAttachmentId(transitGatewayAttachmentId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The IP address assigned to the  transit gateway multicast group.
         */
        var groupIpAddress: String?
        /**
         * Indicates that the resource is a  transit gateway multicast group member.
         */
        var groupMember: Boolean?
        /**
         * Indicates that the resource is a  transit gateway multicast group member.
         */
        var groupSource: Boolean?
        /**
         * The member type (for example, static).
         */
        var memberType: MembershipType?
        /**
         * The ID of the transit gateway attachment.
         */
        var networkInterfaceId: String?
        /**
         * The ID of the resource.
         */
        var resourceId: String?
        /**
         * The ID of the Amazon Web Services account that owns the transit gateway multicast domain group resource.
         */
        var resourceOwnerId: String?
        /**
         * The type of resource, for example a VPC attachment.
         */
        var resourceType: TransitGatewayAttachmentResourceType?
        /**
         * The source type.
         */
        var sourceType: MembershipType?
        /**
         * The ID of the subnet.
         */
        var subnetId: String?
        /**
         * The ID of the transit gateway attachment.
         */
        var transitGatewayAttachmentId: String?

        fun build(): TransitGatewayMulticastGroup
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var groupIpAddress: String? = null
        override var groupMember: Boolean? = null
        override var groupSource: Boolean? = null
        override var memberType: MembershipType? = null
        override var networkInterfaceId: String? = null
        override var resourceId: String? = null
        override var resourceOwnerId: String? = null
        override var resourceType: TransitGatewayAttachmentResourceType? = null
        override var sourceType: MembershipType? = null
        override var subnetId: String? = null
        override var transitGatewayAttachmentId: String? = null

        constructor(x: TransitGatewayMulticastGroup) : this() {
            this.groupIpAddress = x.groupIpAddress
            this.groupMember = x.groupMember
            this.groupSource = x.groupSource
            this.memberType = x.memberType
            this.networkInterfaceId = x.networkInterfaceId
            this.resourceId = x.resourceId
            this.resourceOwnerId = x.resourceOwnerId
            this.resourceType = x.resourceType
            this.sourceType = x.sourceType
            this.subnetId = x.subnetId
            this.transitGatewayAttachmentId = x.transitGatewayAttachmentId
        }

        override fun build(): TransitGatewayMulticastGroup = TransitGatewayMulticastGroup(this)
        override fun groupIpAddress(groupIpAddress: String): FluentBuilder = apply { this.groupIpAddress = groupIpAddress }
        override fun groupMember(groupMember: Boolean): FluentBuilder = apply { this.groupMember = groupMember }
        override fun groupSource(groupSource: Boolean): FluentBuilder = apply { this.groupSource = groupSource }
        override fun memberType(memberType: MembershipType): FluentBuilder = apply { this.memberType = memberType }
        override fun networkInterfaceId(networkInterfaceId: String): FluentBuilder = apply { this.networkInterfaceId = networkInterfaceId }
        override fun resourceId(resourceId: String): FluentBuilder = apply { this.resourceId = resourceId }
        override fun resourceOwnerId(resourceOwnerId: String): FluentBuilder = apply { this.resourceOwnerId = resourceOwnerId }
        override fun resourceType(resourceType: TransitGatewayAttachmentResourceType): FluentBuilder = apply { this.resourceType = resourceType }
        override fun sourceType(sourceType: MembershipType): FluentBuilder = apply { this.sourceType = sourceType }
        override fun subnetId(subnetId: String): FluentBuilder = apply { this.subnetId = subnetId }
        override fun transitGatewayAttachmentId(transitGatewayAttachmentId: String): FluentBuilder = apply { this.transitGatewayAttachmentId = transitGatewayAttachmentId }
    }
}
