// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the options for a transit gateway.
 */
class TransitGatewayOptions private constructor(builder: BuilderImpl) {
    /**
     * A private Autonomous System Number (ASN) for the Amazon side of a BGP session.
     * The range is 64512 to 65534 for 16-bit ASNs and 4200000000 to 4294967294 for 32-bit ASNs.
     */
    val amazonSideAsn: Long? = builder.amazonSideAsn
    /**
     * The ID of the default association route table.
     */
    val associationDefaultRouteTableId: String? = builder.associationDefaultRouteTableId
    /**
     * Indicates whether attachment requests are automatically accepted.
     */
    val autoAcceptSharedAttachments: AutoAcceptSharedAttachmentsValue? = builder.autoAcceptSharedAttachments
    /**
     * Indicates whether resource attachments are automatically associated with the default association route table.
     */
    val defaultRouteTableAssociation: DefaultRouteTableAssociationValue? = builder.defaultRouteTableAssociation
    /**
     * Indicates whether resource attachments automatically propagate routes to the default propagation route table.
     */
    val defaultRouteTablePropagation: DefaultRouteTablePropagationValue? = builder.defaultRouteTablePropagation
    /**
     * Indicates whether DNS support is enabled.
     */
    val dnsSupport: DnsSupportValue? = builder.dnsSupport
    /**
     * Indicates whether multicast is enabled on the transit gateway
     */
    val multicastSupport: MulticastSupportValue? = builder.multicastSupport
    /**
     * The ID of the default propagation route table.
     */
    val propagationDefaultRouteTableId: String? = builder.propagationDefaultRouteTableId
    /**
     * The transit gateway CIDR blocks.
     */
    val transitGatewayCidrBlocks: List<String>? = builder.transitGatewayCidrBlocks
    /**
     * Indicates whether Equal Cost Multipath Protocol support is enabled.
     */
    val vpnEcmpSupport: VpnEcmpSupportValue? = builder.vpnEcmpSupport

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): TransitGatewayOptions = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("TransitGatewayOptions(")
        append("amazonSideAsn=$amazonSideAsn,")
        append("associationDefaultRouteTableId=$associationDefaultRouteTableId,")
        append("autoAcceptSharedAttachments=$autoAcceptSharedAttachments,")
        append("defaultRouteTableAssociation=$defaultRouteTableAssociation,")
        append("defaultRouteTablePropagation=$defaultRouteTablePropagation,")
        append("dnsSupport=$dnsSupport,")
        append("multicastSupport=$multicastSupport,")
        append("propagationDefaultRouteTableId=$propagationDefaultRouteTableId,")
        append("transitGatewayCidrBlocks=$transitGatewayCidrBlocks,")
        append("vpnEcmpSupport=$vpnEcmpSupport)")
    }

    override fun hashCode(): kotlin.Int {
        var result = amazonSideAsn?.hashCode() ?: 0
        result = 31 * result + (associationDefaultRouteTableId?.hashCode() ?: 0)
        result = 31 * result + (autoAcceptSharedAttachments?.hashCode() ?: 0)
        result = 31 * result + (defaultRouteTableAssociation?.hashCode() ?: 0)
        result = 31 * result + (defaultRouteTablePropagation?.hashCode() ?: 0)
        result = 31 * result + (dnsSupport?.hashCode() ?: 0)
        result = 31 * result + (multicastSupport?.hashCode() ?: 0)
        result = 31 * result + (propagationDefaultRouteTableId?.hashCode() ?: 0)
        result = 31 * result + (transitGatewayCidrBlocks?.hashCode() ?: 0)
        result = 31 * result + (vpnEcmpSupport?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as TransitGatewayOptions

        if (amazonSideAsn != other.amazonSideAsn) return false
        if (associationDefaultRouteTableId != other.associationDefaultRouteTableId) return false
        if (autoAcceptSharedAttachments != other.autoAcceptSharedAttachments) return false
        if (defaultRouteTableAssociation != other.defaultRouteTableAssociation) return false
        if (defaultRouteTablePropagation != other.defaultRouteTablePropagation) return false
        if (dnsSupport != other.dnsSupport) return false
        if (multicastSupport != other.multicastSupport) return false
        if (propagationDefaultRouteTableId != other.propagationDefaultRouteTableId) return false
        if (transitGatewayCidrBlocks != other.transitGatewayCidrBlocks) return false
        if (vpnEcmpSupport != other.vpnEcmpSupport) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): TransitGatewayOptions = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): TransitGatewayOptions
        /**
         * A private Autonomous System Number (ASN) for the Amazon side of a BGP session.
         * The range is 64512 to 65534 for 16-bit ASNs and 4200000000 to 4294967294 for 32-bit ASNs.
         */
        fun amazonSideAsn(amazonSideAsn: Long): FluentBuilder
        /**
         * The ID of the default association route table.
         */
        fun associationDefaultRouteTableId(associationDefaultRouteTableId: String): FluentBuilder
        /**
         * Indicates whether attachment requests are automatically accepted.
         */
        fun autoAcceptSharedAttachments(autoAcceptSharedAttachments: AutoAcceptSharedAttachmentsValue): FluentBuilder
        /**
         * Indicates whether resource attachments are automatically associated with the default association route table.
         */
        fun defaultRouteTableAssociation(defaultRouteTableAssociation: DefaultRouteTableAssociationValue): FluentBuilder
        /**
         * Indicates whether resource attachments automatically propagate routes to the default propagation route table.
         */
        fun defaultRouteTablePropagation(defaultRouteTablePropagation: DefaultRouteTablePropagationValue): FluentBuilder
        /**
         * Indicates whether DNS support is enabled.
         */
        fun dnsSupport(dnsSupport: DnsSupportValue): FluentBuilder
        /**
         * Indicates whether multicast is enabled on the transit gateway
         */
        fun multicastSupport(multicastSupport: MulticastSupportValue): FluentBuilder
        /**
         * The ID of the default propagation route table.
         */
        fun propagationDefaultRouteTableId(propagationDefaultRouteTableId: String): FluentBuilder
        /**
         * The transit gateway CIDR blocks.
         */
        fun transitGatewayCidrBlocks(transitGatewayCidrBlocks: List<String>): FluentBuilder
        /**
         * Indicates whether Equal Cost Multipath Protocol support is enabled.
         */
        fun vpnEcmpSupport(vpnEcmpSupport: VpnEcmpSupportValue): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A private Autonomous System Number (ASN) for the Amazon side of a BGP session.
         * The range is 64512 to 65534 for 16-bit ASNs and 4200000000 to 4294967294 for 32-bit ASNs.
         */
        var amazonSideAsn: Long?
        /**
         * The ID of the default association route table.
         */
        var associationDefaultRouteTableId: String?
        /**
         * Indicates whether attachment requests are automatically accepted.
         */
        var autoAcceptSharedAttachments: AutoAcceptSharedAttachmentsValue?
        /**
         * Indicates whether resource attachments are automatically associated with the default association route table.
         */
        var defaultRouteTableAssociation: DefaultRouteTableAssociationValue?
        /**
         * Indicates whether resource attachments automatically propagate routes to the default propagation route table.
         */
        var defaultRouteTablePropagation: DefaultRouteTablePropagationValue?
        /**
         * Indicates whether DNS support is enabled.
         */
        var dnsSupport: DnsSupportValue?
        /**
         * Indicates whether multicast is enabled on the transit gateway
         */
        var multicastSupport: MulticastSupportValue?
        /**
         * The ID of the default propagation route table.
         */
        var propagationDefaultRouteTableId: String?
        /**
         * The transit gateway CIDR blocks.
         */
        var transitGatewayCidrBlocks: List<String>?
        /**
         * Indicates whether Equal Cost Multipath Protocol support is enabled.
         */
        var vpnEcmpSupport: VpnEcmpSupportValue?

        fun build(): TransitGatewayOptions
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var amazonSideAsn: Long? = null
        override var associationDefaultRouteTableId: String? = null
        override var autoAcceptSharedAttachments: AutoAcceptSharedAttachmentsValue? = null
        override var defaultRouteTableAssociation: DefaultRouteTableAssociationValue? = null
        override var defaultRouteTablePropagation: DefaultRouteTablePropagationValue? = null
        override var dnsSupport: DnsSupportValue? = null
        override var multicastSupport: MulticastSupportValue? = null
        override var propagationDefaultRouteTableId: String? = null
        override var transitGatewayCidrBlocks: List<String>? = null
        override var vpnEcmpSupport: VpnEcmpSupportValue? = null

        constructor(x: TransitGatewayOptions) : this() {
            this.amazonSideAsn = x.amazonSideAsn
            this.associationDefaultRouteTableId = x.associationDefaultRouteTableId
            this.autoAcceptSharedAttachments = x.autoAcceptSharedAttachments
            this.defaultRouteTableAssociation = x.defaultRouteTableAssociation
            this.defaultRouteTablePropagation = x.defaultRouteTablePropagation
            this.dnsSupport = x.dnsSupport
            this.multicastSupport = x.multicastSupport
            this.propagationDefaultRouteTableId = x.propagationDefaultRouteTableId
            this.transitGatewayCidrBlocks = x.transitGatewayCidrBlocks
            this.vpnEcmpSupport = x.vpnEcmpSupport
        }

        override fun build(): TransitGatewayOptions = TransitGatewayOptions(this)
        override fun amazonSideAsn(amazonSideAsn: Long): FluentBuilder = apply { this.amazonSideAsn = amazonSideAsn }
        override fun associationDefaultRouteTableId(associationDefaultRouteTableId: String): FluentBuilder = apply { this.associationDefaultRouteTableId = associationDefaultRouteTableId }
        override fun autoAcceptSharedAttachments(autoAcceptSharedAttachments: AutoAcceptSharedAttachmentsValue): FluentBuilder = apply { this.autoAcceptSharedAttachments = autoAcceptSharedAttachments }
        override fun defaultRouteTableAssociation(defaultRouteTableAssociation: DefaultRouteTableAssociationValue): FluentBuilder = apply { this.defaultRouteTableAssociation = defaultRouteTableAssociation }
        override fun defaultRouteTablePropagation(defaultRouteTablePropagation: DefaultRouteTablePropagationValue): FluentBuilder = apply { this.defaultRouteTablePropagation = defaultRouteTablePropagation }
        override fun dnsSupport(dnsSupport: DnsSupportValue): FluentBuilder = apply { this.dnsSupport = dnsSupport }
        override fun multicastSupport(multicastSupport: MulticastSupportValue): FluentBuilder = apply { this.multicastSupport = multicastSupport }
        override fun propagationDefaultRouteTableId(propagationDefaultRouteTableId: String): FluentBuilder = apply { this.propagationDefaultRouteTableId = propagationDefaultRouteTableId }
        override fun transitGatewayCidrBlocks(transitGatewayCidrBlocks: List<String>): FluentBuilder = apply { this.transitGatewayCidrBlocks = transitGatewayCidrBlocks }
        override fun vpnEcmpSupport(vpnEcmpSupport: VpnEcmpSupportValue): FluentBuilder = apply { this.vpnEcmpSupport = vpnEcmpSupport }
    }
}
