// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes the transit gateway peering attachment.
 */
class TransitGatewayPeeringAttachment private constructor(builder: BuilderImpl) {
    /**
     * Information about the accepter transit gateway.
     */
    val accepterTgwInfo: PeeringTgwInfo? = builder.accepterTgwInfo
    /**
     * The time the transit gateway peering attachment was created.
     */
    val creationTime: Instant? = builder.creationTime
    /**
     * Information about the requester transit gateway.
     */
    val requesterTgwInfo: PeeringTgwInfo? = builder.requesterTgwInfo
    /**
     * The state of the transit gateway peering attachment. Note that the initiating state has been deprecated.
     */
    val state: TransitGatewayAttachmentState? = builder.state
    /**
     * The status of the transit gateway peering attachment.
     */
    val status: PeeringAttachmentStatus? = builder.status
    /**
     * The tags for the transit gateway peering attachment.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The ID of the transit gateway peering attachment.
     */
    val transitGatewayAttachmentId: String? = builder.transitGatewayAttachmentId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): TransitGatewayPeeringAttachment = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("TransitGatewayPeeringAttachment(")
        append("accepterTgwInfo=$accepterTgwInfo,")
        append("creationTime=$creationTime,")
        append("requesterTgwInfo=$requesterTgwInfo,")
        append("state=$state,")
        append("status=$status,")
        append("tags=$tags,")
        append("transitGatewayAttachmentId=$transitGatewayAttachmentId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accepterTgwInfo?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (requesterTgwInfo?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (transitGatewayAttachmentId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as TransitGatewayPeeringAttachment

        if (accepterTgwInfo != other.accepterTgwInfo) return false
        if (creationTime != other.creationTime) return false
        if (requesterTgwInfo != other.requesterTgwInfo) return false
        if (state != other.state) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (transitGatewayAttachmentId != other.transitGatewayAttachmentId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): TransitGatewayPeeringAttachment = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): TransitGatewayPeeringAttachment
        /**
         * Information about the accepter transit gateway.
         */
        fun accepterTgwInfo(accepterTgwInfo: PeeringTgwInfo): FluentBuilder
        /**
         * The time the transit gateway peering attachment was created.
         */
        fun creationTime(creationTime: Instant): FluentBuilder
        /**
         * Information about the requester transit gateway.
         */
        fun requesterTgwInfo(requesterTgwInfo: PeeringTgwInfo): FluentBuilder
        /**
         * The state of the transit gateway peering attachment. Note that the initiating state has been deprecated.
         */
        fun state(state: TransitGatewayAttachmentState): FluentBuilder
        /**
         * The status of the transit gateway peering attachment.
         */
        fun status(status: PeeringAttachmentStatus): FluentBuilder
        /**
         * The tags for the transit gateway peering attachment.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * The ID of the transit gateway peering attachment.
         */
        fun transitGatewayAttachmentId(transitGatewayAttachmentId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Information about the accepter transit gateway.
         */
        var accepterTgwInfo: PeeringTgwInfo?
        /**
         * The time the transit gateway peering attachment was created.
         */
        var creationTime: Instant?
        /**
         * Information about the requester transit gateway.
         */
        var requesterTgwInfo: PeeringTgwInfo?
        /**
         * The state of the transit gateway peering attachment. Note that the initiating state has been deprecated.
         */
        var state: TransitGatewayAttachmentState?
        /**
         * The status of the transit gateway peering attachment.
         */
        var status: PeeringAttachmentStatus?
        /**
         * The tags for the transit gateway peering attachment.
         */
        var tags: List<Tag>?
        /**
         * The ID of the transit gateway peering attachment.
         */
        var transitGatewayAttachmentId: String?

        fun build(): TransitGatewayPeeringAttachment
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.PeeringTgwInfo] inside the given [block]
         */
        fun accepterTgwInfo(block: PeeringTgwInfo.DslBuilder.() -> kotlin.Unit) {
            this.accepterTgwInfo = PeeringTgwInfo.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.PeeringTgwInfo] inside the given [block]
         */
        fun requesterTgwInfo(block: PeeringTgwInfo.DslBuilder.() -> kotlin.Unit) {
            this.requesterTgwInfo = PeeringTgwInfo.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.PeeringAttachmentStatus] inside the given [block]
         */
        fun status(block: PeeringAttachmentStatus.DslBuilder.() -> kotlin.Unit) {
            this.status = PeeringAttachmentStatus.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var accepterTgwInfo: PeeringTgwInfo? = null
        override var creationTime: Instant? = null
        override var requesterTgwInfo: PeeringTgwInfo? = null
        override var state: TransitGatewayAttachmentState? = null
        override var status: PeeringAttachmentStatus? = null
        override var tags: List<Tag>? = null
        override var transitGatewayAttachmentId: String? = null

        constructor(x: TransitGatewayPeeringAttachment) : this() {
            this.accepterTgwInfo = x.accepterTgwInfo
            this.creationTime = x.creationTime
            this.requesterTgwInfo = x.requesterTgwInfo
            this.state = x.state
            this.status = x.status
            this.tags = x.tags
            this.transitGatewayAttachmentId = x.transitGatewayAttachmentId
        }

        override fun build(): TransitGatewayPeeringAttachment = TransitGatewayPeeringAttachment(this)
        override fun accepterTgwInfo(accepterTgwInfo: PeeringTgwInfo): FluentBuilder = apply { this.accepterTgwInfo = accepterTgwInfo }
        override fun creationTime(creationTime: Instant): FluentBuilder = apply { this.creationTime = creationTime }
        override fun requesterTgwInfo(requesterTgwInfo: PeeringTgwInfo): FluentBuilder = apply { this.requesterTgwInfo = requesterTgwInfo }
        override fun state(state: TransitGatewayAttachmentState): FluentBuilder = apply { this.state = state }
        override fun status(status: PeeringAttachmentStatus): FluentBuilder = apply { this.status = status }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun transitGatewayAttachmentId(transitGatewayAttachmentId: String): FluentBuilder = apply { this.transitGatewayAttachmentId = transitGatewayAttachmentId }
    }
}
