// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes route propagation.
 */
class TransitGatewayPropagation private constructor(builder: BuilderImpl) {
    /**
     * The ID of the resource.
     */
    val resourceId: String? = builder.resourceId
    /**
     * The resource type. Note that the tgw-peering resource type has been deprecated.
     */
    val resourceType: TransitGatewayAttachmentResourceType? = builder.resourceType
    /**
     * The state.
     */
    val state: TransitGatewayPropagationState? = builder.state
    /**
     * The ID of the attachment.
     */
    val transitGatewayAttachmentId: String? = builder.transitGatewayAttachmentId
    /**
     * The ID of the transit gateway route table.
     */
    val transitGatewayRouteTableId: String? = builder.transitGatewayRouteTableId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): TransitGatewayPropagation = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("TransitGatewayPropagation(")
        append("resourceId=$resourceId,")
        append("resourceType=$resourceType,")
        append("state=$state,")
        append("transitGatewayAttachmentId=$transitGatewayAttachmentId,")
        append("transitGatewayRouteTableId=$transitGatewayRouteTableId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = resourceId?.hashCode() ?: 0
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (transitGatewayAttachmentId?.hashCode() ?: 0)
        result = 31 * result + (transitGatewayRouteTableId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as TransitGatewayPropagation

        if (resourceId != other.resourceId) return false
        if (resourceType != other.resourceType) return false
        if (state != other.state) return false
        if (transitGatewayAttachmentId != other.transitGatewayAttachmentId) return false
        if (transitGatewayRouteTableId != other.transitGatewayRouteTableId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): TransitGatewayPropagation = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): TransitGatewayPropagation
        /**
         * The ID of the resource.
         */
        fun resourceId(resourceId: String): FluentBuilder
        /**
         * The resource type. Note that the tgw-peering resource type has been deprecated.
         */
        fun resourceType(resourceType: TransitGatewayAttachmentResourceType): FluentBuilder
        /**
         * The state.
         */
        fun state(state: TransitGatewayPropagationState): FluentBuilder
        /**
         * The ID of the attachment.
         */
        fun transitGatewayAttachmentId(transitGatewayAttachmentId: String): FluentBuilder
        /**
         * The ID of the transit gateway route table.
         */
        fun transitGatewayRouteTableId(transitGatewayRouteTableId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ID of the resource.
         */
        var resourceId: String?
        /**
         * The resource type. Note that the tgw-peering resource type has been deprecated.
         */
        var resourceType: TransitGatewayAttachmentResourceType?
        /**
         * The state.
         */
        var state: TransitGatewayPropagationState?
        /**
         * The ID of the attachment.
         */
        var transitGatewayAttachmentId: String?
        /**
         * The ID of the transit gateway route table.
         */
        var transitGatewayRouteTableId: String?

        fun build(): TransitGatewayPropagation
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var resourceId: String? = null
        override var resourceType: TransitGatewayAttachmentResourceType? = null
        override var state: TransitGatewayPropagationState? = null
        override var transitGatewayAttachmentId: String? = null
        override var transitGatewayRouteTableId: String? = null

        constructor(x: TransitGatewayPropagation) : this() {
            this.resourceId = x.resourceId
            this.resourceType = x.resourceType
            this.state = x.state
            this.transitGatewayAttachmentId = x.transitGatewayAttachmentId
            this.transitGatewayRouteTableId = x.transitGatewayRouteTableId
        }

        override fun build(): TransitGatewayPropagation = TransitGatewayPropagation(this)
        override fun resourceId(resourceId: String): FluentBuilder = apply { this.resourceId = resourceId }
        override fun resourceType(resourceType: TransitGatewayAttachmentResourceType): FluentBuilder = apply { this.resourceType = resourceType }
        override fun state(state: TransitGatewayPropagationState): FluentBuilder = apply { this.state = state }
        override fun transitGatewayAttachmentId(transitGatewayAttachmentId: String): FluentBuilder = apply { this.transitGatewayAttachmentId = transitGatewayAttachmentId }
        override fun transitGatewayRouteTableId(transitGatewayRouteTableId: String): FluentBuilder = apply { this.transitGatewayRouteTableId = transitGatewayRouteTableId }
    }
}
