// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the options for a transit gateway.
 */
class TransitGatewayRequestOptions private constructor(builder: BuilderImpl) {
    /**
     * A private Autonomous System Number (ASN) for the Amazon side of a BGP session.
     * The range is 64512 to 65534 for 16-bit ASNs and 4200000000 to 4294967294 for 32-bit ASNs. The default is 64512.
     */
    val amazonSideAsn: Long? = builder.amazonSideAsn
    /**
     * Enable or disable automatic acceptance of attachment requests. Disabled by default.
     */
    val autoAcceptSharedAttachments: AutoAcceptSharedAttachmentsValue? = builder.autoAcceptSharedAttachments
    /**
     * Enable or disable automatic association with the default association route table. Enabled by default.
     */
    val defaultRouteTableAssociation: DefaultRouteTableAssociationValue? = builder.defaultRouteTableAssociation
    /**
     * Enable or disable automatic propagation of routes to the default propagation route table. Enabled by default.
     */
    val defaultRouteTablePropagation: DefaultRouteTablePropagationValue? = builder.defaultRouteTablePropagation
    /**
     * Enable or disable DNS support. Enabled by default.
     */
    val dnsSupport: DnsSupportValue? = builder.dnsSupport
    /**
     * Indicates whether multicast is enabled on the transit gateway
     */
    val multicastSupport: MulticastSupportValue? = builder.multicastSupport
    /**
     * One or more IPv4 or IPv6 CIDR blocks for the transit gateway. Must be a size /24 CIDR block or larger for IPv4, or a size /64 CIDR block or larger for IPv6.
     */
    val transitGatewayCidrBlocks: List<String>? = builder.transitGatewayCidrBlocks
    /**
     * Enable or disable Equal Cost Multipath Protocol support. Enabled by default.
     */
    val vpnEcmpSupport: VpnEcmpSupportValue? = builder.vpnEcmpSupport

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): TransitGatewayRequestOptions = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("TransitGatewayRequestOptions(")
        append("amazonSideAsn=$amazonSideAsn,")
        append("autoAcceptSharedAttachments=$autoAcceptSharedAttachments,")
        append("defaultRouteTableAssociation=$defaultRouteTableAssociation,")
        append("defaultRouteTablePropagation=$defaultRouteTablePropagation,")
        append("dnsSupport=$dnsSupport,")
        append("multicastSupport=$multicastSupport,")
        append("transitGatewayCidrBlocks=$transitGatewayCidrBlocks,")
        append("vpnEcmpSupport=$vpnEcmpSupport)")
    }

    override fun hashCode(): kotlin.Int {
        var result = amazonSideAsn?.hashCode() ?: 0
        result = 31 * result + (autoAcceptSharedAttachments?.hashCode() ?: 0)
        result = 31 * result + (defaultRouteTableAssociation?.hashCode() ?: 0)
        result = 31 * result + (defaultRouteTablePropagation?.hashCode() ?: 0)
        result = 31 * result + (dnsSupport?.hashCode() ?: 0)
        result = 31 * result + (multicastSupport?.hashCode() ?: 0)
        result = 31 * result + (transitGatewayCidrBlocks?.hashCode() ?: 0)
        result = 31 * result + (vpnEcmpSupport?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as TransitGatewayRequestOptions

        if (amazonSideAsn != other.amazonSideAsn) return false
        if (autoAcceptSharedAttachments != other.autoAcceptSharedAttachments) return false
        if (defaultRouteTableAssociation != other.defaultRouteTableAssociation) return false
        if (defaultRouteTablePropagation != other.defaultRouteTablePropagation) return false
        if (dnsSupport != other.dnsSupport) return false
        if (multicastSupport != other.multicastSupport) return false
        if (transitGatewayCidrBlocks != other.transitGatewayCidrBlocks) return false
        if (vpnEcmpSupport != other.vpnEcmpSupport) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): TransitGatewayRequestOptions = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): TransitGatewayRequestOptions
        /**
         * A private Autonomous System Number (ASN) for the Amazon side of a BGP session.
         * The range is 64512 to 65534 for 16-bit ASNs and 4200000000 to 4294967294 for 32-bit ASNs. The default is 64512.
         */
        fun amazonSideAsn(amazonSideAsn: Long): FluentBuilder
        /**
         * Enable or disable automatic acceptance of attachment requests. Disabled by default.
         */
        fun autoAcceptSharedAttachments(autoAcceptSharedAttachments: AutoAcceptSharedAttachmentsValue): FluentBuilder
        /**
         * Enable or disable automatic association with the default association route table. Enabled by default.
         */
        fun defaultRouteTableAssociation(defaultRouteTableAssociation: DefaultRouteTableAssociationValue): FluentBuilder
        /**
         * Enable or disable automatic propagation of routes to the default propagation route table. Enabled by default.
         */
        fun defaultRouteTablePropagation(defaultRouteTablePropagation: DefaultRouteTablePropagationValue): FluentBuilder
        /**
         * Enable or disable DNS support. Enabled by default.
         */
        fun dnsSupport(dnsSupport: DnsSupportValue): FluentBuilder
        /**
         * Indicates whether multicast is enabled on the transit gateway
         */
        fun multicastSupport(multicastSupport: MulticastSupportValue): FluentBuilder
        /**
         * One or more IPv4 or IPv6 CIDR blocks for the transit gateway. Must be a size /24 CIDR block or larger for IPv4, or a size /64 CIDR block or larger for IPv6.
         */
        fun transitGatewayCidrBlocks(transitGatewayCidrBlocks: List<String>): FluentBuilder
        /**
         * Enable or disable Equal Cost Multipath Protocol support. Enabled by default.
         */
        fun vpnEcmpSupport(vpnEcmpSupport: VpnEcmpSupportValue): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A private Autonomous System Number (ASN) for the Amazon side of a BGP session.
         * The range is 64512 to 65534 for 16-bit ASNs and 4200000000 to 4294967294 for 32-bit ASNs. The default is 64512.
         */
        var amazonSideAsn: Long?
        /**
         * Enable or disable automatic acceptance of attachment requests. Disabled by default.
         */
        var autoAcceptSharedAttachments: AutoAcceptSharedAttachmentsValue?
        /**
         * Enable or disable automatic association with the default association route table. Enabled by default.
         */
        var defaultRouteTableAssociation: DefaultRouteTableAssociationValue?
        /**
         * Enable or disable automatic propagation of routes to the default propagation route table. Enabled by default.
         */
        var defaultRouteTablePropagation: DefaultRouteTablePropagationValue?
        /**
         * Enable or disable DNS support. Enabled by default.
         */
        var dnsSupport: DnsSupportValue?
        /**
         * Indicates whether multicast is enabled on the transit gateway
         */
        var multicastSupport: MulticastSupportValue?
        /**
         * One or more IPv4 or IPv6 CIDR blocks for the transit gateway. Must be a size /24 CIDR block or larger for IPv4, or a size /64 CIDR block or larger for IPv6.
         */
        var transitGatewayCidrBlocks: List<String>?
        /**
         * Enable or disable Equal Cost Multipath Protocol support. Enabled by default.
         */
        var vpnEcmpSupport: VpnEcmpSupportValue?

        fun build(): TransitGatewayRequestOptions
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var amazonSideAsn: Long? = null
        override var autoAcceptSharedAttachments: AutoAcceptSharedAttachmentsValue? = null
        override var defaultRouteTableAssociation: DefaultRouteTableAssociationValue? = null
        override var defaultRouteTablePropagation: DefaultRouteTablePropagationValue? = null
        override var dnsSupport: DnsSupportValue? = null
        override var multicastSupport: MulticastSupportValue? = null
        override var transitGatewayCidrBlocks: List<String>? = null
        override var vpnEcmpSupport: VpnEcmpSupportValue? = null

        constructor(x: TransitGatewayRequestOptions) : this() {
            this.amazonSideAsn = x.amazonSideAsn
            this.autoAcceptSharedAttachments = x.autoAcceptSharedAttachments
            this.defaultRouteTableAssociation = x.defaultRouteTableAssociation
            this.defaultRouteTablePropagation = x.defaultRouteTablePropagation
            this.dnsSupport = x.dnsSupport
            this.multicastSupport = x.multicastSupport
            this.transitGatewayCidrBlocks = x.transitGatewayCidrBlocks
            this.vpnEcmpSupport = x.vpnEcmpSupport
        }

        override fun build(): TransitGatewayRequestOptions = TransitGatewayRequestOptions(this)
        override fun amazonSideAsn(amazonSideAsn: Long): FluentBuilder = apply { this.amazonSideAsn = amazonSideAsn }
        override fun autoAcceptSharedAttachments(autoAcceptSharedAttachments: AutoAcceptSharedAttachmentsValue): FluentBuilder = apply { this.autoAcceptSharedAttachments = autoAcceptSharedAttachments }
        override fun defaultRouteTableAssociation(defaultRouteTableAssociation: DefaultRouteTableAssociationValue): FluentBuilder = apply { this.defaultRouteTableAssociation = defaultRouteTableAssociation }
        override fun defaultRouteTablePropagation(defaultRouteTablePropagation: DefaultRouteTablePropagationValue): FluentBuilder = apply { this.defaultRouteTablePropagation = defaultRouteTablePropagation }
        override fun dnsSupport(dnsSupport: DnsSupportValue): FluentBuilder = apply { this.dnsSupport = dnsSupport }
        override fun multicastSupport(multicastSupport: MulticastSupportValue): FluentBuilder = apply { this.multicastSupport = multicastSupport }
        override fun transitGatewayCidrBlocks(transitGatewayCidrBlocks: List<String>): FluentBuilder = apply { this.transitGatewayCidrBlocks = transitGatewayCidrBlocks }
        override fun vpnEcmpSupport(vpnEcmpSupport: VpnEcmpSupportValue): FluentBuilder = apply { this.vpnEcmpSupport = vpnEcmpSupport }
    }
}
