// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a transit gateway route table.
 */
class TransitGatewayRouteTable private constructor(builder: BuilderImpl) {
    /**
     * The creation time.
     */
    val creationTime: Instant? = builder.creationTime
    /**
     * Indicates whether this is the default association route table for the transit gateway.
     */
    val defaultAssociationRouteTable: Boolean? = builder.defaultAssociationRouteTable
    /**
     * Indicates whether this is the default propagation route table for the transit gateway.
     */
    val defaultPropagationRouteTable: Boolean? = builder.defaultPropagationRouteTable
    /**
     * The state of the transit gateway route table.
     */
    val state: TransitGatewayRouteTableState? = builder.state
    /**
     * Any tags assigned to the route table.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The ID of the transit gateway.
     */
    val transitGatewayId: String? = builder.transitGatewayId
    /**
     * The ID of the transit gateway route table.
     */
    val transitGatewayRouteTableId: String? = builder.transitGatewayRouteTableId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): TransitGatewayRouteTable = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("TransitGatewayRouteTable(")
        append("creationTime=$creationTime,")
        append("defaultAssociationRouteTable=$defaultAssociationRouteTable,")
        append("defaultPropagationRouteTable=$defaultPropagationRouteTable,")
        append("state=$state,")
        append("tags=$tags,")
        append("transitGatewayId=$transitGatewayId,")
        append("transitGatewayRouteTableId=$transitGatewayRouteTableId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (defaultAssociationRouteTable?.hashCode() ?: 0)
        result = 31 * result + (defaultPropagationRouteTable?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (transitGatewayId?.hashCode() ?: 0)
        result = 31 * result + (transitGatewayRouteTableId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as TransitGatewayRouteTable

        if (creationTime != other.creationTime) return false
        if (defaultAssociationRouteTable != other.defaultAssociationRouteTable) return false
        if (defaultPropagationRouteTable != other.defaultPropagationRouteTable) return false
        if (state != other.state) return false
        if (tags != other.tags) return false
        if (transitGatewayId != other.transitGatewayId) return false
        if (transitGatewayRouteTableId != other.transitGatewayRouteTableId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): TransitGatewayRouteTable = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): TransitGatewayRouteTable
        /**
         * The creation time.
         */
        fun creationTime(creationTime: Instant): FluentBuilder
        /**
         * Indicates whether this is the default association route table for the transit gateway.
         */
        fun defaultAssociationRouteTable(defaultAssociationRouteTable: Boolean): FluentBuilder
        /**
         * Indicates whether this is the default propagation route table for the transit gateway.
         */
        fun defaultPropagationRouteTable(defaultPropagationRouteTable: Boolean): FluentBuilder
        /**
         * The state of the transit gateway route table.
         */
        fun state(state: TransitGatewayRouteTableState): FluentBuilder
        /**
         * Any tags assigned to the route table.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * The ID of the transit gateway.
         */
        fun transitGatewayId(transitGatewayId: String): FluentBuilder
        /**
         * The ID of the transit gateway route table.
         */
        fun transitGatewayRouteTableId(transitGatewayRouteTableId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The creation time.
         */
        var creationTime: Instant?
        /**
         * Indicates whether this is the default association route table for the transit gateway.
         */
        var defaultAssociationRouteTable: Boolean?
        /**
         * Indicates whether this is the default propagation route table for the transit gateway.
         */
        var defaultPropagationRouteTable: Boolean?
        /**
         * The state of the transit gateway route table.
         */
        var state: TransitGatewayRouteTableState?
        /**
         * Any tags assigned to the route table.
         */
        var tags: List<Tag>?
        /**
         * The ID of the transit gateway.
         */
        var transitGatewayId: String?
        /**
         * The ID of the transit gateway route table.
         */
        var transitGatewayRouteTableId: String?

        fun build(): TransitGatewayRouteTable
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var creationTime: Instant? = null
        override var defaultAssociationRouteTable: Boolean? = null
        override var defaultPropagationRouteTable: Boolean? = null
        override var state: TransitGatewayRouteTableState? = null
        override var tags: List<Tag>? = null
        override var transitGatewayId: String? = null
        override var transitGatewayRouteTableId: String? = null

        constructor(x: TransitGatewayRouteTable) : this() {
            this.creationTime = x.creationTime
            this.defaultAssociationRouteTable = x.defaultAssociationRouteTable
            this.defaultPropagationRouteTable = x.defaultPropagationRouteTable
            this.state = x.state
            this.tags = x.tags
            this.transitGatewayId = x.transitGatewayId
            this.transitGatewayRouteTableId = x.transitGatewayRouteTableId
        }

        override fun build(): TransitGatewayRouteTable = TransitGatewayRouteTable(this)
        override fun creationTime(creationTime: Instant): FluentBuilder = apply { this.creationTime = creationTime }
        override fun defaultAssociationRouteTable(defaultAssociationRouteTable: Boolean): FluentBuilder = apply { this.defaultAssociationRouteTable = defaultAssociationRouteTable }
        override fun defaultPropagationRouteTable(defaultPropagationRouteTable: Boolean): FluentBuilder = apply { this.defaultPropagationRouteTable = defaultPropagationRouteTable }
        override fun state(state: TransitGatewayRouteTableState): FluentBuilder = apply { this.state = state }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun transitGatewayId(transitGatewayId: String): FluentBuilder = apply { this.transitGatewayId = transitGatewayId }
        override fun transitGatewayRouteTableId(transitGatewayRouteTableId: String): FluentBuilder = apply { this.transitGatewayRouteTableId = transitGatewayRouteTableId }
    }
}
