// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a VPC attachment.
 */
class TransitGatewayVpcAttachment private constructor(builder: BuilderImpl) {
    /**
     * The creation time.
     */
    val creationTime: Instant? = builder.creationTime
    /**
     * The VPC attachment options.
     */
    val options: TransitGatewayVpcAttachmentOptions? = builder.options
    /**
     * The state of the VPC attachment. Note that the initiating state has been deprecated.
     */
    val state: TransitGatewayAttachmentState? = builder.state
    /**
     * The IDs of the subnets.
     */
    val subnetIds: List<String>? = builder.subnetIds
    /**
     * The tags for the VPC attachment.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The ID of the attachment.
     */
    val transitGatewayAttachmentId: String? = builder.transitGatewayAttachmentId
    /**
     * The ID of the transit gateway.
     */
    val transitGatewayId: String? = builder.transitGatewayId
    /**
     * The ID of the VPC.
     */
    val vpcId: String? = builder.vpcId
    /**
     * The ID of the Amazon Web Services account that owns the VPC.
     */
    val vpcOwnerId: String? = builder.vpcOwnerId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): TransitGatewayVpcAttachment = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("TransitGatewayVpcAttachment(")
        append("creationTime=$creationTime,")
        append("options=$options,")
        append("state=$state,")
        append("subnetIds=$subnetIds,")
        append("tags=$tags,")
        append("transitGatewayAttachmentId=$transitGatewayAttachmentId,")
        append("transitGatewayId=$transitGatewayId,")
        append("vpcId=$vpcId,")
        append("vpcOwnerId=$vpcOwnerId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTime?.hashCode() ?: 0
        result = 31 * result + (options?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (transitGatewayAttachmentId?.hashCode() ?: 0)
        result = 31 * result + (transitGatewayId?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        result = 31 * result + (vpcOwnerId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as TransitGatewayVpcAttachment

        if (creationTime != other.creationTime) return false
        if (options != other.options) return false
        if (state != other.state) return false
        if (subnetIds != other.subnetIds) return false
        if (tags != other.tags) return false
        if (transitGatewayAttachmentId != other.transitGatewayAttachmentId) return false
        if (transitGatewayId != other.transitGatewayId) return false
        if (vpcId != other.vpcId) return false
        if (vpcOwnerId != other.vpcOwnerId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): TransitGatewayVpcAttachment = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): TransitGatewayVpcAttachment
        /**
         * The creation time.
         */
        fun creationTime(creationTime: Instant): FluentBuilder
        /**
         * The VPC attachment options.
         */
        fun options(options: TransitGatewayVpcAttachmentOptions): FluentBuilder
        /**
         * The state of the VPC attachment. Note that the initiating state has been deprecated.
         */
        fun state(state: TransitGatewayAttachmentState): FluentBuilder
        /**
         * The IDs of the subnets.
         */
        fun subnetIds(subnetIds: List<String>): FluentBuilder
        /**
         * The tags for the VPC attachment.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * The ID of the attachment.
         */
        fun transitGatewayAttachmentId(transitGatewayAttachmentId: String): FluentBuilder
        /**
         * The ID of the transit gateway.
         */
        fun transitGatewayId(transitGatewayId: String): FluentBuilder
        /**
         * The ID of the VPC.
         */
        fun vpcId(vpcId: String): FluentBuilder
        /**
         * The ID of the Amazon Web Services account that owns the VPC.
         */
        fun vpcOwnerId(vpcOwnerId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The creation time.
         */
        var creationTime: Instant?
        /**
         * The VPC attachment options.
         */
        var options: TransitGatewayVpcAttachmentOptions?
        /**
         * The state of the VPC attachment. Note that the initiating state has been deprecated.
         */
        var state: TransitGatewayAttachmentState?
        /**
         * The IDs of the subnets.
         */
        var subnetIds: List<String>?
        /**
         * The tags for the VPC attachment.
         */
        var tags: List<Tag>?
        /**
         * The ID of the attachment.
         */
        var transitGatewayAttachmentId: String?
        /**
         * The ID of the transit gateway.
         */
        var transitGatewayId: String?
        /**
         * The ID of the VPC.
         */
        var vpcId: String?
        /**
         * The ID of the Amazon Web Services account that owns the VPC.
         */
        var vpcOwnerId: String?

        fun build(): TransitGatewayVpcAttachment
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.TransitGatewayVpcAttachmentOptions] inside the given [block]
         */
        fun options(block: TransitGatewayVpcAttachmentOptions.DslBuilder.() -> kotlin.Unit) {
            this.options = TransitGatewayVpcAttachmentOptions.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var creationTime: Instant? = null
        override var options: TransitGatewayVpcAttachmentOptions? = null
        override var state: TransitGatewayAttachmentState? = null
        override var subnetIds: List<String>? = null
        override var tags: List<Tag>? = null
        override var transitGatewayAttachmentId: String? = null
        override var transitGatewayId: String? = null
        override var vpcId: String? = null
        override var vpcOwnerId: String? = null

        constructor(x: TransitGatewayVpcAttachment) : this() {
            this.creationTime = x.creationTime
            this.options = x.options
            this.state = x.state
            this.subnetIds = x.subnetIds
            this.tags = x.tags
            this.transitGatewayAttachmentId = x.transitGatewayAttachmentId
            this.transitGatewayId = x.transitGatewayId
            this.vpcId = x.vpcId
            this.vpcOwnerId = x.vpcOwnerId
        }

        override fun build(): TransitGatewayVpcAttachment = TransitGatewayVpcAttachment(this)
        override fun creationTime(creationTime: Instant): FluentBuilder = apply { this.creationTime = creationTime }
        override fun options(options: TransitGatewayVpcAttachmentOptions): FluentBuilder = apply { this.options = options }
        override fun state(state: TransitGatewayAttachmentState): FluentBuilder = apply { this.state = state }
        override fun subnetIds(subnetIds: List<String>): FluentBuilder = apply { this.subnetIds = subnetIds }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun transitGatewayAttachmentId(transitGatewayAttachmentId: String): FluentBuilder = apply { this.transitGatewayAttachmentId = transitGatewayAttachmentId }
        override fun transitGatewayId(transitGatewayId: String): FluentBuilder = apply { this.transitGatewayId = transitGatewayId }
        override fun vpcId(vpcId: String): FluentBuilder = apply { this.vpcId = vpcId }
        override fun vpcOwnerId(vpcOwnerId: String): FluentBuilder = apply { this.vpcOwnerId = vpcOwnerId }
    }
}
