// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * The VPN tunnel options.
 */
class TunnelOption private constructor(builder: BuilderImpl) {
    /**
     * The action to take after a DPD timeout occurs.
     */
    val dpdTimeoutAction: String? = builder.dpdTimeoutAction
    /**
     * The number of seconds after which a DPD timeout occurs.
     */
    val dpdTimeoutSeconds: Int? = builder.dpdTimeoutSeconds
    /**
     * The IKE versions that are permitted for the VPN tunnel.
     */
    val ikeVersions: List<IkeVersionsListValue>? = builder.ikeVersions
    /**
     * The external IP address of the VPN tunnel.
     */
    val outsideIpAddress: String? = builder.outsideIpAddress
    /**
     * The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 1 IKE
     * negotiations.
     */
    val phase1DhGroupNumbers: List<Phase1DhGroupNumbersListValue>? = builder.phase1DhGroupNumbers
    /**
     * The permitted encryption algorithms for the VPN tunnel for phase 1 IKE
     * negotiations.
     */
    val phase1EncryptionAlgorithms: List<Phase1EncryptionAlgorithmsListValue>? = builder.phase1EncryptionAlgorithms
    /**
     * The permitted integrity algorithms for the VPN tunnel for phase 1 IKE
     * negotiations.
     */
    val phase1IntegrityAlgorithms: List<Phase1IntegrityAlgorithmsListValue>? = builder.phase1IntegrityAlgorithms
    /**
     * The lifetime for phase 1 of the IKE negotiation, in seconds.
     */
    val phase1LifetimeSeconds: Int? = builder.phase1LifetimeSeconds
    /**
     * The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 2 IKE
     * negotiations.
     */
    val phase2DhGroupNumbers: List<Phase2DhGroupNumbersListValue>? = builder.phase2DhGroupNumbers
    /**
     * The permitted encryption algorithms for the VPN tunnel for phase 2 IKE
     * negotiations.
     */
    val phase2EncryptionAlgorithms: List<Phase2EncryptionAlgorithmsListValue>? = builder.phase2EncryptionAlgorithms
    /**
     * The permitted integrity algorithms for the VPN tunnel for phase 2 IKE
     * negotiations.
     */
    val phase2IntegrityAlgorithms: List<Phase2IntegrityAlgorithmsListValue>? = builder.phase2IntegrityAlgorithms
    /**
     * The lifetime for phase 2 of the IKE negotiation, in seconds.
     */
    val phase2LifetimeSeconds: Int? = builder.phase2LifetimeSeconds
    /**
     * The pre-shared key (PSK) to establish initial authentication between the virtual
     * private gateway and the customer gateway.
     */
    val preSharedKey: String? = builder.preSharedKey
    /**
     * The percentage of the rekey window determined by RekeyMarginTimeSeconds
     * during which the rekey time is randomly selected.
     */
    val rekeyFuzzPercentage: Int? = builder.rekeyFuzzPercentage
    /**
     * The margin time, in seconds, before the phase 2 lifetime expires, during which the
     * Amazon Web Services side of the VPN connection performs an IKE rekey.
     */
    val rekeyMarginTimeSeconds: Int? = builder.rekeyMarginTimeSeconds
    /**
     * The number of packets in an IKE replay window.
     */
    val replayWindowSize: Int? = builder.replayWindowSize
    /**
     * The action to take when the establishing the VPN tunnels for a VPN connection.
     */
    val startupAction: String? = builder.startupAction
    /**
     * The range of inside IPv4 addresses for the tunnel.
     */
    val tunnelInsideCidr: String? = builder.tunnelInsideCidr
    /**
     * The range of inside IPv6 addresses for the tunnel.
     */
    val tunnelInsideIpv6Cidr: String? = builder.tunnelInsideIpv6Cidr

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): TunnelOption = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("TunnelOption(")
        append("dpdTimeoutAction=$dpdTimeoutAction,")
        append("dpdTimeoutSeconds=$dpdTimeoutSeconds,")
        append("ikeVersions=$ikeVersions,")
        append("outsideIpAddress=$outsideIpAddress,")
        append("phase1DhGroupNumbers=$phase1DhGroupNumbers,")
        append("phase1EncryptionAlgorithms=$phase1EncryptionAlgorithms,")
        append("phase1IntegrityAlgorithms=$phase1IntegrityAlgorithms,")
        append("phase1LifetimeSeconds=$phase1LifetimeSeconds,")
        append("phase2DhGroupNumbers=$phase2DhGroupNumbers,")
        append("phase2EncryptionAlgorithms=$phase2EncryptionAlgorithms,")
        append("phase2IntegrityAlgorithms=$phase2IntegrityAlgorithms,")
        append("phase2LifetimeSeconds=$phase2LifetimeSeconds,")
        append("preSharedKey=$preSharedKey,")
        append("rekeyFuzzPercentage=$rekeyFuzzPercentage,")
        append("rekeyMarginTimeSeconds=$rekeyMarginTimeSeconds,")
        append("replayWindowSize=$replayWindowSize,")
        append("startupAction=$startupAction,")
        append("tunnelInsideCidr=$tunnelInsideCidr,")
        append("tunnelInsideIpv6Cidr=$tunnelInsideIpv6Cidr)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dpdTimeoutAction?.hashCode() ?: 0
        result = 31 * result + (dpdTimeoutSeconds ?: 0)
        result = 31 * result + (ikeVersions?.hashCode() ?: 0)
        result = 31 * result + (outsideIpAddress?.hashCode() ?: 0)
        result = 31 * result + (phase1DhGroupNumbers?.hashCode() ?: 0)
        result = 31 * result + (phase1EncryptionAlgorithms?.hashCode() ?: 0)
        result = 31 * result + (phase1IntegrityAlgorithms?.hashCode() ?: 0)
        result = 31 * result + (phase1LifetimeSeconds ?: 0)
        result = 31 * result + (phase2DhGroupNumbers?.hashCode() ?: 0)
        result = 31 * result + (phase2EncryptionAlgorithms?.hashCode() ?: 0)
        result = 31 * result + (phase2IntegrityAlgorithms?.hashCode() ?: 0)
        result = 31 * result + (phase2LifetimeSeconds ?: 0)
        result = 31 * result + (preSharedKey?.hashCode() ?: 0)
        result = 31 * result + (rekeyFuzzPercentage ?: 0)
        result = 31 * result + (rekeyMarginTimeSeconds ?: 0)
        result = 31 * result + (replayWindowSize ?: 0)
        result = 31 * result + (startupAction?.hashCode() ?: 0)
        result = 31 * result + (tunnelInsideCidr?.hashCode() ?: 0)
        result = 31 * result + (tunnelInsideIpv6Cidr?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as TunnelOption

        if (dpdTimeoutAction != other.dpdTimeoutAction) return false
        if (dpdTimeoutSeconds != other.dpdTimeoutSeconds) return false
        if (ikeVersions != other.ikeVersions) return false
        if (outsideIpAddress != other.outsideIpAddress) return false
        if (phase1DhGroupNumbers != other.phase1DhGroupNumbers) return false
        if (phase1EncryptionAlgorithms != other.phase1EncryptionAlgorithms) return false
        if (phase1IntegrityAlgorithms != other.phase1IntegrityAlgorithms) return false
        if (phase1LifetimeSeconds != other.phase1LifetimeSeconds) return false
        if (phase2DhGroupNumbers != other.phase2DhGroupNumbers) return false
        if (phase2EncryptionAlgorithms != other.phase2EncryptionAlgorithms) return false
        if (phase2IntegrityAlgorithms != other.phase2IntegrityAlgorithms) return false
        if (phase2LifetimeSeconds != other.phase2LifetimeSeconds) return false
        if (preSharedKey != other.preSharedKey) return false
        if (rekeyFuzzPercentage != other.rekeyFuzzPercentage) return false
        if (rekeyMarginTimeSeconds != other.rekeyMarginTimeSeconds) return false
        if (replayWindowSize != other.replayWindowSize) return false
        if (startupAction != other.startupAction) return false
        if (tunnelInsideCidr != other.tunnelInsideCidr) return false
        if (tunnelInsideIpv6Cidr != other.tunnelInsideIpv6Cidr) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): TunnelOption = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): TunnelOption
        /**
         * The action to take after a DPD timeout occurs.
         */
        fun dpdTimeoutAction(dpdTimeoutAction: String): FluentBuilder
        /**
         * The number of seconds after which a DPD timeout occurs.
         */
        fun dpdTimeoutSeconds(dpdTimeoutSeconds: Int): FluentBuilder
        /**
         * The IKE versions that are permitted for the VPN tunnel.
         */
        fun ikeVersions(ikeVersions: List<IkeVersionsListValue>): FluentBuilder
        /**
         * The external IP address of the VPN tunnel.
         */
        fun outsideIpAddress(outsideIpAddress: String): FluentBuilder
        /**
         * The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 1 IKE
         * negotiations.
         */
        fun phase1DhGroupNumbers(phase1DhGroupNumbers: List<Phase1DhGroupNumbersListValue>): FluentBuilder
        /**
         * The permitted encryption algorithms for the VPN tunnel for phase 1 IKE
         * negotiations.
         */
        fun phase1EncryptionAlgorithms(phase1EncryptionAlgorithms: List<Phase1EncryptionAlgorithmsListValue>): FluentBuilder
        /**
         * The permitted integrity algorithms for the VPN tunnel for phase 1 IKE
         * negotiations.
         */
        fun phase1IntegrityAlgorithms(phase1IntegrityAlgorithms: List<Phase1IntegrityAlgorithmsListValue>): FluentBuilder
        /**
         * The lifetime for phase 1 of the IKE negotiation, in seconds.
         */
        fun phase1LifetimeSeconds(phase1LifetimeSeconds: Int): FluentBuilder
        /**
         * The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 2 IKE
         * negotiations.
         */
        fun phase2DhGroupNumbers(phase2DhGroupNumbers: List<Phase2DhGroupNumbersListValue>): FluentBuilder
        /**
         * The permitted encryption algorithms for the VPN tunnel for phase 2 IKE
         * negotiations.
         */
        fun phase2EncryptionAlgorithms(phase2EncryptionAlgorithms: List<Phase2EncryptionAlgorithmsListValue>): FluentBuilder
        /**
         * The permitted integrity algorithms for the VPN tunnel for phase 2 IKE
         * negotiations.
         */
        fun phase2IntegrityAlgorithms(phase2IntegrityAlgorithms: List<Phase2IntegrityAlgorithmsListValue>): FluentBuilder
        /**
         * The lifetime for phase 2 of the IKE negotiation, in seconds.
         */
        fun phase2LifetimeSeconds(phase2LifetimeSeconds: Int): FluentBuilder
        /**
         * The pre-shared key (PSK) to establish initial authentication between the virtual
         * private gateway and the customer gateway.
         */
        fun preSharedKey(preSharedKey: String): FluentBuilder
        /**
         * The percentage of the rekey window determined by RekeyMarginTimeSeconds
         * during which the rekey time is randomly selected.
         */
        fun rekeyFuzzPercentage(rekeyFuzzPercentage: Int): FluentBuilder
        /**
         * The margin time, in seconds, before the phase 2 lifetime expires, during which the
         * Amazon Web Services side of the VPN connection performs an IKE rekey.
         */
        fun rekeyMarginTimeSeconds(rekeyMarginTimeSeconds: Int): FluentBuilder
        /**
         * The number of packets in an IKE replay window.
         */
        fun replayWindowSize(replayWindowSize: Int): FluentBuilder
        /**
         * The action to take when the establishing the VPN tunnels for a VPN connection.
         */
        fun startupAction(startupAction: String): FluentBuilder
        /**
         * The range of inside IPv4 addresses for the tunnel.
         */
        fun tunnelInsideCidr(tunnelInsideCidr: String): FluentBuilder
        /**
         * The range of inside IPv6 addresses for the tunnel.
         */
        fun tunnelInsideIpv6Cidr(tunnelInsideIpv6Cidr: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The action to take after a DPD timeout occurs.
         */
        var dpdTimeoutAction: String?
        /**
         * The number of seconds after which a DPD timeout occurs.
         */
        var dpdTimeoutSeconds: Int?
        /**
         * The IKE versions that are permitted for the VPN tunnel.
         */
        var ikeVersions: List<IkeVersionsListValue>?
        /**
         * The external IP address of the VPN tunnel.
         */
        var outsideIpAddress: String?
        /**
         * The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 1 IKE
         * negotiations.
         */
        var phase1DhGroupNumbers: List<Phase1DhGroupNumbersListValue>?
        /**
         * The permitted encryption algorithms for the VPN tunnel for phase 1 IKE
         * negotiations.
         */
        var phase1EncryptionAlgorithms: List<Phase1EncryptionAlgorithmsListValue>?
        /**
         * The permitted integrity algorithms for the VPN tunnel for phase 1 IKE
         * negotiations.
         */
        var phase1IntegrityAlgorithms: List<Phase1IntegrityAlgorithmsListValue>?
        /**
         * The lifetime for phase 1 of the IKE negotiation, in seconds.
         */
        var phase1LifetimeSeconds: Int?
        /**
         * The permitted Diffie-Hellman group numbers for the VPN tunnel for phase 2 IKE
         * negotiations.
         */
        var phase2DhGroupNumbers: List<Phase2DhGroupNumbersListValue>?
        /**
         * The permitted encryption algorithms for the VPN tunnel for phase 2 IKE
         * negotiations.
         */
        var phase2EncryptionAlgorithms: List<Phase2EncryptionAlgorithmsListValue>?
        /**
         * The permitted integrity algorithms for the VPN tunnel for phase 2 IKE
         * negotiations.
         */
        var phase2IntegrityAlgorithms: List<Phase2IntegrityAlgorithmsListValue>?
        /**
         * The lifetime for phase 2 of the IKE negotiation, in seconds.
         */
        var phase2LifetimeSeconds: Int?
        /**
         * The pre-shared key (PSK) to establish initial authentication between the virtual
         * private gateway and the customer gateway.
         */
        var preSharedKey: String?
        /**
         * The percentage of the rekey window determined by RekeyMarginTimeSeconds
         * during which the rekey time is randomly selected.
         */
        var rekeyFuzzPercentage: Int?
        /**
         * The margin time, in seconds, before the phase 2 lifetime expires, during which the
         * Amazon Web Services side of the VPN connection performs an IKE rekey.
         */
        var rekeyMarginTimeSeconds: Int?
        /**
         * The number of packets in an IKE replay window.
         */
        var replayWindowSize: Int?
        /**
         * The action to take when the establishing the VPN tunnels for a VPN connection.
         */
        var startupAction: String?
        /**
         * The range of inside IPv4 addresses for the tunnel.
         */
        var tunnelInsideCidr: String?
        /**
         * The range of inside IPv6 addresses for the tunnel.
         */
        var tunnelInsideIpv6Cidr: String?

        fun build(): TunnelOption
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var dpdTimeoutAction: String? = null
        override var dpdTimeoutSeconds: Int? = null
        override var ikeVersions: List<IkeVersionsListValue>? = null
        override var outsideIpAddress: String? = null
        override var phase1DhGroupNumbers: List<Phase1DhGroupNumbersListValue>? = null
        override var phase1EncryptionAlgorithms: List<Phase1EncryptionAlgorithmsListValue>? = null
        override var phase1IntegrityAlgorithms: List<Phase1IntegrityAlgorithmsListValue>? = null
        override var phase1LifetimeSeconds: Int? = null
        override var phase2DhGroupNumbers: List<Phase2DhGroupNumbersListValue>? = null
        override var phase2EncryptionAlgorithms: List<Phase2EncryptionAlgorithmsListValue>? = null
        override var phase2IntegrityAlgorithms: List<Phase2IntegrityAlgorithmsListValue>? = null
        override var phase2LifetimeSeconds: Int? = null
        override var preSharedKey: String? = null
        override var rekeyFuzzPercentage: Int? = null
        override var rekeyMarginTimeSeconds: Int? = null
        override var replayWindowSize: Int? = null
        override var startupAction: String? = null
        override var tunnelInsideCidr: String? = null
        override var tunnelInsideIpv6Cidr: String? = null

        constructor(x: TunnelOption) : this() {
            this.dpdTimeoutAction = x.dpdTimeoutAction
            this.dpdTimeoutSeconds = x.dpdTimeoutSeconds
            this.ikeVersions = x.ikeVersions
            this.outsideIpAddress = x.outsideIpAddress
            this.phase1DhGroupNumbers = x.phase1DhGroupNumbers
            this.phase1EncryptionAlgorithms = x.phase1EncryptionAlgorithms
            this.phase1IntegrityAlgorithms = x.phase1IntegrityAlgorithms
            this.phase1LifetimeSeconds = x.phase1LifetimeSeconds
            this.phase2DhGroupNumbers = x.phase2DhGroupNumbers
            this.phase2EncryptionAlgorithms = x.phase2EncryptionAlgorithms
            this.phase2IntegrityAlgorithms = x.phase2IntegrityAlgorithms
            this.phase2LifetimeSeconds = x.phase2LifetimeSeconds
            this.preSharedKey = x.preSharedKey
            this.rekeyFuzzPercentage = x.rekeyFuzzPercentage
            this.rekeyMarginTimeSeconds = x.rekeyMarginTimeSeconds
            this.replayWindowSize = x.replayWindowSize
            this.startupAction = x.startupAction
            this.tunnelInsideCidr = x.tunnelInsideCidr
            this.tunnelInsideIpv6Cidr = x.tunnelInsideIpv6Cidr
        }

        override fun build(): TunnelOption = TunnelOption(this)
        override fun dpdTimeoutAction(dpdTimeoutAction: String): FluentBuilder = apply { this.dpdTimeoutAction = dpdTimeoutAction }
        override fun dpdTimeoutSeconds(dpdTimeoutSeconds: Int): FluentBuilder = apply { this.dpdTimeoutSeconds = dpdTimeoutSeconds }
        override fun ikeVersions(ikeVersions: List<IkeVersionsListValue>): FluentBuilder = apply { this.ikeVersions = ikeVersions }
        override fun outsideIpAddress(outsideIpAddress: String): FluentBuilder = apply { this.outsideIpAddress = outsideIpAddress }
        override fun phase1DhGroupNumbers(phase1DhGroupNumbers: List<Phase1DhGroupNumbersListValue>): FluentBuilder = apply { this.phase1DhGroupNumbers = phase1DhGroupNumbers }
        override fun phase1EncryptionAlgorithms(phase1EncryptionAlgorithms: List<Phase1EncryptionAlgorithmsListValue>): FluentBuilder = apply { this.phase1EncryptionAlgorithms = phase1EncryptionAlgorithms }
        override fun phase1IntegrityAlgorithms(phase1IntegrityAlgorithms: List<Phase1IntegrityAlgorithmsListValue>): FluentBuilder = apply { this.phase1IntegrityAlgorithms = phase1IntegrityAlgorithms }
        override fun phase1LifetimeSeconds(phase1LifetimeSeconds: Int): FluentBuilder = apply { this.phase1LifetimeSeconds = phase1LifetimeSeconds }
        override fun phase2DhGroupNumbers(phase2DhGroupNumbers: List<Phase2DhGroupNumbersListValue>): FluentBuilder = apply { this.phase2DhGroupNumbers = phase2DhGroupNumbers }
        override fun phase2EncryptionAlgorithms(phase2EncryptionAlgorithms: List<Phase2EncryptionAlgorithmsListValue>): FluentBuilder = apply { this.phase2EncryptionAlgorithms = phase2EncryptionAlgorithms }
        override fun phase2IntegrityAlgorithms(phase2IntegrityAlgorithms: List<Phase2IntegrityAlgorithmsListValue>): FluentBuilder = apply { this.phase2IntegrityAlgorithms = phase2IntegrityAlgorithms }
        override fun phase2LifetimeSeconds(phase2LifetimeSeconds: Int): FluentBuilder = apply { this.phase2LifetimeSeconds = phase2LifetimeSeconds }
        override fun preSharedKey(preSharedKey: String): FluentBuilder = apply { this.preSharedKey = preSharedKey }
        override fun rekeyFuzzPercentage(rekeyFuzzPercentage: Int): FluentBuilder = apply { this.rekeyFuzzPercentage = rekeyFuzzPercentage }
        override fun rekeyMarginTimeSeconds(rekeyMarginTimeSeconds: Int): FluentBuilder = apply { this.rekeyMarginTimeSeconds = rekeyMarginTimeSeconds }
        override fun replayWindowSize(replayWindowSize: Int): FluentBuilder = apply { this.replayWindowSize = replayWindowSize }
        override fun startupAction(startupAction: String): FluentBuilder = apply { this.startupAction = startupAction }
        override fun tunnelInsideCidr(tunnelInsideCidr: String): FluentBuilder = apply { this.tunnelInsideCidr = tunnelInsideCidr }
        override fun tunnelInsideIpv6Cidr(tunnelInsideIpv6Cidr: String): FluentBuilder = apply { this.tunnelInsideIpv6Cidr = tunnelInsideIpv6Cidr }
    }
}
