// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a security group and Amazon Web Services account ID pair.
 */
class UserIdGroupPair private constructor(builder: BuilderImpl) {
    /**
     * A description for the security group rule that references this user ID group
     * pair.
     * Constraints: Up to 255 characters in length. Allowed characters are a-z, A-Z, 0-9,
     * spaces, and ._-:/()#,@&#91;&#93;+=;{}!$*
     */
    val description: String? = builder.description
    /**
     * The ID of the security group.
     */
    val groupId: String? = builder.groupId
    /**
     * The name of the security group. In a request, use this parameter for a security group
     * in EC2-Classic or a default VPC only. For a security group in a nondefault VPC, use the
     * security group ID.
     * For a referenced security group in another VPC, this value is not returned if the
     * referenced security group is deleted.
     */
    val groupName: String? = builder.groupName
    /**
     * The status of a VPC peering connection, if applicable.
     */
    val peeringStatus: String? = builder.peeringStatus
    /**
     * The ID of an Amazon Web Services account.
     * For a referenced security group in another VPC, the account ID of the referenced
     * security group is returned in the response. If the referenced security group is deleted,
     * this value is not returned.
     * &#91;EC2-Classic&#93; Required when adding or removing rules that reference a security group
     * in another Amazon Web Services account.
     */
    val userId: String? = builder.userId
    /**
     * The ID of the VPC for the referenced security group, if applicable.
     */
    val vpcId: String? = builder.vpcId
    /**
     * The ID of the VPC peering connection, if applicable.
     */
    val vpcPeeringConnectionId: String? = builder.vpcPeeringConnectionId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UserIdGroupPair = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UserIdGroupPair(")
        append("description=$description,")
        append("groupId=$groupId,")
        append("groupName=$groupName,")
        append("peeringStatus=$peeringStatus,")
        append("userId=$userId,")
        append("vpcId=$vpcId,")
        append("vpcPeeringConnectionId=$vpcPeeringConnectionId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (groupId?.hashCode() ?: 0)
        result = 31 * result + (groupName?.hashCode() ?: 0)
        result = 31 * result + (peeringStatus?.hashCode() ?: 0)
        result = 31 * result + (userId?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        result = 31 * result + (vpcPeeringConnectionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UserIdGroupPair

        if (description != other.description) return false
        if (groupId != other.groupId) return false
        if (groupName != other.groupName) return false
        if (peeringStatus != other.peeringStatus) return false
        if (userId != other.userId) return false
        if (vpcId != other.vpcId) return false
        if (vpcPeeringConnectionId != other.vpcPeeringConnectionId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UserIdGroupPair = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UserIdGroupPair
        /**
         * A description for the security group rule that references this user ID group
         * pair.
         * Constraints: Up to 255 characters in length. Allowed characters are a-z, A-Z, 0-9,
         * spaces, and ._-:/()#,@&#91;&#93;+=;{}!$*
         */
        fun description(description: String): FluentBuilder
        /**
         * The ID of the security group.
         */
        fun groupId(groupId: String): FluentBuilder
        /**
         * The name of the security group. In a request, use this parameter for a security group
         * in EC2-Classic or a default VPC only. For a security group in a nondefault VPC, use the
         * security group ID.
         * For a referenced security group in another VPC, this value is not returned if the
         * referenced security group is deleted.
         */
        fun groupName(groupName: String): FluentBuilder
        /**
         * The status of a VPC peering connection, if applicable.
         */
        fun peeringStatus(peeringStatus: String): FluentBuilder
        /**
         * The ID of an Amazon Web Services account.
         * For a referenced security group in another VPC, the account ID of the referenced
         * security group is returned in the response. If the referenced security group is deleted,
         * this value is not returned.
         * &#91;EC2-Classic&#93; Required when adding or removing rules that reference a security group
         * in another Amazon Web Services account.
         */
        fun userId(userId: String): FluentBuilder
        /**
         * The ID of the VPC for the referenced security group, if applicable.
         */
        fun vpcId(vpcId: String): FluentBuilder
        /**
         * The ID of the VPC peering connection, if applicable.
         */
        fun vpcPeeringConnectionId(vpcPeeringConnectionId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A description for the security group rule that references this user ID group
         * pair.
         * Constraints: Up to 255 characters in length. Allowed characters are a-z, A-Z, 0-9,
         * spaces, and ._-:/()#,@&#91;&#93;+=;{}!$*
         */
        var description: String?
        /**
         * The ID of the security group.
         */
        var groupId: String?
        /**
         * The name of the security group. In a request, use this parameter for a security group
         * in EC2-Classic or a default VPC only. For a security group in a nondefault VPC, use the
         * security group ID.
         * For a referenced security group in another VPC, this value is not returned if the
         * referenced security group is deleted.
         */
        var groupName: String?
        /**
         * The status of a VPC peering connection, if applicable.
         */
        var peeringStatus: String?
        /**
         * The ID of an Amazon Web Services account.
         * For a referenced security group in another VPC, the account ID of the referenced
         * security group is returned in the response. If the referenced security group is deleted,
         * this value is not returned.
         * &#91;EC2-Classic&#93; Required when adding or removing rules that reference a security group
         * in another Amazon Web Services account.
         */
        var userId: String?
        /**
         * The ID of the VPC for the referenced security group, if applicable.
         */
        var vpcId: String?
        /**
         * The ID of the VPC peering connection, if applicable.
         */
        var vpcPeeringConnectionId: String?

        fun build(): UserIdGroupPair
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var description: String? = null
        override var groupId: String? = null
        override var groupName: String? = null
        override var peeringStatus: String? = null
        override var userId: String? = null
        override var vpcId: String? = null
        override var vpcPeeringConnectionId: String? = null

        constructor(x: UserIdGroupPair) : this() {
            this.description = x.description
            this.groupId = x.groupId
            this.groupName = x.groupName
            this.peeringStatus = x.peeringStatus
            this.userId = x.userId
            this.vpcId = x.vpcId
            this.vpcPeeringConnectionId = x.vpcPeeringConnectionId
        }

        override fun build(): UserIdGroupPair = UserIdGroupPair(this)
        override fun description(description: String): FluentBuilder = apply { this.description = description }
        override fun groupId(groupId: String): FluentBuilder = apply { this.groupId = groupId }
        override fun groupName(groupName: String): FluentBuilder = apply { this.groupName = groupName }
        override fun peeringStatus(peeringStatus: String): FluentBuilder = apply { this.peeringStatus = peeringStatus }
        override fun userId(userId: String): FluentBuilder = apply { this.userId = userId }
        override fun vpcId(vpcId: String): FluentBuilder = apply { this.vpcId = vpcId }
        override fun vpcPeeringConnectionId(vpcPeeringConnectionId: String): FluentBuilder = apply { this.vpcPeeringConnectionId = vpcPeeringConnectionId }
    }
}
