// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes telemetry for a VPN tunnel.
 */
class VgwTelemetry private constructor(builder: BuilderImpl) {
    /**
     * The number of accepted routes.
     */
    val acceptedRouteCount: Int? = builder.acceptedRouteCount
    /**
     * The Amazon Resource Name (ARN) of the VPN tunnel endpoint certificate.
     */
    val certificateArn: String? = builder.certificateArn
    /**
     * The date and time of the last change in status.
     */
    val lastStatusChange: Instant? = builder.lastStatusChange
    /**
     * The Internet-routable IP address of the virtual private gateway's outside
     * interface.
     */
    val outsideIpAddress: String? = builder.outsideIpAddress
    /**
     * The status of the VPN tunnel.
     */
    val status: TelemetryStatus? = builder.status
    /**
     * If an error occurs, a description of the error.
     */
    val statusMessage: String? = builder.statusMessage

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): VgwTelemetry = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("VgwTelemetry(")
        append("acceptedRouteCount=$acceptedRouteCount,")
        append("certificateArn=$certificateArn,")
        append("lastStatusChange=$lastStatusChange,")
        append("outsideIpAddress=$outsideIpAddress,")
        append("status=$status,")
        append("statusMessage=$statusMessage)")
    }

    override fun hashCode(): kotlin.Int {
        var result = acceptedRouteCount ?: 0
        result = 31 * result + (certificateArn?.hashCode() ?: 0)
        result = 31 * result + (lastStatusChange?.hashCode() ?: 0)
        result = 31 * result + (outsideIpAddress?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as VgwTelemetry

        if (acceptedRouteCount != other.acceptedRouteCount) return false
        if (certificateArn != other.certificateArn) return false
        if (lastStatusChange != other.lastStatusChange) return false
        if (outsideIpAddress != other.outsideIpAddress) return false
        if (status != other.status) return false
        if (statusMessage != other.statusMessage) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): VgwTelemetry = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): VgwTelemetry
        /**
         * The number of accepted routes.
         */
        fun acceptedRouteCount(acceptedRouteCount: Int): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the VPN tunnel endpoint certificate.
         */
        fun certificateArn(certificateArn: String): FluentBuilder
        /**
         * The date and time of the last change in status.
         */
        fun lastStatusChange(lastStatusChange: Instant): FluentBuilder
        /**
         * The Internet-routable IP address of the virtual private gateway's outside
         * interface.
         */
        fun outsideIpAddress(outsideIpAddress: String): FluentBuilder
        /**
         * The status of the VPN tunnel.
         */
        fun status(status: TelemetryStatus): FluentBuilder
        /**
         * If an error occurs, a description of the error.
         */
        fun statusMessage(statusMessage: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The number of accepted routes.
         */
        var acceptedRouteCount: Int?
        /**
         * The Amazon Resource Name (ARN) of the VPN tunnel endpoint certificate.
         */
        var certificateArn: String?
        /**
         * The date and time of the last change in status.
         */
        var lastStatusChange: Instant?
        /**
         * The Internet-routable IP address of the virtual private gateway's outside
         * interface.
         */
        var outsideIpAddress: String?
        /**
         * The status of the VPN tunnel.
         */
        var status: TelemetryStatus?
        /**
         * If an error occurs, a description of the error.
         */
        var statusMessage: String?

        fun build(): VgwTelemetry
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var acceptedRouteCount: Int? = null
        override var certificateArn: String? = null
        override var lastStatusChange: Instant? = null
        override var outsideIpAddress: String? = null
        override var status: TelemetryStatus? = null
        override var statusMessage: String? = null

        constructor(x: VgwTelemetry) : this() {
            this.acceptedRouteCount = x.acceptedRouteCount
            this.certificateArn = x.certificateArn
            this.lastStatusChange = x.lastStatusChange
            this.outsideIpAddress = x.outsideIpAddress
            this.status = x.status
            this.statusMessage = x.statusMessage
        }

        override fun build(): VgwTelemetry = VgwTelemetry(this)
        override fun acceptedRouteCount(acceptedRouteCount: Int): FluentBuilder = apply { this.acceptedRouteCount = acceptedRouteCount }
        override fun certificateArn(certificateArn: String): FluentBuilder = apply { this.certificateArn = certificateArn }
        override fun lastStatusChange(lastStatusChange: Instant): FluentBuilder = apply { this.lastStatusChange = lastStatusChange }
        override fun outsideIpAddress(outsideIpAddress: String): FluentBuilder = apply { this.outsideIpAddress = outsideIpAddress }
        override fun status(status: TelemetryStatus): FluentBuilder = apply { this.status = status }
        override fun statusMessage(statusMessage: String): FluentBuilder = apply { this.statusMessage = statusMessage }
    }
}
