// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a volume.
 */
class Volume private constructor(builder: BuilderImpl) {
    /**
     * Information about the volume attachments.
     */
    val attachments: List<VolumeAttachment>? = builder.attachments
    /**
     * The Availability Zone for the volume.
     */
    val availabilityZone: String? = builder.availabilityZone
    /**
     * The time stamp when volume creation was initiated.
     */
    val createTime: Instant? = builder.createTime
    /**
     * Indicates whether the volume is encrypted.
     */
    val encrypted: Boolean? = builder.encrypted
    /**
     * Indicates whether the volume was created using fast snapshot restore.
     */
    val fastRestored: Boolean? = builder.fastRestored
    /**
     * The number of I/O operations per second (IOPS). For gp3, io1, and io2 volumes, this represents
     * the number of IOPS that are provisioned for the volume. For gp2 volumes, this represents the baseline
     * performance of the volume and the rate at which the volume accumulates I/O credits for bursting.
     */
    val iops: Int? = builder.iops
    /**
     * The Amazon Resource Name (ARN) of the Key Management Service (KMS) KMS key that was used to protect the
     * volume encryption key for the volume.
     */
    val kmsKeyId: String? = builder.kmsKeyId
    /**
     * Indicates whether Amazon EBS Multi-Attach is enabled.
     */
    val multiAttachEnabled: Boolean? = builder.multiAttachEnabled
    /**
     * The Amazon Resource Name (ARN) of the Outpost.
     */
    val outpostArn: String? = builder.outpostArn
    /**
     * The size of the volume, in GiBs.
     */
    val size: Int? = builder.size
    /**
     * The snapshot from which the volume was created, if applicable.
     */
    val snapshotId: String? = builder.snapshotId
    /**
     * The volume state.
     */
    val state: VolumeState? = builder.state
    /**
     * Any tags assigned to the volume.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The throughput that the volume supports, in MiB/s.
     */
    val throughput: Int? = builder.throughput
    /**
     * The ID of the volume.
     */
    val volumeId: String? = builder.volumeId
    /**
     * The volume type.
     */
    val volumeType: VolumeType? = builder.volumeType

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Volume = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Volume(")
        append("attachments=$attachments,")
        append("availabilityZone=$availabilityZone,")
        append("createTime=$createTime,")
        append("encrypted=$encrypted,")
        append("fastRestored=$fastRestored,")
        append("iops=$iops,")
        append("kmsKeyId=$kmsKeyId,")
        append("multiAttachEnabled=$multiAttachEnabled,")
        append("outpostArn=$outpostArn,")
        append("size=$size,")
        append("snapshotId=$snapshotId,")
        append("state=$state,")
        append("tags=$tags,")
        append("throughput=$throughput,")
        append("volumeId=$volumeId,")
        append("volumeType=$volumeType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attachments?.hashCode() ?: 0
        result = 31 * result + (availabilityZone?.hashCode() ?: 0)
        result = 31 * result + (createTime?.hashCode() ?: 0)
        result = 31 * result + (encrypted?.hashCode() ?: 0)
        result = 31 * result + (fastRestored?.hashCode() ?: 0)
        result = 31 * result + (iops ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (multiAttachEnabled?.hashCode() ?: 0)
        result = 31 * result + (outpostArn?.hashCode() ?: 0)
        result = 31 * result + (size ?: 0)
        result = 31 * result + (snapshotId?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (throughput ?: 0)
        result = 31 * result + (volumeId?.hashCode() ?: 0)
        result = 31 * result + (volumeType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Volume

        if (attachments != other.attachments) return false
        if (availabilityZone != other.availabilityZone) return false
        if (createTime != other.createTime) return false
        if (encrypted != other.encrypted) return false
        if (fastRestored != other.fastRestored) return false
        if (iops != other.iops) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (multiAttachEnabled != other.multiAttachEnabled) return false
        if (outpostArn != other.outpostArn) return false
        if (size != other.size) return false
        if (snapshotId != other.snapshotId) return false
        if (state != other.state) return false
        if (tags != other.tags) return false
        if (throughput != other.throughput) return false
        if (volumeId != other.volumeId) return false
        if (volumeType != other.volumeType) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Volume = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Volume
        /**
         * Information about the volume attachments.
         */
        fun attachments(attachments: List<VolumeAttachment>): FluentBuilder
        /**
         * The Availability Zone for the volume.
         */
        fun availabilityZone(availabilityZone: String): FluentBuilder
        /**
         * The time stamp when volume creation was initiated.
         */
        fun createTime(createTime: Instant): FluentBuilder
        /**
         * Indicates whether the volume is encrypted.
         */
        fun encrypted(encrypted: Boolean): FluentBuilder
        /**
         * Indicates whether the volume was created using fast snapshot restore.
         */
        fun fastRestored(fastRestored: Boolean): FluentBuilder
        /**
         * The number of I/O operations per second (IOPS). For gp3, io1, and io2 volumes, this represents
         * the number of IOPS that are provisioned for the volume. For gp2 volumes, this represents the baseline
         * performance of the volume and the rate at which the volume accumulates I/O credits for bursting.
         */
        fun iops(iops: Int): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the Key Management Service (KMS) KMS key that was used to protect the
         * volume encryption key for the volume.
         */
        fun kmsKeyId(kmsKeyId: String): FluentBuilder
        /**
         * Indicates whether Amazon EBS Multi-Attach is enabled.
         */
        fun multiAttachEnabled(multiAttachEnabled: Boolean): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the Outpost.
         */
        fun outpostArn(outpostArn: String): FluentBuilder
        /**
         * The size of the volume, in GiBs.
         */
        fun size(size: Int): FluentBuilder
        /**
         * The snapshot from which the volume was created, if applicable.
         */
        fun snapshotId(snapshotId: String): FluentBuilder
        /**
         * The volume state.
         */
        fun state(state: VolumeState): FluentBuilder
        /**
         * Any tags assigned to the volume.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * The throughput that the volume supports, in MiB/s.
         */
        fun throughput(throughput: Int): FluentBuilder
        /**
         * The ID of the volume.
         */
        fun volumeId(volumeId: String): FluentBuilder
        /**
         * The volume type.
         */
        fun volumeType(volumeType: VolumeType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Information about the volume attachments.
         */
        var attachments: List<VolumeAttachment>?
        /**
         * The Availability Zone for the volume.
         */
        var availabilityZone: String?
        /**
         * The time stamp when volume creation was initiated.
         */
        var createTime: Instant?
        /**
         * Indicates whether the volume is encrypted.
         */
        var encrypted: Boolean?
        /**
         * Indicates whether the volume was created using fast snapshot restore.
         */
        var fastRestored: Boolean?
        /**
         * The number of I/O operations per second (IOPS). For gp3, io1, and io2 volumes, this represents
         * the number of IOPS that are provisioned for the volume. For gp2 volumes, this represents the baseline
         * performance of the volume and the rate at which the volume accumulates I/O credits for bursting.
         */
        var iops: Int?
        /**
         * The Amazon Resource Name (ARN) of the Key Management Service (KMS) KMS key that was used to protect the
         * volume encryption key for the volume.
         */
        var kmsKeyId: String?
        /**
         * Indicates whether Amazon EBS Multi-Attach is enabled.
         */
        var multiAttachEnabled: Boolean?
        /**
         * The Amazon Resource Name (ARN) of the Outpost.
         */
        var outpostArn: String?
        /**
         * The size of the volume, in GiBs.
         */
        var size: Int?
        /**
         * The snapshot from which the volume was created, if applicable.
         */
        var snapshotId: String?
        /**
         * The volume state.
         */
        var state: VolumeState?
        /**
         * Any tags assigned to the volume.
         */
        var tags: List<Tag>?
        /**
         * The throughput that the volume supports, in MiB/s.
         */
        var throughput: Int?
        /**
         * The ID of the volume.
         */
        var volumeId: String?
        /**
         * The volume type.
         */
        var volumeType: VolumeType?

        fun build(): Volume
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var attachments: List<VolumeAttachment>? = null
        override var availabilityZone: String? = null
        override var createTime: Instant? = null
        override var encrypted: Boolean? = null
        override var fastRestored: Boolean? = null
        override var iops: Int? = null
        override var kmsKeyId: String? = null
        override var multiAttachEnabled: Boolean? = null
        override var outpostArn: String? = null
        override var size: Int? = null
        override var snapshotId: String? = null
        override var state: VolumeState? = null
        override var tags: List<Tag>? = null
        override var throughput: Int? = null
        override var volumeId: String? = null
        override var volumeType: VolumeType? = null

        constructor(x: Volume) : this() {
            this.attachments = x.attachments
            this.availabilityZone = x.availabilityZone
            this.createTime = x.createTime
            this.encrypted = x.encrypted
            this.fastRestored = x.fastRestored
            this.iops = x.iops
            this.kmsKeyId = x.kmsKeyId
            this.multiAttachEnabled = x.multiAttachEnabled
            this.outpostArn = x.outpostArn
            this.size = x.size
            this.snapshotId = x.snapshotId
            this.state = x.state
            this.tags = x.tags
            this.throughput = x.throughput
            this.volumeId = x.volumeId
            this.volumeType = x.volumeType
        }

        override fun build(): Volume = Volume(this)
        override fun attachments(attachments: List<VolumeAttachment>): FluentBuilder = apply { this.attachments = attachments }
        override fun availabilityZone(availabilityZone: String): FluentBuilder = apply { this.availabilityZone = availabilityZone }
        override fun createTime(createTime: Instant): FluentBuilder = apply { this.createTime = createTime }
        override fun encrypted(encrypted: Boolean): FluentBuilder = apply { this.encrypted = encrypted }
        override fun fastRestored(fastRestored: Boolean): FluentBuilder = apply { this.fastRestored = fastRestored }
        override fun iops(iops: Int): FluentBuilder = apply { this.iops = iops }
        override fun kmsKeyId(kmsKeyId: String): FluentBuilder = apply { this.kmsKeyId = kmsKeyId }
        override fun multiAttachEnabled(multiAttachEnabled: Boolean): FluentBuilder = apply { this.multiAttachEnabled = multiAttachEnabled }
        override fun outpostArn(outpostArn: String): FluentBuilder = apply { this.outpostArn = outpostArn }
        override fun size(size: Int): FluentBuilder = apply { this.size = size }
        override fun snapshotId(snapshotId: String): FluentBuilder = apply { this.snapshotId = snapshotId }
        override fun state(state: VolumeState): FluentBuilder = apply { this.state = state }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun throughput(throughput: Int): FluentBuilder = apply { this.throughput = throughput }
        override fun volumeId(volumeId: String): FluentBuilder = apply { this.volumeId = volumeId }
        override fun volumeType(volumeType: VolumeType): FluentBuilder = apply { this.volumeType = volumeType }
    }
}
