// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes the modification status of an EBS volume.
 * If the volume has never been modified, some element values will be null.
 */
class VolumeModification private constructor(builder: BuilderImpl) {
    /**
     * The modification completion or failure time.
     */
    val endTime: Instant? = builder.endTime
    /**
     * The current modification state. The modification state is null for unmodified
     * volumes.
     */
    val modificationState: VolumeModificationState? = builder.modificationState
    /**
     * The original IOPS rate of the volume.
     */
    val originalIops: Int? = builder.originalIops
    /**
     * The original setting for Amazon EBS Multi-Attach.
     */
    val originalMultiAttachEnabled: Boolean? = builder.originalMultiAttachEnabled
    /**
     * The original size of the volume, in GiB.
     */
    val originalSize: Int? = builder.originalSize
    /**
     * The original throughput of the volume, in MiB/s.
     */
    val originalThroughput: Int? = builder.originalThroughput
    /**
     * The original EBS volume type of the volume.
     */
    val originalVolumeType: VolumeType? = builder.originalVolumeType
    /**
     * The modification progress, from 0 to 100 percent complete.
     */
    val progress: Long? = builder.progress
    /**
     * The modification start time.
     */
    val startTime: Instant? = builder.startTime
    /**
     * A status message about the modification progress or failure.
     */
    val statusMessage: String? = builder.statusMessage
    /**
     * The target IOPS rate of the volume.
     */
    val targetIops: Int? = builder.targetIops
    /**
     * The target setting for Amazon EBS Multi-Attach.
     */
    val targetMultiAttachEnabled: Boolean? = builder.targetMultiAttachEnabled
    /**
     * The target size of the volume, in GiB.
     */
    val targetSize: Int? = builder.targetSize
    /**
     * The target throughput of the volume, in MiB/s.
     */
    val targetThroughput: Int? = builder.targetThroughput
    /**
     * The target EBS volume type of the volume.
     */
    val targetVolumeType: VolumeType? = builder.targetVolumeType
    /**
     * The ID of the volume.
     */
    val volumeId: String? = builder.volumeId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): VolumeModification = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("VolumeModification(")
        append("endTime=$endTime,")
        append("modificationState=$modificationState,")
        append("originalIops=$originalIops,")
        append("originalMultiAttachEnabled=$originalMultiAttachEnabled,")
        append("originalSize=$originalSize,")
        append("originalThroughput=$originalThroughput,")
        append("originalVolumeType=$originalVolumeType,")
        append("progress=$progress,")
        append("startTime=$startTime,")
        append("statusMessage=$statusMessage,")
        append("targetIops=$targetIops,")
        append("targetMultiAttachEnabled=$targetMultiAttachEnabled,")
        append("targetSize=$targetSize,")
        append("targetThroughput=$targetThroughput,")
        append("targetVolumeType=$targetVolumeType,")
        append("volumeId=$volumeId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = endTime?.hashCode() ?: 0
        result = 31 * result + (modificationState?.hashCode() ?: 0)
        result = 31 * result + (originalIops ?: 0)
        result = 31 * result + (originalMultiAttachEnabled?.hashCode() ?: 0)
        result = 31 * result + (originalSize ?: 0)
        result = 31 * result + (originalThroughput ?: 0)
        result = 31 * result + (originalVolumeType?.hashCode() ?: 0)
        result = 31 * result + (progress?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        result = 31 * result + (targetIops ?: 0)
        result = 31 * result + (targetMultiAttachEnabled?.hashCode() ?: 0)
        result = 31 * result + (targetSize ?: 0)
        result = 31 * result + (targetThroughput ?: 0)
        result = 31 * result + (targetVolumeType?.hashCode() ?: 0)
        result = 31 * result + (volumeId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as VolumeModification

        if (endTime != other.endTime) return false
        if (modificationState != other.modificationState) return false
        if (originalIops != other.originalIops) return false
        if (originalMultiAttachEnabled != other.originalMultiAttachEnabled) return false
        if (originalSize != other.originalSize) return false
        if (originalThroughput != other.originalThroughput) return false
        if (originalVolumeType != other.originalVolumeType) return false
        if (progress != other.progress) return false
        if (startTime != other.startTime) return false
        if (statusMessage != other.statusMessage) return false
        if (targetIops != other.targetIops) return false
        if (targetMultiAttachEnabled != other.targetMultiAttachEnabled) return false
        if (targetSize != other.targetSize) return false
        if (targetThroughput != other.targetThroughput) return false
        if (targetVolumeType != other.targetVolumeType) return false
        if (volumeId != other.volumeId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): VolumeModification = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): VolumeModification
        /**
         * The modification completion or failure time.
         */
        fun endTime(endTime: Instant): FluentBuilder
        /**
         * The current modification state. The modification state is null for unmodified
         * volumes.
         */
        fun modificationState(modificationState: VolumeModificationState): FluentBuilder
        /**
         * The original IOPS rate of the volume.
         */
        fun originalIops(originalIops: Int): FluentBuilder
        /**
         * The original setting for Amazon EBS Multi-Attach.
         */
        fun originalMultiAttachEnabled(originalMultiAttachEnabled: Boolean): FluentBuilder
        /**
         * The original size of the volume, in GiB.
         */
        fun originalSize(originalSize: Int): FluentBuilder
        /**
         * The original throughput of the volume, in MiB/s.
         */
        fun originalThroughput(originalThroughput: Int): FluentBuilder
        /**
         * The original EBS volume type of the volume.
         */
        fun originalVolumeType(originalVolumeType: VolumeType): FluentBuilder
        /**
         * The modification progress, from 0 to 100 percent complete.
         */
        fun progress(progress: Long): FluentBuilder
        /**
         * The modification start time.
         */
        fun startTime(startTime: Instant): FluentBuilder
        /**
         * A status message about the modification progress or failure.
         */
        fun statusMessage(statusMessage: String): FluentBuilder
        /**
         * The target IOPS rate of the volume.
         */
        fun targetIops(targetIops: Int): FluentBuilder
        /**
         * The target setting for Amazon EBS Multi-Attach.
         */
        fun targetMultiAttachEnabled(targetMultiAttachEnabled: Boolean): FluentBuilder
        /**
         * The target size of the volume, in GiB.
         */
        fun targetSize(targetSize: Int): FluentBuilder
        /**
         * The target throughput of the volume, in MiB/s.
         */
        fun targetThroughput(targetThroughput: Int): FluentBuilder
        /**
         * The target EBS volume type of the volume.
         */
        fun targetVolumeType(targetVolumeType: VolumeType): FluentBuilder
        /**
         * The ID of the volume.
         */
        fun volumeId(volumeId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The modification completion or failure time.
         */
        var endTime: Instant?
        /**
         * The current modification state. The modification state is null for unmodified
         * volumes.
         */
        var modificationState: VolumeModificationState?
        /**
         * The original IOPS rate of the volume.
         */
        var originalIops: Int?
        /**
         * The original setting for Amazon EBS Multi-Attach.
         */
        var originalMultiAttachEnabled: Boolean?
        /**
         * The original size of the volume, in GiB.
         */
        var originalSize: Int?
        /**
         * The original throughput of the volume, in MiB/s.
         */
        var originalThroughput: Int?
        /**
         * The original EBS volume type of the volume.
         */
        var originalVolumeType: VolumeType?
        /**
         * The modification progress, from 0 to 100 percent complete.
         */
        var progress: Long?
        /**
         * The modification start time.
         */
        var startTime: Instant?
        /**
         * A status message about the modification progress or failure.
         */
        var statusMessage: String?
        /**
         * The target IOPS rate of the volume.
         */
        var targetIops: Int?
        /**
         * The target setting for Amazon EBS Multi-Attach.
         */
        var targetMultiAttachEnabled: Boolean?
        /**
         * The target size of the volume, in GiB.
         */
        var targetSize: Int?
        /**
         * The target throughput of the volume, in MiB/s.
         */
        var targetThroughput: Int?
        /**
         * The target EBS volume type of the volume.
         */
        var targetVolumeType: VolumeType?
        /**
         * The ID of the volume.
         */
        var volumeId: String?

        fun build(): VolumeModification
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var endTime: Instant? = null
        override var modificationState: VolumeModificationState? = null
        override var originalIops: Int? = null
        override var originalMultiAttachEnabled: Boolean? = null
        override var originalSize: Int? = null
        override var originalThroughput: Int? = null
        override var originalVolumeType: VolumeType? = null
        override var progress: Long? = null
        override var startTime: Instant? = null
        override var statusMessage: String? = null
        override var targetIops: Int? = null
        override var targetMultiAttachEnabled: Boolean? = null
        override var targetSize: Int? = null
        override var targetThroughput: Int? = null
        override var targetVolumeType: VolumeType? = null
        override var volumeId: String? = null

        constructor(x: VolumeModification) : this() {
            this.endTime = x.endTime
            this.modificationState = x.modificationState
            this.originalIops = x.originalIops
            this.originalMultiAttachEnabled = x.originalMultiAttachEnabled
            this.originalSize = x.originalSize
            this.originalThroughput = x.originalThroughput
            this.originalVolumeType = x.originalVolumeType
            this.progress = x.progress
            this.startTime = x.startTime
            this.statusMessage = x.statusMessage
            this.targetIops = x.targetIops
            this.targetMultiAttachEnabled = x.targetMultiAttachEnabled
            this.targetSize = x.targetSize
            this.targetThroughput = x.targetThroughput
            this.targetVolumeType = x.targetVolumeType
            this.volumeId = x.volumeId
        }

        override fun build(): VolumeModification = VolumeModification(this)
        override fun endTime(endTime: Instant): FluentBuilder = apply { this.endTime = endTime }
        override fun modificationState(modificationState: VolumeModificationState): FluentBuilder = apply { this.modificationState = modificationState }
        override fun originalIops(originalIops: Int): FluentBuilder = apply { this.originalIops = originalIops }
        override fun originalMultiAttachEnabled(originalMultiAttachEnabled: Boolean): FluentBuilder = apply { this.originalMultiAttachEnabled = originalMultiAttachEnabled }
        override fun originalSize(originalSize: Int): FluentBuilder = apply { this.originalSize = originalSize }
        override fun originalThroughput(originalThroughput: Int): FluentBuilder = apply { this.originalThroughput = originalThroughput }
        override fun originalVolumeType(originalVolumeType: VolumeType): FluentBuilder = apply { this.originalVolumeType = originalVolumeType }
        override fun progress(progress: Long): FluentBuilder = apply { this.progress = progress }
        override fun startTime(startTime: Instant): FluentBuilder = apply { this.startTime = startTime }
        override fun statusMessage(statusMessage: String): FluentBuilder = apply { this.statusMessage = statusMessage }
        override fun targetIops(targetIops: Int): FluentBuilder = apply { this.targetIops = targetIops }
        override fun targetMultiAttachEnabled(targetMultiAttachEnabled: Boolean): FluentBuilder = apply { this.targetMultiAttachEnabled = targetMultiAttachEnabled }
        override fun targetSize(targetSize: Int): FluentBuilder = apply { this.targetSize = targetSize }
        override fun targetThroughput(targetThroughput: Int): FluentBuilder = apply { this.targetThroughput = targetThroughput }
        override fun targetVolumeType(targetVolumeType: VolumeType): FluentBuilder = apply { this.targetVolumeType = targetVolumeType }
        override fun volumeId(volumeId: String): FluentBuilder = apply { this.volumeId = volumeId }
    }
}
