// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a VPC.
 */
class Vpc private constructor(builder: BuilderImpl) {
    /**
     * The primary IPv4 CIDR block for the VPC.
     */
    val cidrBlock: String? = builder.cidrBlock
    /**
     * Information about the IPv4 CIDR blocks associated with the VPC.
     */
    val cidrBlockAssociationSet: List<VpcCidrBlockAssociation>? = builder.cidrBlockAssociationSet
    /**
     * The ID of the set of DHCP options you've associated with the VPC.
     */
    val dhcpOptionsId: String? = builder.dhcpOptionsId
    /**
     * The allowed tenancy of instances launched into the VPC.
     */
    val instanceTenancy: Tenancy? = builder.instanceTenancy
    /**
     * Information about the IPv6 CIDR blocks associated with the VPC.
     */
    val ipv6CidrBlockAssociationSet: List<VpcIpv6CidrBlockAssociation>? = builder.ipv6CidrBlockAssociationSet
    /**
     * Indicates whether the VPC is the default VPC.
     */
    val isDefault: Boolean? = builder.isDefault
    /**
     * The ID of the Amazon Web Services account that owns the VPC.
     */
    val ownerId: String? = builder.ownerId
    /**
     * The current state of the VPC.
     */
    val state: VpcState? = builder.state
    /**
     * Any tags assigned to the VPC.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The ID of the VPC.
     */
    val vpcId: String? = builder.vpcId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Vpc = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("Vpc(")
        append("cidrBlock=$cidrBlock,")
        append("cidrBlockAssociationSet=$cidrBlockAssociationSet,")
        append("dhcpOptionsId=$dhcpOptionsId,")
        append("instanceTenancy=$instanceTenancy,")
        append("ipv6CidrBlockAssociationSet=$ipv6CidrBlockAssociationSet,")
        append("isDefault=$isDefault,")
        append("ownerId=$ownerId,")
        append("state=$state,")
        append("tags=$tags,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cidrBlock?.hashCode() ?: 0
        result = 31 * result + (cidrBlockAssociationSet?.hashCode() ?: 0)
        result = 31 * result + (dhcpOptionsId?.hashCode() ?: 0)
        result = 31 * result + (instanceTenancy?.hashCode() ?: 0)
        result = 31 * result + (ipv6CidrBlockAssociationSet?.hashCode() ?: 0)
        result = 31 * result + (isDefault?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as Vpc

        if (cidrBlock != other.cidrBlock) return false
        if (cidrBlockAssociationSet != other.cidrBlockAssociationSet) return false
        if (dhcpOptionsId != other.dhcpOptionsId) return false
        if (instanceTenancy != other.instanceTenancy) return false
        if (ipv6CidrBlockAssociationSet != other.ipv6CidrBlockAssociationSet) return false
        if (isDefault != other.isDefault) return false
        if (ownerId != other.ownerId) return false
        if (state != other.state) return false
        if (tags != other.tags) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): Vpc = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): Vpc
        /**
         * The primary IPv4 CIDR block for the VPC.
         */
        fun cidrBlock(cidrBlock: String): FluentBuilder
        /**
         * Information about the IPv4 CIDR blocks associated with the VPC.
         */
        fun cidrBlockAssociationSet(cidrBlockAssociationSet: List<VpcCidrBlockAssociation>): FluentBuilder
        /**
         * The ID of the set of DHCP options you've associated with the VPC.
         */
        fun dhcpOptionsId(dhcpOptionsId: String): FluentBuilder
        /**
         * The allowed tenancy of instances launched into the VPC.
         */
        fun instanceTenancy(instanceTenancy: Tenancy): FluentBuilder
        /**
         * Information about the IPv6 CIDR blocks associated with the VPC.
         */
        fun ipv6CidrBlockAssociationSet(ipv6CidrBlockAssociationSet: List<VpcIpv6CidrBlockAssociation>): FluentBuilder
        /**
         * Indicates whether the VPC is the default VPC.
         */
        fun isDefault(isDefault: Boolean): FluentBuilder
        /**
         * The ID of the Amazon Web Services account that owns the VPC.
         */
        fun ownerId(ownerId: String): FluentBuilder
        /**
         * The current state of the VPC.
         */
        fun state(state: VpcState): FluentBuilder
        /**
         * Any tags assigned to the VPC.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * The ID of the VPC.
         */
        fun vpcId(vpcId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The primary IPv4 CIDR block for the VPC.
         */
        var cidrBlock: String?
        /**
         * Information about the IPv4 CIDR blocks associated with the VPC.
         */
        var cidrBlockAssociationSet: List<VpcCidrBlockAssociation>?
        /**
         * The ID of the set of DHCP options you've associated with the VPC.
         */
        var dhcpOptionsId: String?
        /**
         * The allowed tenancy of instances launched into the VPC.
         */
        var instanceTenancy: Tenancy?
        /**
         * Information about the IPv6 CIDR blocks associated with the VPC.
         */
        var ipv6CidrBlockAssociationSet: List<VpcIpv6CidrBlockAssociation>?
        /**
         * Indicates whether the VPC is the default VPC.
         */
        var isDefault: Boolean?
        /**
         * The ID of the Amazon Web Services account that owns the VPC.
         */
        var ownerId: String?
        /**
         * The current state of the VPC.
         */
        var state: VpcState?
        /**
         * Any tags assigned to the VPC.
         */
        var tags: List<Tag>?
        /**
         * The ID of the VPC.
         */
        var vpcId: String?

        fun build(): Vpc
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var cidrBlock: String? = null
        override var cidrBlockAssociationSet: List<VpcCidrBlockAssociation>? = null
        override var dhcpOptionsId: String? = null
        override var instanceTenancy: Tenancy? = null
        override var ipv6CidrBlockAssociationSet: List<VpcIpv6CidrBlockAssociation>? = null
        override var isDefault: Boolean? = null
        override var ownerId: String? = null
        override var state: VpcState? = null
        override var tags: List<Tag>? = null
        override var vpcId: String? = null

        constructor(x: Vpc) : this() {
            this.cidrBlock = x.cidrBlock
            this.cidrBlockAssociationSet = x.cidrBlockAssociationSet
            this.dhcpOptionsId = x.dhcpOptionsId
            this.instanceTenancy = x.instanceTenancy
            this.ipv6CidrBlockAssociationSet = x.ipv6CidrBlockAssociationSet
            this.isDefault = x.isDefault
            this.ownerId = x.ownerId
            this.state = x.state
            this.tags = x.tags
            this.vpcId = x.vpcId
        }

        override fun build(): Vpc = Vpc(this)
        override fun cidrBlock(cidrBlock: String): FluentBuilder = apply { this.cidrBlock = cidrBlock }
        override fun cidrBlockAssociationSet(cidrBlockAssociationSet: List<VpcCidrBlockAssociation>): FluentBuilder = apply { this.cidrBlockAssociationSet = cidrBlockAssociationSet }
        override fun dhcpOptionsId(dhcpOptionsId: String): FluentBuilder = apply { this.dhcpOptionsId = dhcpOptionsId }
        override fun instanceTenancy(instanceTenancy: Tenancy): FluentBuilder = apply { this.instanceTenancy = instanceTenancy }
        override fun ipv6CidrBlockAssociationSet(ipv6CidrBlockAssociationSet: List<VpcIpv6CidrBlockAssociation>): FluentBuilder = apply { this.ipv6CidrBlockAssociationSet = ipv6CidrBlockAssociationSet }
        override fun isDefault(isDefault: Boolean): FluentBuilder = apply { this.isDefault = isDefault }
        override fun ownerId(ownerId: String): FluentBuilder = apply { this.ownerId = ownerId }
        override fun state(state: VpcState): FluentBuilder = apply { this.state = state }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun vpcId(vpcId: String): FluentBuilder = apply { this.vpcId = vpcId }
    }
}
