// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes an IPv4 CIDR block associated with a VPC.
 */
class VpcCidrBlockAssociation private constructor(builder: BuilderImpl) {
    /**
     * The association ID for the IPv4 CIDR block.
     */
    val associationId: String? = builder.associationId
    /**
     * The IPv4 CIDR block.
     */
    val cidrBlock: String? = builder.cidrBlock
    /**
     * Information about the state of the CIDR block.
     */
    val cidrBlockState: VpcCidrBlockState? = builder.cidrBlockState

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): VpcCidrBlockAssociation = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("VpcCidrBlockAssociation(")
        append("associationId=$associationId,")
        append("cidrBlock=$cidrBlock,")
        append("cidrBlockState=$cidrBlockState)")
    }

    override fun hashCode(): kotlin.Int {
        var result = associationId?.hashCode() ?: 0
        result = 31 * result + (cidrBlock?.hashCode() ?: 0)
        result = 31 * result + (cidrBlockState?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as VpcCidrBlockAssociation

        if (associationId != other.associationId) return false
        if (cidrBlock != other.cidrBlock) return false
        if (cidrBlockState != other.cidrBlockState) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): VpcCidrBlockAssociation = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): VpcCidrBlockAssociation
        /**
         * The association ID for the IPv4 CIDR block.
         */
        fun associationId(associationId: String): FluentBuilder
        /**
         * The IPv4 CIDR block.
         */
        fun cidrBlock(cidrBlock: String): FluentBuilder
        /**
         * Information about the state of the CIDR block.
         */
        fun cidrBlockState(cidrBlockState: VpcCidrBlockState): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The association ID for the IPv4 CIDR block.
         */
        var associationId: String?
        /**
         * The IPv4 CIDR block.
         */
        var cidrBlock: String?
        /**
         * Information about the state of the CIDR block.
         */
        var cidrBlockState: VpcCidrBlockState?

        fun build(): VpcCidrBlockAssociation
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.VpcCidrBlockState] inside the given [block]
         */
        fun cidrBlockState(block: VpcCidrBlockState.DslBuilder.() -> kotlin.Unit) {
            this.cidrBlockState = VpcCidrBlockState.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var associationId: String? = null
        override var cidrBlock: String? = null
        override var cidrBlockState: VpcCidrBlockState? = null

        constructor(x: VpcCidrBlockAssociation) : this() {
            this.associationId = x.associationId
            this.cidrBlock = x.cidrBlock
            this.cidrBlockState = x.cidrBlockState
        }

        override fun build(): VpcCidrBlockAssociation = VpcCidrBlockAssociation(this)
        override fun associationId(associationId: String): FluentBuilder = apply { this.associationId = associationId }
        override fun cidrBlock(cidrBlock: String): FluentBuilder = apply { this.cidrBlock = cidrBlock }
        override fun cidrBlockState(cidrBlockState: VpcCidrBlockState): FluentBuilder = apply { this.cidrBlockState = cidrBlockState }
    }
}
