// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a VPC endpoint.
 */
class VpcEndpoint private constructor(builder: BuilderImpl) {
    /**
     * The date and time that the VPC endpoint was created.
     */
    val creationTimestamp: Instant? = builder.creationTimestamp
    /**
     * (Interface endpoint) The DNS entries for the endpoint.
     */
    val dnsEntries: List<DnsEntry>? = builder.dnsEntries
    /**
     * (Interface endpoint) Information about the security groups that are associated with
     * the network interface.
     */
    val groups: List<SecurityGroupIdentifier>? = builder.groups
    /**
     * The last error that occurred for VPC endpoint.
     */
    val lastError: LastError? = builder.lastError
    /**
     * (Interface endpoint) One or more network interfaces for the endpoint.
     */
    val networkInterfaceIds: List<String>? = builder.networkInterfaceIds
    /**
     * The ID of the Amazon Web Services account that owns the VPC endpoint.
     */
    val ownerId: String? = builder.ownerId
    /**
     * The policy document associated with the endpoint, if applicable.
     */
    val policyDocument: String? = builder.policyDocument
    /**
     * (Interface endpoint) Indicates whether the VPC is associated with a private hosted zone.
     */
    val privateDnsEnabled: Boolean? = builder.privateDnsEnabled
    /**
     * Indicates whether the VPC endpoint is being managed by its service.
     */
    val requesterManaged: Boolean? = builder.requesterManaged
    /**
     * (Gateway endpoint) One or more route tables associated with the endpoint.
     */
    val routeTableIds: List<String>? = builder.routeTableIds
    /**
     * The name of the service to which the endpoint is associated.
     */
    val serviceName: String? = builder.serviceName
    /**
     * The state of the VPC endpoint.
     */
    val state: State? = builder.state
    /**
     * (Interface endpoint) One or more subnets in which the endpoint is located.
     */
    val subnetIds: List<String>? = builder.subnetIds
    /**
     * Any tags assigned to the VPC endpoint.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The ID of the VPC endpoint.
     */
    val vpcEndpointId: String? = builder.vpcEndpointId
    /**
     * The type of endpoint.
     */
    val vpcEndpointType: VpcEndpointType? = builder.vpcEndpointType
    /**
     * The ID of the VPC to which the endpoint is associated.
     */
    val vpcId: String? = builder.vpcId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): VpcEndpoint = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("VpcEndpoint(")
        append("creationTimestamp=$creationTimestamp,")
        append("dnsEntries=$dnsEntries,")
        append("groups=$groups,")
        append("lastError=$lastError,")
        append("networkInterfaceIds=$networkInterfaceIds,")
        append("ownerId=$ownerId,")
        append("policyDocument=$policyDocument,")
        append("privateDnsEnabled=$privateDnsEnabled,")
        append("requesterManaged=$requesterManaged,")
        append("routeTableIds=$routeTableIds,")
        append("serviceName=$serviceName,")
        append("state=$state,")
        append("subnetIds=$subnetIds,")
        append("tags=$tags,")
        append("vpcEndpointId=$vpcEndpointId,")
        append("vpcEndpointType=$vpcEndpointType,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTimestamp?.hashCode() ?: 0
        result = 31 * result + (dnsEntries?.hashCode() ?: 0)
        result = 31 * result + (groups?.hashCode() ?: 0)
        result = 31 * result + (lastError?.hashCode() ?: 0)
        result = 31 * result + (networkInterfaceIds?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (policyDocument?.hashCode() ?: 0)
        result = 31 * result + (privateDnsEnabled?.hashCode() ?: 0)
        result = 31 * result + (requesterManaged?.hashCode() ?: 0)
        result = 31 * result + (routeTableIds?.hashCode() ?: 0)
        result = 31 * result + (serviceName?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcEndpointId?.hashCode() ?: 0)
        result = 31 * result + (vpcEndpointType?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as VpcEndpoint

        if (creationTimestamp != other.creationTimestamp) return false
        if (dnsEntries != other.dnsEntries) return false
        if (groups != other.groups) return false
        if (lastError != other.lastError) return false
        if (networkInterfaceIds != other.networkInterfaceIds) return false
        if (ownerId != other.ownerId) return false
        if (policyDocument != other.policyDocument) return false
        if (privateDnsEnabled != other.privateDnsEnabled) return false
        if (requesterManaged != other.requesterManaged) return false
        if (routeTableIds != other.routeTableIds) return false
        if (serviceName != other.serviceName) return false
        if (state != other.state) return false
        if (subnetIds != other.subnetIds) return false
        if (tags != other.tags) return false
        if (vpcEndpointId != other.vpcEndpointId) return false
        if (vpcEndpointType != other.vpcEndpointType) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): VpcEndpoint = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): VpcEndpoint
        /**
         * The date and time that the VPC endpoint was created.
         */
        fun creationTimestamp(creationTimestamp: Instant): FluentBuilder
        /**
         * (Interface endpoint) The DNS entries for the endpoint.
         */
        fun dnsEntries(dnsEntries: List<DnsEntry>): FluentBuilder
        /**
         * (Interface endpoint) Information about the security groups that are associated with
         * the network interface.
         */
        fun groups(groups: List<SecurityGroupIdentifier>): FluentBuilder
        /**
         * The last error that occurred for VPC endpoint.
         */
        fun lastError(lastError: LastError): FluentBuilder
        /**
         * (Interface endpoint) One or more network interfaces for the endpoint.
         */
        fun networkInterfaceIds(networkInterfaceIds: List<String>): FluentBuilder
        /**
         * The ID of the Amazon Web Services account that owns the VPC endpoint.
         */
        fun ownerId(ownerId: String): FluentBuilder
        /**
         * The policy document associated with the endpoint, if applicable.
         */
        fun policyDocument(policyDocument: String): FluentBuilder
        /**
         * (Interface endpoint) Indicates whether the VPC is associated with a private hosted zone.
         */
        fun privateDnsEnabled(privateDnsEnabled: Boolean): FluentBuilder
        /**
         * Indicates whether the VPC endpoint is being managed by its service.
         */
        fun requesterManaged(requesterManaged: Boolean): FluentBuilder
        /**
         * (Gateway endpoint) One or more route tables associated with the endpoint.
         */
        fun routeTableIds(routeTableIds: List<String>): FluentBuilder
        /**
         * The name of the service to which the endpoint is associated.
         */
        fun serviceName(serviceName: String): FluentBuilder
        /**
         * The state of the VPC endpoint.
         */
        fun state(state: State): FluentBuilder
        /**
         * (Interface endpoint) One or more subnets in which the endpoint is located.
         */
        fun subnetIds(subnetIds: List<String>): FluentBuilder
        /**
         * Any tags assigned to the VPC endpoint.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * The ID of the VPC endpoint.
         */
        fun vpcEndpointId(vpcEndpointId: String): FluentBuilder
        /**
         * The type of endpoint.
         */
        fun vpcEndpointType(vpcEndpointType: VpcEndpointType): FluentBuilder
        /**
         * The ID of the VPC to which the endpoint is associated.
         */
        fun vpcId(vpcId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The date and time that the VPC endpoint was created.
         */
        var creationTimestamp: Instant?
        /**
         * (Interface endpoint) The DNS entries for the endpoint.
         */
        var dnsEntries: List<DnsEntry>?
        /**
         * (Interface endpoint) Information about the security groups that are associated with
         * the network interface.
         */
        var groups: List<SecurityGroupIdentifier>?
        /**
         * The last error that occurred for VPC endpoint.
         */
        var lastError: LastError?
        /**
         * (Interface endpoint) One or more network interfaces for the endpoint.
         */
        var networkInterfaceIds: List<String>?
        /**
         * The ID of the Amazon Web Services account that owns the VPC endpoint.
         */
        var ownerId: String?
        /**
         * The policy document associated with the endpoint, if applicable.
         */
        var policyDocument: String?
        /**
         * (Interface endpoint) Indicates whether the VPC is associated with a private hosted zone.
         */
        var privateDnsEnabled: Boolean?
        /**
         * Indicates whether the VPC endpoint is being managed by its service.
         */
        var requesterManaged: Boolean?
        /**
         * (Gateway endpoint) One or more route tables associated with the endpoint.
         */
        var routeTableIds: List<String>?
        /**
         * The name of the service to which the endpoint is associated.
         */
        var serviceName: String?
        /**
         * The state of the VPC endpoint.
         */
        var state: State?
        /**
         * (Interface endpoint) One or more subnets in which the endpoint is located.
         */
        var subnetIds: List<String>?
        /**
         * Any tags assigned to the VPC endpoint.
         */
        var tags: List<Tag>?
        /**
         * The ID of the VPC endpoint.
         */
        var vpcEndpointId: String?
        /**
         * The type of endpoint.
         */
        var vpcEndpointType: VpcEndpointType?
        /**
         * The ID of the VPC to which the endpoint is associated.
         */
        var vpcId: String?

        fun build(): VpcEndpoint
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.LastError] inside the given [block]
         */
        fun lastError(block: LastError.DslBuilder.() -> kotlin.Unit) {
            this.lastError = LastError.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var creationTimestamp: Instant? = null
        override var dnsEntries: List<DnsEntry>? = null
        override var groups: List<SecurityGroupIdentifier>? = null
        override var lastError: LastError? = null
        override var networkInterfaceIds: List<String>? = null
        override var ownerId: String? = null
        override var policyDocument: String? = null
        override var privateDnsEnabled: Boolean? = null
        override var requesterManaged: Boolean? = null
        override var routeTableIds: List<String>? = null
        override var serviceName: String? = null
        override var state: State? = null
        override var subnetIds: List<String>? = null
        override var tags: List<Tag>? = null
        override var vpcEndpointId: String? = null
        override var vpcEndpointType: VpcEndpointType? = null
        override var vpcId: String? = null

        constructor(x: VpcEndpoint) : this() {
            this.creationTimestamp = x.creationTimestamp
            this.dnsEntries = x.dnsEntries
            this.groups = x.groups
            this.lastError = x.lastError
            this.networkInterfaceIds = x.networkInterfaceIds
            this.ownerId = x.ownerId
            this.policyDocument = x.policyDocument
            this.privateDnsEnabled = x.privateDnsEnabled
            this.requesterManaged = x.requesterManaged
            this.routeTableIds = x.routeTableIds
            this.serviceName = x.serviceName
            this.state = x.state
            this.subnetIds = x.subnetIds
            this.tags = x.tags
            this.vpcEndpointId = x.vpcEndpointId
            this.vpcEndpointType = x.vpcEndpointType
            this.vpcId = x.vpcId
        }

        override fun build(): VpcEndpoint = VpcEndpoint(this)
        override fun creationTimestamp(creationTimestamp: Instant): FluentBuilder = apply { this.creationTimestamp = creationTimestamp }
        override fun dnsEntries(dnsEntries: List<DnsEntry>): FluentBuilder = apply { this.dnsEntries = dnsEntries }
        override fun groups(groups: List<SecurityGroupIdentifier>): FluentBuilder = apply { this.groups = groups }
        override fun lastError(lastError: LastError): FluentBuilder = apply { this.lastError = lastError }
        override fun networkInterfaceIds(networkInterfaceIds: List<String>): FluentBuilder = apply { this.networkInterfaceIds = networkInterfaceIds }
        override fun ownerId(ownerId: String): FluentBuilder = apply { this.ownerId = ownerId }
        override fun policyDocument(policyDocument: String): FluentBuilder = apply { this.policyDocument = policyDocument }
        override fun privateDnsEnabled(privateDnsEnabled: Boolean): FluentBuilder = apply { this.privateDnsEnabled = privateDnsEnabled }
        override fun requesterManaged(requesterManaged: Boolean): FluentBuilder = apply { this.requesterManaged = requesterManaged }
        override fun routeTableIds(routeTableIds: List<String>): FluentBuilder = apply { this.routeTableIds = routeTableIds }
        override fun serviceName(serviceName: String): FluentBuilder = apply { this.serviceName = serviceName }
        override fun state(state: State): FluentBuilder = apply { this.state = state }
        override fun subnetIds(subnetIds: List<String>): FluentBuilder = apply { this.subnetIds = subnetIds }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun vpcEndpointId(vpcEndpointId: String): FluentBuilder = apply { this.vpcEndpointId = vpcEndpointId }
        override fun vpcEndpointType(vpcEndpointType: VpcEndpointType): FluentBuilder = apply { this.vpcEndpointType = vpcEndpointType }
        override fun vpcId(vpcId: String): FluentBuilder = apply { this.vpcId = vpcId }
    }
}
