// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a VPC endpoint connection to a service.
 */
class VpcEndpointConnection private constructor(builder: BuilderImpl) {
    /**
     * The date and time that the VPC endpoint was created.
     */
    val creationTimestamp: Instant? = builder.creationTimestamp
    /**
     * The DNS entries for the VPC endpoint.
     */
    val dnsEntries: List<DnsEntry>? = builder.dnsEntries
    /**
     * The Amazon Resource Names (ARNs) of the Gateway Load Balancers for the service.
     */
    val gatewayLoadBalancerArns: List<String>? = builder.gatewayLoadBalancerArns
    /**
     * The Amazon Resource Names (ARNs) of the network load balancers for the service.
     */
    val networkLoadBalancerArns: List<String>? = builder.networkLoadBalancerArns
    /**
     * The ID of the service to which the endpoint is connected.
     */
    val serviceId: String? = builder.serviceId
    /**
     * The ID of the VPC endpoint.
     */
    val vpcEndpointId: String? = builder.vpcEndpointId
    /**
     * The ID of the Amazon Web Services account that owns the VPC endpoint.
     */
    val vpcEndpointOwner: String? = builder.vpcEndpointOwner
    /**
     * The state of the VPC endpoint.
     */
    val vpcEndpointState: State? = builder.vpcEndpointState

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): VpcEndpointConnection = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("VpcEndpointConnection(")
        append("creationTimestamp=$creationTimestamp,")
        append("dnsEntries=$dnsEntries,")
        append("gatewayLoadBalancerArns=$gatewayLoadBalancerArns,")
        append("networkLoadBalancerArns=$networkLoadBalancerArns,")
        append("serviceId=$serviceId,")
        append("vpcEndpointId=$vpcEndpointId,")
        append("vpcEndpointOwner=$vpcEndpointOwner,")
        append("vpcEndpointState=$vpcEndpointState)")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationTimestamp?.hashCode() ?: 0
        result = 31 * result + (dnsEntries?.hashCode() ?: 0)
        result = 31 * result + (gatewayLoadBalancerArns?.hashCode() ?: 0)
        result = 31 * result + (networkLoadBalancerArns?.hashCode() ?: 0)
        result = 31 * result + (serviceId?.hashCode() ?: 0)
        result = 31 * result + (vpcEndpointId?.hashCode() ?: 0)
        result = 31 * result + (vpcEndpointOwner?.hashCode() ?: 0)
        result = 31 * result + (vpcEndpointState?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as VpcEndpointConnection

        if (creationTimestamp != other.creationTimestamp) return false
        if (dnsEntries != other.dnsEntries) return false
        if (gatewayLoadBalancerArns != other.gatewayLoadBalancerArns) return false
        if (networkLoadBalancerArns != other.networkLoadBalancerArns) return false
        if (serviceId != other.serviceId) return false
        if (vpcEndpointId != other.vpcEndpointId) return false
        if (vpcEndpointOwner != other.vpcEndpointOwner) return false
        if (vpcEndpointState != other.vpcEndpointState) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): VpcEndpointConnection = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): VpcEndpointConnection
        /**
         * The date and time that the VPC endpoint was created.
         */
        fun creationTimestamp(creationTimestamp: Instant): FluentBuilder
        /**
         * The DNS entries for the VPC endpoint.
         */
        fun dnsEntries(dnsEntries: List<DnsEntry>): FluentBuilder
        /**
         * The Amazon Resource Names (ARNs) of the Gateway Load Balancers for the service.
         */
        fun gatewayLoadBalancerArns(gatewayLoadBalancerArns: List<String>): FluentBuilder
        /**
         * The Amazon Resource Names (ARNs) of the network load balancers for the service.
         */
        fun networkLoadBalancerArns(networkLoadBalancerArns: List<String>): FluentBuilder
        /**
         * The ID of the service to which the endpoint is connected.
         */
        fun serviceId(serviceId: String): FluentBuilder
        /**
         * The ID of the VPC endpoint.
         */
        fun vpcEndpointId(vpcEndpointId: String): FluentBuilder
        /**
         * The ID of the Amazon Web Services account that owns the VPC endpoint.
         */
        fun vpcEndpointOwner(vpcEndpointOwner: String): FluentBuilder
        /**
         * The state of the VPC endpoint.
         */
        fun vpcEndpointState(vpcEndpointState: State): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The date and time that the VPC endpoint was created.
         */
        var creationTimestamp: Instant?
        /**
         * The DNS entries for the VPC endpoint.
         */
        var dnsEntries: List<DnsEntry>?
        /**
         * The Amazon Resource Names (ARNs) of the Gateway Load Balancers for the service.
         */
        var gatewayLoadBalancerArns: List<String>?
        /**
         * The Amazon Resource Names (ARNs) of the network load balancers for the service.
         */
        var networkLoadBalancerArns: List<String>?
        /**
         * The ID of the service to which the endpoint is connected.
         */
        var serviceId: String?
        /**
         * The ID of the VPC endpoint.
         */
        var vpcEndpointId: String?
        /**
         * The ID of the Amazon Web Services account that owns the VPC endpoint.
         */
        var vpcEndpointOwner: String?
        /**
         * The state of the VPC endpoint.
         */
        var vpcEndpointState: State?

        fun build(): VpcEndpointConnection
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var creationTimestamp: Instant? = null
        override var dnsEntries: List<DnsEntry>? = null
        override var gatewayLoadBalancerArns: List<String>? = null
        override var networkLoadBalancerArns: List<String>? = null
        override var serviceId: String? = null
        override var vpcEndpointId: String? = null
        override var vpcEndpointOwner: String? = null
        override var vpcEndpointState: State? = null

        constructor(x: VpcEndpointConnection) : this() {
            this.creationTimestamp = x.creationTimestamp
            this.dnsEntries = x.dnsEntries
            this.gatewayLoadBalancerArns = x.gatewayLoadBalancerArns
            this.networkLoadBalancerArns = x.networkLoadBalancerArns
            this.serviceId = x.serviceId
            this.vpcEndpointId = x.vpcEndpointId
            this.vpcEndpointOwner = x.vpcEndpointOwner
            this.vpcEndpointState = x.vpcEndpointState
        }

        override fun build(): VpcEndpointConnection = VpcEndpointConnection(this)
        override fun creationTimestamp(creationTimestamp: Instant): FluentBuilder = apply { this.creationTimestamp = creationTimestamp }
        override fun dnsEntries(dnsEntries: List<DnsEntry>): FluentBuilder = apply { this.dnsEntries = dnsEntries }
        override fun gatewayLoadBalancerArns(gatewayLoadBalancerArns: List<String>): FluentBuilder = apply { this.gatewayLoadBalancerArns = gatewayLoadBalancerArns }
        override fun networkLoadBalancerArns(networkLoadBalancerArns: List<String>): FluentBuilder = apply { this.networkLoadBalancerArns = networkLoadBalancerArns }
        override fun serviceId(serviceId: String): FluentBuilder = apply { this.serviceId = serviceId }
        override fun vpcEndpointId(vpcEndpointId: String): FluentBuilder = apply { this.vpcEndpointId = vpcEndpointId }
        override fun vpcEndpointOwner(vpcEndpointOwner: String): FluentBuilder = apply { this.vpcEndpointOwner = vpcEndpointOwner }
        override fun vpcEndpointState(vpcEndpointState: State): FluentBuilder = apply { this.vpcEndpointState = vpcEndpointState }
    }
}
