// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a VPC peering connection.
 */
class VpcPeeringConnection private constructor(builder: BuilderImpl) {
    /**
     * Information about the accepter VPC. CIDR block information is only returned when describing an active VPC peering connection.
     */
    val accepterVpcInfo: VpcPeeringConnectionVpcInfo? = builder.accepterVpcInfo
    /**
     * The time that an unaccepted VPC peering connection will expire.
     */
    val expirationTime: Instant? = builder.expirationTime
    /**
     * Information about the requester VPC. CIDR block information is only returned when describing an active VPC peering connection.
     */
    val requesterVpcInfo: VpcPeeringConnectionVpcInfo? = builder.requesterVpcInfo
    /**
     * The status of the VPC peering connection.
     */
    val status: VpcPeeringConnectionStateReason? = builder.status
    /**
     * Any tags assigned to the resource.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The ID of the VPC peering connection.
     */
    val vpcPeeringConnectionId: String? = builder.vpcPeeringConnectionId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): VpcPeeringConnection = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("VpcPeeringConnection(")
        append("accepterVpcInfo=$accepterVpcInfo,")
        append("expirationTime=$expirationTime,")
        append("requesterVpcInfo=$requesterVpcInfo,")
        append("status=$status,")
        append("tags=$tags,")
        append("vpcPeeringConnectionId=$vpcPeeringConnectionId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accepterVpcInfo?.hashCode() ?: 0
        result = 31 * result + (expirationTime?.hashCode() ?: 0)
        result = 31 * result + (requesterVpcInfo?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcPeeringConnectionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as VpcPeeringConnection

        if (accepterVpcInfo != other.accepterVpcInfo) return false
        if (expirationTime != other.expirationTime) return false
        if (requesterVpcInfo != other.requesterVpcInfo) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (vpcPeeringConnectionId != other.vpcPeeringConnectionId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): VpcPeeringConnection = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): VpcPeeringConnection
        /**
         * Information about the accepter VPC. CIDR block information is only returned when describing an active VPC peering connection.
         */
        fun accepterVpcInfo(accepterVpcInfo: VpcPeeringConnectionVpcInfo): FluentBuilder
        /**
         * The time that an unaccepted VPC peering connection will expire.
         */
        fun expirationTime(expirationTime: Instant): FluentBuilder
        /**
         * Information about the requester VPC. CIDR block information is only returned when describing an active VPC peering connection.
         */
        fun requesterVpcInfo(requesterVpcInfo: VpcPeeringConnectionVpcInfo): FluentBuilder
        /**
         * The status of the VPC peering connection.
         */
        fun status(status: VpcPeeringConnectionStateReason): FluentBuilder
        /**
         * Any tags assigned to the resource.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * The ID of the VPC peering connection.
         */
        fun vpcPeeringConnectionId(vpcPeeringConnectionId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Information about the accepter VPC. CIDR block information is only returned when describing an active VPC peering connection.
         */
        var accepterVpcInfo: VpcPeeringConnectionVpcInfo?
        /**
         * The time that an unaccepted VPC peering connection will expire.
         */
        var expirationTime: Instant?
        /**
         * Information about the requester VPC. CIDR block information is only returned when describing an active VPC peering connection.
         */
        var requesterVpcInfo: VpcPeeringConnectionVpcInfo?
        /**
         * The status of the VPC peering connection.
         */
        var status: VpcPeeringConnectionStateReason?
        /**
         * Any tags assigned to the resource.
         */
        var tags: List<Tag>?
        /**
         * The ID of the VPC peering connection.
         */
        var vpcPeeringConnectionId: String?

        fun build(): VpcPeeringConnection
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.VpcPeeringConnectionVpcInfo] inside the given [block]
         */
        fun accepterVpcInfo(block: VpcPeeringConnectionVpcInfo.DslBuilder.() -> kotlin.Unit) {
            this.accepterVpcInfo = VpcPeeringConnectionVpcInfo.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.VpcPeeringConnectionVpcInfo] inside the given [block]
         */
        fun requesterVpcInfo(block: VpcPeeringConnectionVpcInfo.DslBuilder.() -> kotlin.Unit) {
            this.requesterVpcInfo = VpcPeeringConnectionVpcInfo.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.VpcPeeringConnectionStateReason] inside the given [block]
         */
        fun status(block: VpcPeeringConnectionStateReason.DslBuilder.() -> kotlin.Unit) {
            this.status = VpcPeeringConnectionStateReason.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var accepterVpcInfo: VpcPeeringConnectionVpcInfo? = null
        override var expirationTime: Instant? = null
        override var requesterVpcInfo: VpcPeeringConnectionVpcInfo? = null
        override var status: VpcPeeringConnectionStateReason? = null
        override var tags: List<Tag>? = null
        override var vpcPeeringConnectionId: String? = null

        constructor(x: VpcPeeringConnection) : this() {
            this.accepterVpcInfo = x.accepterVpcInfo
            this.expirationTime = x.expirationTime
            this.requesterVpcInfo = x.requesterVpcInfo
            this.status = x.status
            this.tags = x.tags
            this.vpcPeeringConnectionId = x.vpcPeeringConnectionId
        }

        override fun build(): VpcPeeringConnection = VpcPeeringConnection(this)
        override fun accepterVpcInfo(accepterVpcInfo: VpcPeeringConnectionVpcInfo): FluentBuilder = apply { this.accepterVpcInfo = accepterVpcInfo }
        override fun expirationTime(expirationTime: Instant): FluentBuilder = apply { this.expirationTime = expirationTime }
        override fun requesterVpcInfo(requesterVpcInfo: VpcPeeringConnectionVpcInfo): FluentBuilder = apply { this.requesterVpcInfo = requesterVpcInfo }
        override fun status(status: VpcPeeringConnectionStateReason): FluentBuilder = apply { this.status = status }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun vpcPeeringConnectionId(vpcPeeringConnectionId: String): FluentBuilder = apply { this.vpcPeeringConnectionId = vpcPeeringConnectionId }
    }
}
