// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the VPC peering connection options.
 */
class VpcPeeringConnectionOptionsDescription private constructor(builder: BuilderImpl) {
    /**
     * Indicates whether a local VPC can resolve public DNS hostnames to private IP addresses when queried from instances in a peer VPC.
     */
    val allowDnsResolutionFromRemoteVpc: Boolean? = builder.allowDnsResolutionFromRemoteVpc
    /**
     * Indicates whether a local ClassicLink connection can communicate with the peer VPC over the VPC peering connection.
     */
    val allowEgressFromLocalClassicLinkToRemoteVpc: Boolean? = builder.allowEgressFromLocalClassicLinkToRemoteVpc
    /**
     * Indicates whether a local VPC can communicate with a ClassicLink connection in the peer VPC over the VPC peering connection.
     */
    val allowEgressFromLocalVpcToRemoteClassicLink: Boolean? = builder.allowEgressFromLocalVpcToRemoteClassicLink

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): VpcPeeringConnectionOptionsDescription = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("VpcPeeringConnectionOptionsDescription(")
        append("allowDnsResolutionFromRemoteVpc=$allowDnsResolutionFromRemoteVpc,")
        append("allowEgressFromLocalClassicLinkToRemoteVpc=$allowEgressFromLocalClassicLinkToRemoteVpc,")
        append("allowEgressFromLocalVpcToRemoteClassicLink=$allowEgressFromLocalVpcToRemoteClassicLink)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowDnsResolutionFromRemoteVpc?.hashCode() ?: 0
        result = 31 * result + (allowEgressFromLocalClassicLinkToRemoteVpc?.hashCode() ?: 0)
        result = 31 * result + (allowEgressFromLocalVpcToRemoteClassicLink?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as VpcPeeringConnectionOptionsDescription

        if (allowDnsResolutionFromRemoteVpc != other.allowDnsResolutionFromRemoteVpc) return false
        if (allowEgressFromLocalClassicLinkToRemoteVpc != other.allowEgressFromLocalClassicLinkToRemoteVpc) return false
        if (allowEgressFromLocalVpcToRemoteClassicLink != other.allowEgressFromLocalVpcToRemoteClassicLink) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): VpcPeeringConnectionOptionsDescription = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): VpcPeeringConnectionOptionsDescription
        /**
         * Indicates whether a local VPC can resolve public DNS hostnames to private IP addresses when queried from instances in a peer VPC.
         */
        fun allowDnsResolutionFromRemoteVpc(allowDnsResolutionFromRemoteVpc: Boolean): FluentBuilder
        /**
         * Indicates whether a local ClassicLink connection can communicate with the peer VPC over the VPC peering connection.
         */
        fun allowEgressFromLocalClassicLinkToRemoteVpc(allowEgressFromLocalClassicLinkToRemoteVpc: Boolean): FluentBuilder
        /**
         * Indicates whether a local VPC can communicate with a ClassicLink connection in the peer VPC over the VPC peering connection.
         */
        fun allowEgressFromLocalVpcToRemoteClassicLink(allowEgressFromLocalVpcToRemoteClassicLink: Boolean): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Indicates whether a local VPC can resolve public DNS hostnames to private IP addresses when queried from instances in a peer VPC.
         */
        var allowDnsResolutionFromRemoteVpc: Boolean?
        /**
         * Indicates whether a local ClassicLink connection can communicate with the peer VPC over the VPC peering connection.
         */
        var allowEgressFromLocalClassicLinkToRemoteVpc: Boolean?
        /**
         * Indicates whether a local VPC can communicate with a ClassicLink connection in the peer VPC over the VPC peering connection.
         */
        var allowEgressFromLocalVpcToRemoteClassicLink: Boolean?

        fun build(): VpcPeeringConnectionOptionsDescription
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var allowDnsResolutionFromRemoteVpc: Boolean? = null
        override var allowEgressFromLocalClassicLinkToRemoteVpc: Boolean? = null
        override var allowEgressFromLocalVpcToRemoteClassicLink: Boolean? = null

        constructor(x: VpcPeeringConnectionOptionsDescription) : this() {
            this.allowDnsResolutionFromRemoteVpc = x.allowDnsResolutionFromRemoteVpc
            this.allowEgressFromLocalClassicLinkToRemoteVpc = x.allowEgressFromLocalClassicLinkToRemoteVpc
            this.allowEgressFromLocalVpcToRemoteClassicLink = x.allowEgressFromLocalVpcToRemoteClassicLink
        }

        override fun build(): VpcPeeringConnectionOptionsDescription = VpcPeeringConnectionOptionsDescription(this)
        override fun allowDnsResolutionFromRemoteVpc(allowDnsResolutionFromRemoteVpc: Boolean): FluentBuilder = apply { this.allowDnsResolutionFromRemoteVpc = allowDnsResolutionFromRemoteVpc }
        override fun allowEgressFromLocalClassicLinkToRemoteVpc(allowEgressFromLocalClassicLinkToRemoteVpc: Boolean): FluentBuilder = apply { this.allowEgressFromLocalClassicLinkToRemoteVpc = allowEgressFromLocalClassicLinkToRemoteVpc }
        override fun allowEgressFromLocalVpcToRemoteClassicLink(allowEgressFromLocalVpcToRemoteClassicLink: Boolean): FluentBuilder = apply { this.allowEgressFromLocalVpcToRemoteClassicLink = allowEgressFromLocalVpcToRemoteClassicLink }
    }
}
