// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a VPC in a VPC peering connection.
 */
class VpcPeeringConnectionVpcInfo private constructor(builder: BuilderImpl) {
    /**
     * The IPv4 CIDR block for the VPC.
     */
    val cidrBlock: String? = builder.cidrBlock
    /**
     * Information about the IPv4 CIDR blocks for the VPC.
     */
    val cidrBlockSet: List<CidrBlock>? = builder.cidrBlockSet
    /**
     * The IPv6 CIDR block for the VPC.
     */
    val ipv6CidrBlockSet: List<Ipv6CidrBlock>? = builder.ipv6CidrBlockSet
    /**
     * The ID of the Amazon Web Services account that owns the VPC.
     */
    val ownerId: String? = builder.ownerId
    /**
     * Information about the VPC peering connection options for the accepter or requester VPC.
     */
    val peeringOptions: VpcPeeringConnectionOptionsDescription? = builder.peeringOptions
    /**
     * The Region in which the VPC is located.
     */
    val region: String? = builder.region
    /**
     * The ID of the VPC.
     */
    val vpcId: String? = builder.vpcId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): VpcPeeringConnectionVpcInfo = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("VpcPeeringConnectionVpcInfo(")
        append("cidrBlock=$cidrBlock,")
        append("cidrBlockSet=$cidrBlockSet,")
        append("ipv6CidrBlockSet=$ipv6CidrBlockSet,")
        append("ownerId=$ownerId,")
        append("peeringOptions=$peeringOptions,")
        append("region=$region,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cidrBlock?.hashCode() ?: 0
        result = 31 * result + (cidrBlockSet?.hashCode() ?: 0)
        result = 31 * result + (ipv6CidrBlockSet?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (peeringOptions?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as VpcPeeringConnectionVpcInfo

        if (cidrBlock != other.cidrBlock) return false
        if (cidrBlockSet != other.cidrBlockSet) return false
        if (ipv6CidrBlockSet != other.ipv6CidrBlockSet) return false
        if (ownerId != other.ownerId) return false
        if (peeringOptions != other.peeringOptions) return false
        if (region != other.region) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): VpcPeeringConnectionVpcInfo = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): VpcPeeringConnectionVpcInfo
        /**
         * The IPv4 CIDR block for the VPC.
         */
        fun cidrBlock(cidrBlock: String): FluentBuilder
        /**
         * Information about the IPv4 CIDR blocks for the VPC.
         */
        fun cidrBlockSet(cidrBlockSet: List<CidrBlock>): FluentBuilder
        /**
         * The IPv6 CIDR block for the VPC.
         */
        fun ipv6CidrBlockSet(ipv6CidrBlockSet: List<Ipv6CidrBlock>): FluentBuilder
        /**
         * The ID of the Amazon Web Services account that owns the VPC.
         */
        fun ownerId(ownerId: String): FluentBuilder
        /**
         * Information about the VPC peering connection options for the accepter or requester VPC.
         */
        fun peeringOptions(peeringOptions: VpcPeeringConnectionOptionsDescription): FluentBuilder
        /**
         * The Region in which the VPC is located.
         */
        fun region(region: String): FluentBuilder
        /**
         * The ID of the VPC.
         */
        fun vpcId(vpcId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The IPv4 CIDR block for the VPC.
         */
        var cidrBlock: String?
        /**
         * Information about the IPv4 CIDR blocks for the VPC.
         */
        var cidrBlockSet: List<CidrBlock>?
        /**
         * The IPv6 CIDR block for the VPC.
         */
        var ipv6CidrBlockSet: List<Ipv6CidrBlock>?
        /**
         * The ID of the Amazon Web Services account that owns the VPC.
         */
        var ownerId: String?
        /**
         * Information about the VPC peering connection options for the accepter or requester VPC.
         */
        var peeringOptions: VpcPeeringConnectionOptionsDescription?
        /**
         * The Region in which the VPC is located.
         */
        var region: String?
        /**
         * The ID of the VPC.
         */
        var vpcId: String?

        fun build(): VpcPeeringConnectionVpcInfo
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.VpcPeeringConnectionOptionsDescription] inside the given [block]
         */
        fun peeringOptions(block: VpcPeeringConnectionOptionsDescription.DslBuilder.() -> kotlin.Unit) {
            this.peeringOptions = VpcPeeringConnectionOptionsDescription.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var cidrBlock: String? = null
        override var cidrBlockSet: List<CidrBlock>? = null
        override var ipv6CidrBlockSet: List<Ipv6CidrBlock>? = null
        override var ownerId: String? = null
        override var peeringOptions: VpcPeeringConnectionOptionsDescription? = null
        override var region: String? = null
        override var vpcId: String? = null

        constructor(x: VpcPeeringConnectionVpcInfo) : this() {
            this.cidrBlock = x.cidrBlock
            this.cidrBlockSet = x.cidrBlockSet
            this.ipv6CidrBlockSet = x.ipv6CidrBlockSet
            this.ownerId = x.ownerId
            this.peeringOptions = x.peeringOptions
            this.region = x.region
            this.vpcId = x.vpcId
        }

        override fun build(): VpcPeeringConnectionVpcInfo = VpcPeeringConnectionVpcInfo(this)
        override fun cidrBlock(cidrBlock: String): FluentBuilder = apply { this.cidrBlock = cidrBlock }
        override fun cidrBlockSet(cidrBlockSet: List<CidrBlock>): FluentBuilder = apply { this.cidrBlockSet = cidrBlockSet }
        override fun ipv6CidrBlockSet(ipv6CidrBlockSet: List<Ipv6CidrBlock>): FluentBuilder = apply { this.ipv6CidrBlockSet = ipv6CidrBlockSet }
        override fun ownerId(ownerId: String): FluentBuilder = apply { this.ownerId = ownerId }
        override fun peeringOptions(peeringOptions: VpcPeeringConnectionOptionsDescription): FluentBuilder = apply { this.peeringOptions = peeringOptions }
        override fun region(region: String): FluentBuilder = apply { this.region = region }
        override fun vpcId(vpcId: String): FluentBuilder = apply { this.vpcId = vpcId }
    }
}
