// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a VPN connection.
 */
class VpnConnection private constructor(builder: BuilderImpl) {
    /**
     * The category of the VPN connection. A value of VPN indicates an Amazon Web Services VPN connection. A value of VPN-Classic indicates an Amazon Web Services Classic VPN connection.
     */
    val category: String? = builder.category
    /**
     * The ARN of the core network.
     */
    val coreNetworkArn: String? = builder.coreNetworkArn
    /**
     * The ARN of the core network attachment.
     */
    val coreNetworkAttachmentArn: String? = builder.coreNetworkAttachmentArn
    /**
     * The configuration information for the VPN connection's customer gateway (in the native
     * XML format). This element is always present in the CreateVpnConnection
     * response; however, it's present in the DescribeVpnConnections response
     * only if the VPN connection is in the pending or available
     * state.
     */
    val customerGatewayConfiguration: String? = builder.customerGatewayConfiguration
    /**
     * The ID of the customer gateway at your end of the VPN connection.
     */
    val customerGatewayId: String? = builder.customerGatewayId
    /**
     * The current state of the gateway association.
     */
    val gatewayAssociationState: String? = builder.gatewayAssociationState
    /**
     * The VPN connection options.
     */
    val options: VpnConnectionOptions? = builder.options
    /**
     * The static routes associated with the VPN connection.
     */
    val routes: List<VpnStaticRoute>? = builder.routes
    /**
     * The current state of the VPN connection.
     */
    val state: VpnState? = builder.state
    /**
     * Any tags assigned to the VPN connection.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The ID of the transit gateway associated with the VPN connection.
     */
    val transitGatewayId: String? = builder.transitGatewayId
    /**
     * The type of VPN connection.
     */
    val type: GatewayType? = builder.type
    /**
     * Information about the VPN tunnel.
     */
    val vgwTelemetry: List<VgwTelemetry>? = builder.vgwTelemetry
    /**
     * The ID of the VPN connection.
     */
    val vpnConnectionId: String? = builder.vpnConnectionId
    /**
     * The ID of the virtual private gateway at the Amazon Web Services side of the VPN
     * connection.
     */
    val vpnGatewayId: String? = builder.vpnGatewayId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): VpnConnection = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("VpnConnection(")
        append("category=$category,")
        append("coreNetworkArn=$coreNetworkArn,")
        append("coreNetworkAttachmentArn=$coreNetworkAttachmentArn,")
        append("customerGatewayConfiguration=$customerGatewayConfiguration,")
        append("customerGatewayId=$customerGatewayId,")
        append("gatewayAssociationState=$gatewayAssociationState,")
        append("options=$options,")
        append("routes=$routes,")
        append("state=$state,")
        append("tags=$tags,")
        append("transitGatewayId=$transitGatewayId,")
        append("type=$type,")
        append("vgwTelemetry=$vgwTelemetry,")
        append("vpnConnectionId=$vpnConnectionId,")
        append("vpnGatewayId=$vpnGatewayId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = category?.hashCode() ?: 0
        result = 31 * result + (coreNetworkArn?.hashCode() ?: 0)
        result = 31 * result + (coreNetworkAttachmentArn?.hashCode() ?: 0)
        result = 31 * result + (customerGatewayConfiguration?.hashCode() ?: 0)
        result = 31 * result + (customerGatewayId?.hashCode() ?: 0)
        result = 31 * result + (gatewayAssociationState?.hashCode() ?: 0)
        result = 31 * result + (options?.hashCode() ?: 0)
        result = 31 * result + (routes?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (transitGatewayId?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (vgwTelemetry?.hashCode() ?: 0)
        result = 31 * result + (vpnConnectionId?.hashCode() ?: 0)
        result = 31 * result + (vpnGatewayId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as VpnConnection

        if (category != other.category) return false
        if (coreNetworkArn != other.coreNetworkArn) return false
        if (coreNetworkAttachmentArn != other.coreNetworkAttachmentArn) return false
        if (customerGatewayConfiguration != other.customerGatewayConfiguration) return false
        if (customerGatewayId != other.customerGatewayId) return false
        if (gatewayAssociationState != other.gatewayAssociationState) return false
        if (options != other.options) return false
        if (routes != other.routes) return false
        if (state != other.state) return false
        if (tags != other.tags) return false
        if (transitGatewayId != other.transitGatewayId) return false
        if (type != other.type) return false
        if (vgwTelemetry != other.vgwTelemetry) return false
        if (vpnConnectionId != other.vpnConnectionId) return false
        if (vpnGatewayId != other.vpnGatewayId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): VpnConnection = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): VpnConnection
        /**
         * The category of the VPN connection. A value of VPN indicates an Amazon Web Services VPN connection. A value of VPN-Classic indicates an Amazon Web Services Classic VPN connection.
         */
        fun category(category: String): FluentBuilder
        /**
         * The ARN of the core network.
         */
        fun coreNetworkArn(coreNetworkArn: String): FluentBuilder
        /**
         * The ARN of the core network attachment.
         */
        fun coreNetworkAttachmentArn(coreNetworkAttachmentArn: String): FluentBuilder
        /**
         * The configuration information for the VPN connection's customer gateway (in the native
         * XML format). This element is always present in the CreateVpnConnection
         * response; however, it's present in the DescribeVpnConnections response
         * only if the VPN connection is in the pending or available
         * state.
         */
        fun customerGatewayConfiguration(customerGatewayConfiguration: String): FluentBuilder
        /**
         * The ID of the customer gateway at your end of the VPN connection.
         */
        fun customerGatewayId(customerGatewayId: String): FluentBuilder
        /**
         * The current state of the gateway association.
         */
        fun gatewayAssociationState(gatewayAssociationState: String): FluentBuilder
        /**
         * The VPN connection options.
         */
        fun options(options: VpnConnectionOptions): FluentBuilder
        /**
         * The static routes associated with the VPN connection.
         */
        fun routes(routes: List<VpnStaticRoute>): FluentBuilder
        /**
         * The current state of the VPN connection.
         */
        fun state(state: VpnState): FluentBuilder
        /**
         * Any tags assigned to the VPN connection.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * The ID of the transit gateway associated with the VPN connection.
         */
        fun transitGatewayId(transitGatewayId: String): FluentBuilder
        /**
         * The type of VPN connection.
         */
        fun type(type: GatewayType): FluentBuilder
        /**
         * Information about the VPN tunnel.
         */
        fun vgwTelemetry(vgwTelemetry: List<VgwTelemetry>): FluentBuilder
        /**
         * The ID of the VPN connection.
         */
        fun vpnConnectionId(vpnConnectionId: String): FluentBuilder
        /**
         * The ID of the virtual private gateway at the Amazon Web Services side of the VPN
         * connection.
         */
        fun vpnGatewayId(vpnGatewayId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The category of the VPN connection. A value of VPN indicates an Amazon Web Services VPN connection. A value of VPN-Classic indicates an Amazon Web Services Classic VPN connection.
         */
        var category: String?
        /**
         * The ARN of the core network.
         */
        var coreNetworkArn: String?
        /**
         * The ARN of the core network attachment.
         */
        var coreNetworkAttachmentArn: String?
        /**
         * The configuration information for the VPN connection's customer gateway (in the native
         * XML format). This element is always present in the CreateVpnConnection
         * response; however, it's present in the DescribeVpnConnections response
         * only if the VPN connection is in the pending or available
         * state.
         */
        var customerGatewayConfiguration: String?
        /**
         * The ID of the customer gateway at your end of the VPN connection.
         */
        var customerGatewayId: String?
        /**
         * The current state of the gateway association.
         */
        var gatewayAssociationState: String?
        /**
         * The VPN connection options.
         */
        var options: VpnConnectionOptions?
        /**
         * The static routes associated with the VPN connection.
         */
        var routes: List<VpnStaticRoute>?
        /**
         * The current state of the VPN connection.
         */
        var state: VpnState?
        /**
         * Any tags assigned to the VPN connection.
         */
        var tags: List<Tag>?
        /**
         * The ID of the transit gateway associated with the VPN connection.
         */
        var transitGatewayId: String?
        /**
         * The type of VPN connection.
         */
        var type: GatewayType?
        /**
         * Information about the VPN tunnel.
         */
        var vgwTelemetry: List<VgwTelemetry>?
        /**
         * The ID of the VPN connection.
         */
        var vpnConnectionId: String?
        /**
         * The ID of the virtual private gateway at the Amazon Web Services side of the VPN
         * connection.
         */
        var vpnGatewayId: String?

        fun build(): VpnConnection
        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.VpnConnectionOptions] inside the given [block]
         */
        fun options(block: VpnConnectionOptions.DslBuilder.() -> kotlin.Unit) {
            this.options = VpnConnectionOptions.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var category: String? = null
        override var coreNetworkArn: String? = null
        override var coreNetworkAttachmentArn: String? = null
        override var customerGatewayConfiguration: String? = null
        override var customerGatewayId: String? = null
        override var gatewayAssociationState: String? = null
        override var options: VpnConnectionOptions? = null
        override var routes: List<VpnStaticRoute>? = null
        override var state: VpnState? = null
        override var tags: List<Tag>? = null
        override var transitGatewayId: String? = null
        override var type: GatewayType? = null
        override var vgwTelemetry: List<VgwTelemetry>? = null
        override var vpnConnectionId: String? = null
        override var vpnGatewayId: String? = null

        constructor(x: VpnConnection) : this() {
            this.category = x.category
            this.coreNetworkArn = x.coreNetworkArn
            this.coreNetworkAttachmentArn = x.coreNetworkAttachmentArn
            this.customerGatewayConfiguration = x.customerGatewayConfiguration
            this.customerGatewayId = x.customerGatewayId
            this.gatewayAssociationState = x.gatewayAssociationState
            this.options = x.options
            this.routes = x.routes
            this.state = x.state
            this.tags = x.tags
            this.transitGatewayId = x.transitGatewayId
            this.type = x.type
            this.vgwTelemetry = x.vgwTelemetry
            this.vpnConnectionId = x.vpnConnectionId
            this.vpnGatewayId = x.vpnGatewayId
        }

        override fun build(): VpnConnection = VpnConnection(this)
        override fun category(category: String): FluentBuilder = apply { this.category = category }
        override fun coreNetworkArn(coreNetworkArn: String): FluentBuilder = apply { this.coreNetworkArn = coreNetworkArn }
        override fun coreNetworkAttachmentArn(coreNetworkAttachmentArn: String): FluentBuilder = apply { this.coreNetworkAttachmentArn = coreNetworkAttachmentArn }
        override fun customerGatewayConfiguration(customerGatewayConfiguration: String): FluentBuilder = apply { this.customerGatewayConfiguration = customerGatewayConfiguration }
        override fun customerGatewayId(customerGatewayId: String): FluentBuilder = apply { this.customerGatewayId = customerGatewayId }
        override fun gatewayAssociationState(gatewayAssociationState: String): FluentBuilder = apply { this.gatewayAssociationState = gatewayAssociationState }
        override fun options(options: VpnConnectionOptions): FluentBuilder = apply { this.options = options }
        override fun routes(routes: List<VpnStaticRoute>): FluentBuilder = apply { this.routes = routes }
        override fun state(state: VpnState): FluentBuilder = apply { this.state = state }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun transitGatewayId(transitGatewayId: String): FluentBuilder = apply { this.transitGatewayId = transitGatewayId }
        override fun type(type: GatewayType): FluentBuilder = apply { this.type = type }
        override fun vgwTelemetry(vgwTelemetry: List<VgwTelemetry>): FluentBuilder = apply { this.vgwTelemetry = vgwTelemetry }
        override fun vpnConnectionId(vpnConnectionId: String): FluentBuilder = apply { this.vpnConnectionId = vpnConnectionId }
        override fun vpnGatewayId(vpnGatewayId: String): FluentBuilder = apply { this.vpnGatewayId = vpnGatewayId }
    }
}
