// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * List of customer gateway devices that have a sample configuration file available for
 * use. You can also see the list of device types with sample configuration files available
 * under <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/your-cgw.html">Your customer
 * gateway device in the Amazon Web Services Site-to-Site VPN User Guide.
 */
class VpnConnectionDeviceType private constructor(builder: BuilderImpl) {
    /**
     * Customer gateway device platform.
     */
    val platform: String? = builder.platform
    /**
     * Customer gateway device software version.
     */
    val software: String? = builder.software
    /**
     * Customer gateway device vendor.
     */
    val vendor: String? = builder.vendor
    /**
     * Customer gateway device identifier.
     */
    val vpnConnectionDeviceTypeId: String? = builder.vpnConnectionDeviceTypeId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): VpnConnectionDeviceType = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("VpnConnectionDeviceType(")
        append("platform=$platform,")
        append("software=$software,")
        append("vendor=$vendor,")
        append("vpnConnectionDeviceTypeId=$vpnConnectionDeviceTypeId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = platform?.hashCode() ?: 0
        result = 31 * result + (software?.hashCode() ?: 0)
        result = 31 * result + (vendor?.hashCode() ?: 0)
        result = 31 * result + (vpnConnectionDeviceTypeId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as VpnConnectionDeviceType

        if (platform != other.platform) return false
        if (software != other.software) return false
        if (vendor != other.vendor) return false
        if (vpnConnectionDeviceTypeId != other.vpnConnectionDeviceTypeId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): VpnConnectionDeviceType = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): VpnConnectionDeviceType
        /**
         * Customer gateway device platform.
         */
        fun platform(platform: String): FluentBuilder
        /**
         * Customer gateway device software version.
         */
        fun software(software: String): FluentBuilder
        /**
         * Customer gateway device vendor.
         */
        fun vendor(vendor: String): FluentBuilder
        /**
         * Customer gateway device identifier.
         */
        fun vpnConnectionDeviceTypeId(vpnConnectionDeviceTypeId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Customer gateway device platform.
         */
        var platform: String?
        /**
         * Customer gateway device software version.
         */
        var software: String?
        /**
         * Customer gateway device vendor.
         */
        var vendor: String?
        /**
         * Customer gateway device identifier.
         */
        var vpnConnectionDeviceTypeId: String?

        fun build(): VpnConnectionDeviceType
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var platform: String? = null
        override var software: String? = null
        override var vendor: String? = null
        override var vpnConnectionDeviceTypeId: String? = null

        constructor(x: VpnConnectionDeviceType) : this() {
            this.platform = x.platform
            this.software = x.software
            this.vendor = x.vendor
            this.vpnConnectionDeviceTypeId = x.vpnConnectionDeviceTypeId
        }

        override fun build(): VpnConnectionDeviceType = VpnConnectionDeviceType(this)
        override fun platform(platform: String): FluentBuilder = apply { this.platform = platform }
        override fun software(software: String): FluentBuilder = apply { this.software = software }
        override fun vendor(vendor: String): FluentBuilder = apply { this.vendor = vendor }
        override fun vpnConnectionDeviceTypeId(vpnConnectionDeviceTypeId: String): FluentBuilder = apply { this.vpnConnectionDeviceTypeId = vpnConnectionDeviceTypeId }
    }
}
