// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes VPN connection options.
 */
class VpnConnectionOptions private constructor(builder: BuilderImpl) {
    /**
     * Indicates whether acceleration is enabled for the VPN connection.
     */
    val enableAcceleration: Boolean? = builder.enableAcceleration
    /**
     * The IPv4 CIDR on the customer gateway (on-premises) side of the VPN connection.
     */
    val localIpv4NetworkCidr: String? = builder.localIpv4NetworkCidr
    /**
     * The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.
     */
    val localIpv6NetworkCidr: String? = builder.localIpv6NetworkCidr
    /**
     * The IPv4 CIDR on the Amazon Web Services side of the VPN connection.
     */
    val remoteIpv4NetworkCidr: String? = builder.remoteIpv4NetworkCidr
    /**
     * The IPv6 CIDR on the Amazon Web Services side of the VPN connection.
     */
    val remoteIpv6NetworkCidr: String? = builder.remoteIpv6NetworkCidr
    /**
     * Indicates whether the VPN connection uses static routes only. Static routes must be
     * used for devices that don't support BGP.
     */
    val staticRoutesOnly: Boolean? = builder.staticRoutesOnly
    /**
     * Indicates whether the VPN tunnels process IPv4 or IPv6 traffic.
     */
    val tunnelInsideIpVersion: TunnelInsideIpVersion? = builder.tunnelInsideIpVersion
    /**
     * Indicates the VPN tunnel options.
     */
    val tunnelOptions: List<TunnelOption>? = builder.tunnelOptions

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): VpnConnectionOptions = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("VpnConnectionOptions(")
        append("enableAcceleration=$enableAcceleration,")
        append("localIpv4NetworkCidr=$localIpv4NetworkCidr,")
        append("localIpv6NetworkCidr=$localIpv6NetworkCidr,")
        append("remoteIpv4NetworkCidr=$remoteIpv4NetworkCidr,")
        append("remoteIpv6NetworkCidr=$remoteIpv6NetworkCidr,")
        append("staticRoutesOnly=$staticRoutesOnly,")
        append("tunnelInsideIpVersion=$tunnelInsideIpVersion,")
        append("tunnelOptions=$tunnelOptions)")
    }

    override fun hashCode(): kotlin.Int {
        var result = enableAcceleration?.hashCode() ?: 0
        result = 31 * result + (localIpv4NetworkCidr?.hashCode() ?: 0)
        result = 31 * result + (localIpv6NetworkCidr?.hashCode() ?: 0)
        result = 31 * result + (remoteIpv4NetworkCidr?.hashCode() ?: 0)
        result = 31 * result + (remoteIpv6NetworkCidr?.hashCode() ?: 0)
        result = 31 * result + (staticRoutesOnly?.hashCode() ?: 0)
        result = 31 * result + (tunnelInsideIpVersion?.hashCode() ?: 0)
        result = 31 * result + (tunnelOptions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as VpnConnectionOptions

        if (enableAcceleration != other.enableAcceleration) return false
        if (localIpv4NetworkCidr != other.localIpv4NetworkCidr) return false
        if (localIpv6NetworkCidr != other.localIpv6NetworkCidr) return false
        if (remoteIpv4NetworkCidr != other.remoteIpv4NetworkCidr) return false
        if (remoteIpv6NetworkCidr != other.remoteIpv6NetworkCidr) return false
        if (staticRoutesOnly != other.staticRoutesOnly) return false
        if (tunnelInsideIpVersion != other.tunnelInsideIpVersion) return false
        if (tunnelOptions != other.tunnelOptions) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): VpnConnectionOptions = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): VpnConnectionOptions
        /**
         * Indicates whether acceleration is enabled for the VPN connection.
         */
        fun enableAcceleration(enableAcceleration: Boolean): FluentBuilder
        /**
         * The IPv4 CIDR on the customer gateway (on-premises) side of the VPN connection.
         */
        fun localIpv4NetworkCidr(localIpv4NetworkCidr: String): FluentBuilder
        /**
         * The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.
         */
        fun localIpv6NetworkCidr(localIpv6NetworkCidr: String): FluentBuilder
        /**
         * The IPv4 CIDR on the Amazon Web Services side of the VPN connection.
         */
        fun remoteIpv4NetworkCidr(remoteIpv4NetworkCidr: String): FluentBuilder
        /**
         * The IPv6 CIDR on the Amazon Web Services side of the VPN connection.
         */
        fun remoteIpv6NetworkCidr(remoteIpv6NetworkCidr: String): FluentBuilder
        /**
         * Indicates whether the VPN connection uses static routes only. Static routes must be
         * used for devices that don't support BGP.
         */
        fun staticRoutesOnly(staticRoutesOnly: Boolean): FluentBuilder
        /**
         * Indicates whether the VPN tunnels process IPv4 or IPv6 traffic.
         */
        fun tunnelInsideIpVersion(tunnelInsideIpVersion: TunnelInsideIpVersion): FluentBuilder
        /**
         * Indicates the VPN tunnel options.
         */
        fun tunnelOptions(tunnelOptions: List<TunnelOption>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Indicates whether acceleration is enabled for the VPN connection.
         */
        var enableAcceleration: Boolean?
        /**
         * The IPv4 CIDR on the customer gateway (on-premises) side of the VPN connection.
         */
        var localIpv4NetworkCidr: String?
        /**
         * The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.
         */
        var localIpv6NetworkCidr: String?
        /**
         * The IPv4 CIDR on the Amazon Web Services side of the VPN connection.
         */
        var remoteIpv4NetworkCidr: String?
        /**
         * The IPv6 CIDR on the Amazon Web Services side of the VPN connection.
         */
        var remoteIpv6NetworkCidr: String?
        /**
         * Indicates whether the VPN connection uses static routes only. Static routes must be
         * used for devices that don't support BGP.
         */
        var staticRoutesOnly: Boolean?
        /**
         * Indicates whether the VPN tunnels process IPv4 or IPv6 traffic.
         */
        var tunnelInsideIpVersion: TunnelInsideIpVersion?
        /**
         * Indicates the VPN tunnel options.
         */
        var tunnelOptions: List<TunnelOption>?

        fun build(): VpnConnectionOptions
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var enableAcceleration: Boolean? = null
        override var localIpv4NetworkCidr: String? = null
        override var localIpv6NetworkCidr: String? = null
        override var remoteIpv4NetworkCidr: String? = null
        override var remoteIpv6NetworkCidr: String? = null
        override var staticRoutesOnly: Boolean? = null
        override var tunnelInsideIpVersion: TunnelInsideIpVersion? = null
        override var tunnelOptions: List<TunnelOption>? = null

        constructor(x: VpnConnectionOptions) : this() {
            this.enableAcceleration = x.enableAcceleration
            this.localIpv4NetworkCidr = x.localIpv4NetworkCidr
            this.localIpv6NetworkCidr = x.localIpv6NetworkCidr
            this.remoteIpv4NetworkCidr = x.remoteIpv4NetworkCidr
            this.remoteIpv6NetworkCidr = x.remoteIpv6NetworkCidr
            this.staticRoutesOnly = x.staticRoutesOnly
            this.tunnelInsideIpVersion = x.tunnelInsideIpVersion
            this.tunnelOptions = x.tunnelOptions
        }

        override fun build(): VpnConnectionOptions = VpnConnectionOptions(this)
        override fun enableAcceleration(enableAcceleration: Boolean): FluentBuilder = apply { this.enableAcceleration = enableAcceleration }
        override fun localIpv4NetworkCidr(localIpv4NetworkCidr: String): FluentBuilder = apply { this.localIpv4NetworkCidr = localIpv4NetworkCidr }
        override fun localIpv6NetworkCidr(localIpv6NetworkCidr: String): FluentBuilder = apply { this.localIpv6NetworkCidr = localIpv6NetworkCidr }
        override fun remoteIpv4NetworkCidr(remoteIpv4NetworkCidr: String): FluentBuilder = apply { this.remoteIpv4NetworkCidr = remoteIpv4NetworkCidr }
        override fun remoteIpv6NetworkCidr(remoteIpv6NetworkCidr: String): FluentBuilder = apply { this.remoteIpv6NetworkCidr = remoteIpv6NetworkCidr }
        override fun staticRoutesOnly(staticRoutesOnly: Boolean): FluentBuilder = apply { this.staticRoutesOnly = staticRoutesOnly }
        override fun tunnelInsideIpVersion(tunnelInsideIpVersion: TunnelInsideIpVersion): FluentBuilder = apply { this.tunnelInsideIpVersion = tunnelInsideIpVersion }
        override fun tunnelOptions(tunnelOptions: List<TunnelOption>): FluentBuilder = apply { this.tunnelOptions = tunnelOptions }
    }
}
