// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes VPN connection options.
 */
class VpnConnectionOptionsSpecification private constructor(builder: BuilderImpl) {
    /**
     * Indicate whether to enable acceleration for the VPN connection.
     * Default: false
     */
    val enableAcceleration: Boolean? = builder.enableAcceleration
    /**
     * The IPv4 CIDR on the customer gateway (on-premises) side of the VPN connection.
     * Default: 0.0.0.0/0
     */
    val localIpv4NetworkCidr: String? = builder.localIpv4NetworkCidr
    /**
     * The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.
     * Default: ::/0
     */
    val localIpv6NetworkCidr: String? = builder.localIpv6NetworkCidr
    /**
     * The IPv4 CIDR on the Amazon Web Services side of the VPN connection.
     * Default: 0.0.0.0/0
     */
    val remoteIpv4NetworkCidr: String? = builder.remoteIpv4NetworkCidr
    /**
     * The IPv6 CIDR on the Amazon Web Services side of the VPN connection.
     * Default: ::/0
     */
    val remoteIpv6NetworkCidr: String? = builder.remoteIpv6NetworkCidr
    /**
     * Indicate whether the VPN connection uses static routes only. If you are creating a VPN
     * connection for a device that does not support BGP, you must specify true.
     * Use CreateVpnConnectionRoute to create a static route.
     * Default: false
     */
    val staticRoutesOnly: Boolean? = builder.staticRoutesOnly
    /**
     * Indicate whether the VPN tunnels process IPv4 or IPv6 traffic.
     * Default: ipv4
     */
    val tunnelInsideIpVersion: TunnelInsideIpVersion? = builder.tunnelInsideIpVersion
    /**
     * The tunnel options for the VPN connection.
     */
    val tunnelOptions: List<VpnTunnelOptionsSpecification>? = builder.tunnelOptions

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): VpnConnectionOptionsSpecification = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("VpnConnectionOptionsSpecification(")
        append("enableAcceleration=$enableAcceleration,")
        append("localIpv4NetworkCidr=$localIpv4NetworkCidr,")
        append("localIpv6NetworkCidr=$localIpv6NetworkCidr,")
        append("remoteIpv4NetworkCidr=$remoteIpv4NetworkCidr,")
        append("remoteIpv6NetworkCidr=$remoteIpv6NetworkCidr,")
        append("staticRoutesOnly=$staticRoutesOnly,")
        append("tunnelInsideIpVersion=$tunnelInsideIpVersion,")
        append("tunnelOptions=$tunnelOptions)")
    }

    override fun hashCode(): kotlin.Int {
        var result = enableAcceleration?.hashCode() ?: 0
        result = 31 * result + (localIpv4NetworkCidr?.hashCode() ?: 0)
        result = 31 * result + (localIpv6NetworkCidr?.hashCode() ?: 0)
        result = 31 * result + (remoteIpv4NetworkCidr?.hashCode() ?: 0)
        result = 31 * result + (remoteIpv6NetworkCidr?.hashCode() ?: 0)
        result = 31 * result + (staticRoutesOnly?.hashCode() ?: 0)
        result = 31 * result + (tunnelInsideIpVersion?.hashCode() ?: 0)
        result = 31 * result + (tunnelOptions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as VpnConnectionOptionsSpecification

        if (enableAcceleration != other.enableAcceleration) return false
        if (localIpv4NetworkCidr != other.localIpv4NetworkCidr) return false
        if (localIpv6NetworkCidr != other.localIpv6NetworkCidr) return false
        if (remoteIpv4NetworkCidr != other.remoteIpv4NetworkCidr) return false
        if (remoteIpv6NetworkCidr != other.remoteIpv6NetworkCidr) return false
        if (staticRoutesOnly != other.staticRoutesOnly) return false
        if (tunnelInsideIpVersion != other.tunnelInsideIpVersion) return false
        if (tunnelOptions != other.tunnelOptions) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): VpnConnectionOptionsSpecification = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): VpnConnectionOptionsSpecification
        /**
         * Indicate whether to enable acceleration for the VPN connection.
         * Default: false
         */
        fun enableAcceleration(enableAcceleration: Boolean): FluentBuilder
        /**
         * The IPv4 CIDR on the customer gateway (on-premises) side of the VPN connection.
         * Default: 0.0.0.0/0
         */
        fun localIpv4NetworkCidr(localIpv4NetworkCidr: String): FluentBuilder
        /**
         * The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.
         * Default: ::/0
         */
        fun localIpv6NetworkCidr(localIpv6NetworkCidr: String): FluentBuilder
        /**
         * The IPv4 CIDR on the Amazon Web Services side of the VPN connection.
         * Default: 0.0.0.0/0
         */
        fun remoteIpv4NetworkCidr(remoteIpv4NetworkCidr: String): FluentBuilder
        /**
         * The IPv6 CIDR on the Amazon Web Services side of the VPN connection.
         * Default: ::/0
         */
        fun remoteIpv6NetworkCidr(remoteIpv6NetworkCidr: String): FluentBuilder
        /**
         * Indicate whether the VPN connection uses static routes only. If you are creating a VPN
         * connection for a device that does not support BGP, you must specify true.
         * Use CreateVpnConnectionRoute to create a static route.
         * Default: false
         */
        fun staticRoutesOnly(staticRoutesOnly: Boolean): FluentBuilder
        /**
         * Indicate whether the VPN tunnels process IPv4 or IPv6 traffic.
         * Default: ipv4
         */
        fun tunnelInsideIpVersion(tunnelInsideIpVersion: TunnelInsideIpVersion): FluentBuilder
        /**
         * The tunnel options for the VPN connection.
         */
        fun tunnelOptions(tunnelOptions: List<VpnTunnelOptionsSpecification>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Indicate whether to enable acceleration for the VPN connection.
         * Default: false
         */
        var enableAcceleration: Boolean?
        /**
         * The IPv4 CIDR on the customer gateway (on-premises) side of the VPN connection.
         * Default: 0.0.0.0/0
         */
        var localIpv4NetworkCidr: String?
        /**
         * The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.
         * Default: ::/0
         */
        var localIpv6NetworkCidr: String?
        /**
         * The IPv4 CIDR on the Amazon Web Services side of the VPN connection.
         * Default: 0.0.0.0/0
         */
        var remoteIpv4NetworkCidr: String?
        /**
         * The IPv6 CIDR on the Amazon Web Services side of the VPN connection.
         * Default: ::/0
         */
        var remoteIpv6NetworkCidr: String?
        /**
         * Indicate whether the VPN connection uses static routes only. If you are creating a VPN
         * connection for a device that does not support BGP, you must specify true.
         * Use CreateVpnConnectionRoute to create a static route.
         * Default: false
         */
        var staticRoutesOnly: Boolean?
        /**
         * Indicate whether the VPN tunnels process IPv4 or IPv6 traffic.
         * Default: ipv4
         */
        var tunnelInsideIpVersion: TunnelInsideIpVersion?
        /**
         * The tunnel options for the VPN connection.
         */
        var tunnelOptions: List<VpnTunnelOptionsSpecification>?

        fun build(): VpnConnectionOptionsSpecification
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var enableAcceleration: Boolean? = null
        override var localIpv4NetworkCidr: String? = null
        override var localIpv6NetworkCidr: String? = null
        override var remoteIpv4NetworkCidr: String? = null
        override var remoteIpv6NetworkCidr: String? = null
        override var staticRoutesOnly: Boolean? = null
        override var tunnelInsideIpVersion: TunnelInsideIpVersion? = null
        override var tunnelOptions: List<VpnTunnelOptionsSpecification>? = null

        constructor(x: VpnConnectionOptionsSpecification) : this() {
            this.enableAcceleration = x.enableAcceleration
            this.localIpv4NetworkCidr = x.localIpv4NetworkCidr
            this.localIpv6NetworkCidr = x.localIpv6NetworkCidr
            this.remoteIpv4NetworkCidr = x.remoteIpv4NetworkCidr
            this.remoteIpv6NetworkCidr = x.remoteIpv6NetworkCidr
            this.staticRoutesOnly = x.staticRoutesOnly
            this.tunnelInsideIpVersion = x.tunnelInsideIpVersion
            this.tunnelOptions = x.tunnelOptions
        }

        override fun build(): VpnConnectionOptionsSpecification = VpnConnectionOptionsSpecification(this)
        override fun enableAcceleration(enableAcceleration: Boolean): FluentBuilder = apply { this.enableAcceleration = enableAcceleration }
        override fun localIpv4NetworkCidr(localIpv4NetworkCidr: String): FluentBuilder = apply { this.localIpv4NetworkCidr = localIpv4NetworkCidr }
        override fun localIpv6NetworkCidr(localIpv6NetworkCidr: String): FluentBuilder = apply { this.localIpv6NetworkCidr = localIpv6NetworkCidr }
        override fun remoteIpv4NetworkCidr(remoteIpv4NetworkCidr: String): FluentBuilder = apply { this.remoteIpv4NetworkCidr = remoteIpv4NetworkCidr }
        override fun remoteIpv6NetworkCidr(remoteIpv6NetworkCidr: String): FluentBuilder = apply { this.remoteIpv6NetworkCidr = remoteIpv6NetworkCidr }
        override fun staticRoutesOnly(staticRoutesOnly: Boolean): FluentBuilder = apply { this.staticRoutesOnly = staticRoutesOnly }
        override fun tunnelInsideIpVersion(tunnelInsideIpVersion: TunnelInsideIpVersion): FluentBuilder = apply { this.tunnelInsideIpVersion = tunnelInsideIpVersion }
        override fun tunnelOptions(tunnelOptions: List<VpnTunnelOptionsSpecification>): FluentBuilder = apply { this.tunnelOptions = tunnelOptions }
    }
}
