// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a virtual private gateway.
 */
class VpnGateway private constructor(builder: BuilderImpl) {
    /**
     * The private Autonomous System Number (ASN) for the Amazon side of a BGP
     * session.
     */
    val amazonSideAsn: Long? = builder.amazonSideAsn
    /**
     * The Availability Zone where the virtual private gateway was created, if applicable.
     * This field may be empty or not returned.
     */
    val availabilityZone: String? = builder.availabilityZone
    /**
     * The current state of the virtual private gateway.
     */
    val state: VpnState? = builder.state
    /**
     * Any tags assigned to the virtual private gateway.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The type of VPN connection the virtual private gateway supports.
     */
    val type: GatewayType? = builder.type
    /**
     * Any VPCs attached to the virtual private gateway.
     */
    val vpcAttachments: List<VpcAttachment>? = builder.vpcAttachments
    /**
     * The ID of the virtual private gateway.
     */
    val vpnGatewayId: String? = builder.vpnGatewayId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): VpnGateway = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("VpnGateway(")
        append("amazonSideAsn=$amazonSideAsn,")
        append("availabilityZone=$availabilityZone,")
        append("state=$state,")
        append("tags=$tags,")
        append("type=$type,")
        append("vpcAttachments=$vpcAttachments,")
        append("vpnGatewayId=$vpnGatewayId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = amazonSideAsn?.hashCode() ?: 0
        result = 31 * result + (availabilityZone?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (vpcAttachments?.hashCode() ?: 0)
        result = 31 * result + (vpnGatewayId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as VpnGateway

        if (amazonSideAsn != other.amazonSideAsn) return false
        if (availabilityZone != other.availabilityZone) return false
        if (state != other.state) return false
        if (tags != other.tags) return false
        if (type != other.type) return false
        if (vpcAttachments != other.vpcAttachments) return false
        if (vpnGatewayId != other.vpnGatewayId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): VpnGateway = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): VpnGateway
        /**
         * The private Autonomous System Number (ASN) for the Amazon side of a BGP
         * session.
         */
        fun amazonSideAsn(amazonSideAsn: Long): FluentBuilder
        /**
         * The Availability Zone where the virtual private gateway was created, if applicable.
         * This field may be empty or not returned.
         */
        fun availabilityZone(availabilityZone: String): FluentBuilder
        /**
         * The current state of the virtual private gateway.
         */
        fun state(state: VpnState): FluentBuilder
        /**
         * Any tags assigned to the virtual private gateway.
         */
        fun tags(tags: List<Tag>): FluentBuilder
        /**
         * The type of VPN connection the virtual private gateway supports.
         */
        fun type(type: GatewayType): FluentBuilder
        /**
         * Any VPCs attached to the virtual private gateway.
         */
        fun vpcAttachments(vpcAttachments: List<VpcAttachment>): FluentBuilder
        /**
         * The ID of the virtual private gateway.
         */
        fun vpnGatewayId(vpnGatewayId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The private Autonomous System Number (ASN) for the Amazon side of a BGP
         * session.
         */
        var amazonSideAsn: Long?
        /**
         * The Availability Zone where the virtual private gateway was created, if applicable.
         * This field may be empty or not returned.
         */
        var availabilityZone: String?
        /**
         * The current state of the virtual private gateway.
         */
        var state: VpnState?
        /**
         * Any tags assigned to the virtual private gateway.
         */
        var tags: List<Tag>?
        /**
         * The type of VPN connection the virtual private gateway supports.
         */
        var type: GatewayType?
        /**
         * Any VPCs attached to the virtual private gateway.
         */
        var vpcAttachments: List<VpcAttachment>?
        /**
         * The ID of the virtual private gateway.
         */
        var vpnGatewayId: String?

        fun build(): VpnGateway
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var amazonSideAsn: Long? = null
        override var availabilityZone: String? = null
        override var state: VpnState? = null
        override var tags: List<Tag>? = null
        override var type: GatewayType? = null
        override var vpcAttachments: List<VpcAttachment>? = null
        override var vpnGatewayId: String? = null

        constructor(x: VpnGateway) : this() {
            this.amazonSideAsn = x.amazonSideAsn
            this.availabilityZone = x.availabilityZone
            this.state = x.state
            this.tags = x.tags
            this.type = x.type
            this.vpcAttachments = x.vpcAttachments
            this.vpnGatewayId = x.vpnGatewayId
        }

        override fun build(): VpnGateway = VpnGateway(this)
        override fun amazonSideAsn(amazonSideAsn: Long): FluentBuilder = apply { this.amazonSideAsn = amazonSideAsn }
        override fun availabilityZone(availabilityZone: String): FluentBuilder = apply { this.availabilityZone = availabilityZone }
        override fun state(state: VpnState): FluentBuilder = apply { this.state = state }
        override fun tags(tags: List<Tag>): FluentBuilder = apply { this.tags = tags }
        override fun type(type: GatewayType): FluentBuilder = apply { this.type = type }
        override fun vpcAttachments(vpcAttachments: List<VpcAttachment>): FluentBuilder = apply { this.vpcAttachments = vpcAttachments }
        override fun vpnGatewayId(vpnGatewayId: String): FluentBuilder = apply { this.vpnGatewayId = vpnGatewayId }
    }
}
