// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseEc2QueryErrorResponse
import aws.sdk.kotlin.services.ec2.model.AssignIpv6AddressesResponse
import aws.sdk.kotlin.services.ec2.model.Ec2Exception
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlCollectionName
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class AssignIpv6AddressesOperationDeserializer: HttpDeserialize<AssignIpv6AddressesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): AssignIpv6AddressesResponse {
        if (!response.status.isSuccess()) {
            throwAssignIpv6AddressesError(context, response)
        }
        val builder = AssignIpv6AddressesResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeAssignIpv6AddressesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeAssignIpv6AddressesOperationBody(builder: AssignIpv6AddressesResponse.DslBuilder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    val ASSIGNEDIPV6ADDRESSES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("assignedIpv6Addresses"), XmlCollectionName("item"))
    val ASSIGNEDIPV6PREFIXES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("assignedIpv6PrefixSet"), XmlCollectionName("item"))
    val NETWORKINTERFACEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("networkInterfaceId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://ec2.amazonaws.com/doc/2016-11-15"))
        trait(XmlSerialName("AssignIpv6AddressesResult"))
        field(ASSIGNEDIPV6ADDRESSES_DESCRIPTOR)
        field(ASSIGNEDIPV6PREFIXES_DESCRIPTOR)
        field(NETWORKINTERFACEID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ASSIGNEDIPV6ADDRESSES_DESCRIPTOR.index -> builder.assignedIpv6Addresses =
                    deserializer.deserializeList(ASSIGNEDIPV6ADDRESSES_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ASSIGNEDIPV6PREFIXES_DESCRIPTOR.index -> builder.assignedIpv6Prefixes =
                    deserializer.deserializeList(ASSIGNEDIPV6PREFIXES_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NETWORKINTERFACEID_DESCRIPTOR.index -> builder.networkInterfaceId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwAssignIpv6AddressesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseEc2QueryErrorResponse(payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as ec2Query error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    throw Ec2Exception(errorDetails.message)
}
