// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.transform

import aws.sdk.kotlin.services.ec2.model.CreateFlowLogsRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlFlattened
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerialName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializer
import aws.smithy.kotlin.runtime.serde.formurl.QueryLiteral
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateFlowLogsOperationSerializer: HttpSerialize<CreateFlowLogsRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateFlowLogsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeCreateFlowLogsOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        builder.headers.setMissing("Content-Type", "application/x-www-form-urlencoded")
        return builder
    }
}

private fun serializeCreateFlowLogsOperationBody(context: ExecutionContext, input: CreateFlowLogsRequest): ByteArray {
    val serializer = FormUrlSerializer()
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("ClientToken"))
    val DELIVERLOGSPERMISSIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("DeliverLogsPermissionArn"))
    val DESTINATIONOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, FormUrlSerialName("DestinationOptions"))
    val DRYRUN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("DryRun"))
    val LOGDESTINATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("LogDestination"))
    val LOGDESTINATIONTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("LogDestinationType"))
    val LOGFORMAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("LogFormat"))
    val LOGGROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("LogGroupName"))
    val MAXAGGREGATIONINTERVAL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("MaxAggregationInterval"))
    val RESOURCEIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("ResourceId"), FormUrlFlattened)
    val RESOURCETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("ResourceType"))
    val TAGSPECIFICATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("TagSpecification"), FormUrlFlattened)
    val TRAFFICTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("TrafficType"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(FormUrlSerialName("CreateFlowLogsRequest"))
        trait(QueryLiteral("Action", "CreateFlowLogs"))
        trait(QueryLiteral("Version", "2016-11-15"))
        field(CLIENTTOKEN_DESCRIPTOR)
        field(DELIVERLOGSPERMISSIONARN_DESCRIPTOR)
        field(DESTINATIONOPTIONS_DESCRIPTOR)
        field(DRYRUN_DESCRIPTOR)
        field(LOGDESTINATION_DESCRIPTOR)
        field(LOGDESTINATIONTYPE_DESCRIPTOR)
        field(LOGFORMAT_DESCRIPTOR)
        field(LOGGROUPNAME_DESCRIPTOR)
        field(MAXAGGREGATIONINTERVAL_DESCRIPTOR)
        field(RESOURCEIDS_DESCRIPTOR)
        field(RESOURCETYPE_DESCRIPTOR)
        field(TAGSPECIFICATIONS_DESCRIPTOR)
        field(TRAFFICTYPE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) }
        input.deliverLogsPermissionArn?.let { field(DELIVERLOGSPERMISSIONARN_DESCRIPTOR, it) }
        input.destinationOptions?.let { field(DESTINATIONOPTIONS_DESCRIPTOR, it, ::serializeDestinationOptionsRequestDocument) }
        input.dryRun?.let { field(DRYRUN_DESCRIPTOR, it) }
        input.logDestination?.let { field(LOGDESTINATION_DESCRIPTOR, it) }
        input.logDestinationType?.let { field(LOGDESTINATIONTYPE_DESCRIPTOR, it.value) }
        input.logFormat?.let { field(LOGFORMAT_DESCRIPTOR, it) }
        input.logGroupName?.let { field(LOGGROUPNAME_DESCRIPTOR, it) }
        input.maxAggregationInterval?.let { field(MAXAGGREGATIONINTERVAL_DESCRIPTOR, it) }
        if (input.resourceIds != null) {
            listField(RESOURCEIDS_DESCRIPTOR) {
                for (el0 in input.resourceIds) {
                    serializeString(el0)
                }
            }
        }
        input.resourceType?.let { field(RESOURCETYPE_DESCRIPTOR, it.value) }
        if (input.tagSpecifications != null) {
            listField(TAGSPECIFICATIONS_DESCRIPTOR) {
                for (el0 in input.tagSpecifications) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagSpecificationDocument))
                }
            }
        }
        input.trafficType?.let { field(TRAFFICTYPE_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
