// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseEc2QueryErrorResponse
import aws.sdk.kotlin.services.ec2.model.BlockDeviceMapping
import aws.sdk.kotlin.services.ec2.model.DescribeImageAttributeResponse
import aws.sdk.kotlin.services.ec2.model.Ec2Exception
import aws.sdk.kotlin.services.ec2.model.LaunchPermission
import aws.sdk.kotlin.services.ec2.model.ProductCode
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlCollectionName
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class DescribeImageAttributeOperationDeserializer: HttpDeserialize<DescribeImageAttributeResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeImageAttributeResponse {
        if (!response.status.isSuccess()) {
            throwDescribeImageAttributeError(context, response)
        }
        val builder = DescribeImageAttributeResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeImageAttributeOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeDescribeImageAttributeOperationBody(builder: DescribeImageAttributeResponse.DslBuilder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    val BLOCKDEVICEMAPPINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("blockDeviceMapping"), XmlCollectionName("item"))
    val BOOTMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("bootMode"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("description"))
    val IMAGEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("imageId"))
    val KERNELID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("kernel"))
    val LAUNCHPERMISSIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("launchPermission"), XmlCollectionName("item"))
    val PRODUCTCODES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("productCodes"), XmlCollectionName("item"))
    val RAMDISKID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("ramdisk"))
    val SRIOVNETSUPPORT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("sriovNetSupport"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://ec2.amazonaws.com/doc/2016-11-15"))
        trait(XmlSerialName("DescribeImageAttributeResult"))
        field(BLOCKDEVICEMAPPINGS_DESCRIPTOR)
        field(BOOTMODE_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(IMAGEID_DESCRIPTOR)
        field(KERNELID_DESCRIPTOR)
        field(LAUNCHPERMISSIONS_DESCRIPTOR)
        field(PRODUCTCODES_DESCRIPTOR)
        field(RAMDISKID_DESCRIPTOR)
        field(SRIOVNETSUPPORT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BLOCKDEVICEMAPPINGS_DESCRIPTOR.index -> builder.blockDeviceMappings =
                    deserializer.deserializeList(BLOCKDEVICEMAPPINGS_DESCRIPTOR) {
                        val col0 = mutableListOf<BlockDeviceMapping>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBlockDeviceMappingDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                BOOTMODE_DESCRIPTOR.index -> builder.bootMode = deserializeAttributeValueDocument(deserializer)
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeAttributeValueDocument(deserializer)
                IMAGEID_DESCRIPTOR.index -> builder.imageId = deserializeString()
                KERNELID_DESCRIPTOR.index -> builder.kernelId = deserializeAttributeValueDocument(deserializer)
                LAUNCHPERMISSIONS_DESCRIPTOR.index -> builder.launchPermissions =
                    deserializer.deserializeList(LAUNCHPERMISSIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<LaunchPermission>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeLaunchPermissionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                PRODUCTCODES_DESCRIPTOR.index -> builder.productCodes =
                    deserializer.deserializeList(PRODUCTCODES_DESCRIPTOR) {
                        val col0 = mutableListOf<ProductCode>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeProductCodeDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                RAMDISKID_DESCRIPTOR.index -> builder.ramdiskId = deserializeAttributeValueDocument(deserializer)
                SRIOVNETSUPPORT_DESCRIPTOR.index -> builder.sriovNetSupport = deserializeAttributeValueDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwDescribeImageAttributeError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseEc2QueryErrorResponse(payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as ec2Query error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    throw Ec2Exception(errorDetails.message)
}
