// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.transform

import aws.sdk.kotlin.services.ec2.model.ImportSnapshotRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlFlattened
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerialName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializer
import aws.smithy.kotlin.runtime.serde.formurl.QueryLiteral
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ImportSnapshotOperationSerializer: HttpSerialize<ImportSnapshotRequest> {
    override suspend fun serialize(context: ExecutionContext, input: ImportSnapshotRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeImportSnapshotOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        builder.headers.setMissing("Content-Type", "application/x-www-form-urlencoded")
        return builder
    }
}

private fun serializeImportSnapshotOperationBody(context: ExecutionContext, input: ImportSnapshotRequest): ByteArray {
    val serializer = FormUrlSerializer()
    val CLIENTDATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, FormUrlSerialName("ClientData"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("ClientToken"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("Description"))
    val DISKCONTAINER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, FormUrlSerialName("DiskContainer"))
    val DRYRUN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("DryRun"))
    val ENCRYPTED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("Encrypted"))
    val KMSKEYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("KmsKeyId"))
    val ROLENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("RoleName"))
    val TAGSPECIFICATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("TagSpecification"), FormUrlFlattened)
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(FormUrlSerialName("ImportSnapshotRequest"))
        trait(QueryLiteral("Action", "ImportSnapshot"))
        trait(QueryLiteral("Version", "2016-11-15"))
        field(CLIENTDATA_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(DISKCONTAINER_DESCRIPTOR)
        field(DRYRUN_DESCRIPTOR)
        field(ENCRYPTED_DESCRIPTOR)
        field(KMSKEYID_DESCRIPTOR)
        field(ROLENAME_DESCRIPTOR)
        field(TAGSPECIFICATIONS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientData?.let { field(CLIENTDATA_DESCRIPTOR, it, ::serializeClientDataDocument) }
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.diskContainer?.let { field(DISKCONTAINER_DESCRIPTOR, it, ::serializeSnapshotDiskContainerDocument) }
        input.dryRun?.let { field(DRYRUN_DESCRIPTOR, it) }
        input.encrypted?.let { field(ENCRYPTED_DESCRIPTOR, it) }
        input.kmsKeyId?.let { field(KMSKEYID_DESCRIPTOR, it) }
        input.roleName?.let { field(ROLENAME_DESCRIPTOR, it) }
        if (input.tagSpecifications != null) {
            listField(TAGSPECIFICATIONS_DESCRIPTOR) {
                for (el0 in input.tagSpecifications) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagSpecificationDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
