// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseEc2QueryErrorResponse
import aws.sdk.kotlin.services.ec2.model.Ec2Exception
import aws.sdk.kotlin.services.ec2.model.GroupIdentifier
import aws.sdk.kotlin.services.ec2.model.Instance
import aws.sdk.kotlin.services.ec2.model.RunInstancesResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlCollectionName
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class RunInstancesOperationDeserializer: HttpDeserialize<RunInstancesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): RunInstancesResponse {
        if (!response.status.isSuccess()) {
            throwRunInstancesError(context, response)
        }
        val builder = RunInstancesResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeRunInstancesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeRunInstancesOperationBody(builder: RunInstancesResponse.DslBuilder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    val GROUPS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("groupSet"), XmlCollectionName("item"))
    val INSTANCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("instancesSet"), XmlCollectionName("item"))
    val OWNERID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("ownerId"))
    val REQUESTERID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("requesterId"))
    val RESERVATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("reservationId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://ec2.amazonaws.com/doc/2016-11-15"))
        trait(XmlSerialName("RunInstancesResult"))
        field(GROUPS_DESCRIPTOR)
        field(INSTANCES_DESCRIPTOR)
        field(OWNERID_DESCRIPTOR)
        field(REQUESTERID_DESCRIPTOR)
        field(RESERVATIONID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                GROUPS_DESCRIPTOR.index -> builder.groups =
                    deserializer.deserializeList(GROUPS_DESCRIPTOR) {
                        val col0 = mutableListOf<GroupIdentifier>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeGroupIdentifierDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                INSTANCES_DESCRIPTOR.index -> builder.instances =
                    deserializer.deserializeList(INSTANCES_DESCRIPTOR) {
                        val col0 = mutableListOf<Instance>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeInstanceDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                OWNERID_DESCRIPTOR.index -> builder.ownerId = deserializeString()
                REQUESTERID_DESCRIPTOR.index -> builder.requesterId = deserializeString()
                RESERVATIONID_DESCRIPTOR.index -> builder.reservationId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwRunInstancesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseEc2QueryErrorResponse(payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as ec2Query error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    throw Ec2Exception(errorDetails.message)
}
