// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.transform

import aws.sdk.kotlin.services.ec2.model.RunInstancesRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlFlattened
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerialName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializer
import aws.smithy.kotlin.runtime.serde.formurl.QueryLiteral
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class RunInstancesOperationSerializer: HttpSerialize<RunInstancesRequest> {
    override suspend fun serialize(context: ExecutionContext, input: RunInstancesRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeRunInstancesOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        builder.headers.setMissing("Content-Type", "application/x-www-form-urlencoded")
        return builder
    }
}

private fun serializeRunInstancesOperationBody(context: ExecutionContext, input: RunInstancesRequest): ByteArray {
    val serializer = FormUrlSerializer()
    val ADDITIONALINFO_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("AdditionalInfo"))
    val BLOCKDEVICEMAPPINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("BlockDeviceMapping"), FormUrlFlattened)
    val CAPACITYRESERVATIONSPECIFICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, FormUrlSerialName("CapacityReservationSpecification"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("ClientToken"))
    val CPUOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, FormUrlSerialName("CpuOptions"))
    val CREDITSPECIFICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, FormUrlSerialName("CreditSpecification"))
    val DISABLEAPITERMINATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("DisableApiTermination"))
    val DRYRUN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("DryRun"))
    val EBSOPTIMIZED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("EbsOptimized"))
    val ELASTICGPUSPECIFICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("ElasticGpuSpecification"), FormUrlFlattened)
    val ELASTICINFERENCEACCELERATORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("ElasticInferenceAccelerator"), FormUrlFlattened)
    val ENCLAVEOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, FormUrlSerialName("EnclaveOptions"))
    val HIBERNATIONOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, FormUrlSerialName("HibernationOptions"))
    val IAMINSTANCEPROFILE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, FormUrlSerialName("IamInstanceProfile"))
    val IMAGEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("ImageId"))
    val INSTANCEINITIATEDSHUTDOWNBEHAVIOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("InstanceInitiatedShutdownBehavior"))
    val INSTANCEMARKETOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, FormUrlSerialName("InstanceMarketOptions"))
    val INSTANCETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("InstanceType"))
    val IPV6ADDRESSCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("Ipv6AddressCount"))
    val IPV6ADDRESSES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("Ipv6Address"), FormUrlFlattened)
    val KERNELID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("KernelId"))
    val KEYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("KeyName"))
    val LAUNCHTEMPLATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, FormUrlSerialName("LaunchTemplate"))
    val LICENSESPECIFICATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("LicenseSpecification"), FormUrlFlattened)
    val MAXCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("MaxCount"))
    val METADATAOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, FormUrlSerialName("MetadataOptions"))
    val MINCOUNT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("MinCount"))
    val MONITORING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, FormUrlSerialName("Monitoring"))
    val NETWORKINTERFACES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("NetworkInterface"), FormUrlFlattened)
    val PLACEMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, FormUrlSerialName("Placement"))
    val PRIVATEIPADDRESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("PrivateIpAddress"))
    val RAMDISKID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("RamdiskId"))
    val SECURITYGROUPIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("SecurityGroupId"), FormUrlFlattened)
    val SECURITYGROUPS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("SecurityGroup"), FormUrlFlattened)
    val SUBNETID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("SubnetId"))
    val TAGSPECIFICATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("TagSpecification"), FormUrlFlattened)
    val USERDATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("UserData"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(FormUrlSerialName("RunInstancesRequest"))
        trait(QueryLiteral("Action", "RunInstances"))
        trait(QueryLiteral("Version", "2016-11-15"))
        field(ADDITIONALINFO_DESCRIPTOR)
        field(BLOCKDEVICEMAPPINGS_DESCRIPTOR)
        field(CAPACITYRESERVATIONSPECIFICATION_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
        field(CPUOPTIONS_DESCRIPTOR)
        field(CREDITSPECIFICATION_DESCRIPTOR)
        field(DISABLEAPITERMINATION_DESCRIPTOR)
        field(DRYRUN_DESCRIPTOR)
        field(EBSOPTIMIZED_DESCRIPTOR)
        field(ELASTICGPUSPECIFICATION_DESCRIPTOR)
        field(ELASTICINFERENCEACCELERATORS_DESCRIPTOR)
        field(ENCLAVEOPTIONS_DESCRIPTOR)
        field(HIBERNATIONOPTIONS_DESCRIPTOR)
        field(IAMINSTANCEPROFILE_DESCRIPTOR)
        field(IMAGEID_DESCRIPTOR)
        field(INSTANCEINITIATEDSHUTDOWNBEHAVIOR_DESCRIPTOR)
        field(INSTANCEMARKETOPTIONS_DESCRIPTOR)
        field(INSTANCETYPE_DESCRIPTOR)
        field(IPV6ADDRESSCOUNT_DESCRIPTOR)
        field(IPV6ADDRESSES_DESCRIPTOR)
        field(KERNELID_DESCRIPTOR)
        field(KEYNAME_DESCRIPTOR)
        field(LAUNCHTEMPLATE_DESCRIPTOR)
        field(LICENSESPECIFICATIONS_DESCRIPTOR)
        field(MAXCOUNT_DESCRIPTOR)
        field(METADATAOPTIONS_DESCRIPTOR)
        field(MINCOUNT_DESCRIPTOR)
        field(MONITORING_DESCRIPTOR)
        field(NETWORKINTERFACES_DESCRIPTOR)
        field(PLACEMENT_DESCRIPTOR)
        field(PRIVATEIPADDRESS_DESCRIPTOR)
        field(RAMDISKID_DESCRIPTOR)
        field(SECURITYGROUPIDS_DESCRIPTOR)
        field(SECURITYGROUPS_DESCRIPTOR)
        field(SUBNETID_DESCRIPTOR)
        field(TAGSPECIFICATIONS_DESCRIPTOR)
        field(USERDATA_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.additionalInfo?.let { field(ADDITIONALINFO_DESCRIPTOR, it) }
        if (input.blockDeviceMappings != null) {
            listField(BLOCKDEVICEMAPPINGS_DESCRIPTOR) {
                for (el0 in input.blockDeviceMappings) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeBlockDeviceMappingDocument))
                }
            }
        }
        input.capacityReservationSpecification?.let { field(CAPACITYRESERVATIONSPECIFICATION_DESCRIPTOR, it, ::serializeCapacityReservationSpecificationDocument) }
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.cpuOptions?.let { field(CPUOPTIONS_DESCRIPTOR, it, ::serializeCpuOptionsRequestDocument) }
        input.creditSpecification?.let { field(CREDITSPECIFICATION_DESCRIPTOR, it, ::serializeCreditSpecificationRequestDocument) }
        input.disableApiTermination?.let { field(DISABLEAPITERMINATION_DESCRIPTOR, it) }
        input.dryRun?.let { field(DRYRUN_DESCRIPTOR, it) }
        input.ebsOptimized?.let { field(EBSOPTIMIZED_DESCRIPTOR, it) }
        if (input.elasticGpuSpecification != null) {
            listField(ELASTICGPUSPECIFICATION_DESCRIPTOR) {
                for (el0 in input.elasticGpuSpecification) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeElasticGpuSpecificationDocument))
                }
            }
        }
        if (input.elasticInferenceAccelerators != null) {
            listField(ELASTICINFERENCEACCELERATORS_DESCRIPTOR) {
                for (el0 in input.elasticInferenceAccelerators) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeElasticInferenceAcceleratorDocument))
                }
            }
        }
        input.enclaveOptions?.let { field(ENCLAVEOPTIONS_DESCRIPTOR, it, ::serializeEnclaveOptionsRequestDocument) }
        input.hibernationOptions?.let { field(HIBERNATIONOPTIONS_DESCRIPTOR, it, ::serializeHibernationOptionsRequestDocument) }
        input.iamInstanceProfile?.let { field(IAMINSTANCEPROFILE_DESCRIPTOR, it, ::serializeIamInstanceProfileSpecificationDocument) }
        input.imageId?.let { field(IMAGEID_DESCRIPTOR, it) }
        input.instanceInitiatedShutdownBehavior?.let { field(INSTANCEINITIATEDSHUTDOWNBEHAVIOR_DESCRIPTOR, it.value) }
        input.instanceMarketOptions?.let { field(INSTANCEMARKETOPTIONS_DESCRIPTOR, it, ::serializeInstanceMarketOptionsRequestDocument) }
        input.instanceType?.let { field(INSTANCETYPE_DESCRIPTOR, it.value) }
        input.ipv6AddressCount?.let { field(IPV6ADDRESSCOUNT_DESCRIPTOR, it) }
        if (input.ipv6Addresses != null) {
            listField(IPV6ADDRESSES_DESCRIPTOR) {
                for (el0 in input.ipv6Addresses) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeInstanceIpv6AddressDocument))
                }
            }
        }
        input.kernelId?.let { field(KERNELID_DESCRIPTOR, it) }
        input.keyName?.let { field(KEYNAME_DESCRIPTOR, it) }
        input.launchTemplate?.let { field(LAUNCHTEMPLATE_DESCRIPTOR, it, ::serializeLaunchTemplateSpecificationDocument) }
        if (input.licenseSpecifications != null) {
            listField(LICENSESPECIFICATIONS_DESCRIPTOR) {
                for (el0 in input.licenseSpecifications) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeLicenseConfigurationRequestDocument))
                }
            }
        }
        input.maxCount?.let { field(MAXCOUNT_DESCRIPTOR, it) }
        input.metadataOptions?.let { field(METADATAOPTIONS_DESCRIPTOR, it, ::serializeInstanceMetadataOptionsRequestDocument) }
        input.minCount?.let { field(MINCOUNT_DESCRIPTOR, it) }
        input.monitoring?.let { field(MONITORING_DESCRIPTOR, it, ::serializeRunInstancesMonitoringEnabledDocument) }
        if (input.networkInterfaces != null) {
            listField(NETWORKINTERFACES_DESCRIPTOR) {
                for (el0 in input.networkInterfaces) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeInstanceNetworkInterfaceSpecificationDocument))
                }
            }
        }
        input.placement?.let { field(PLACEMENT_DESCRIPTOR, it, ::serializePlacementDocument) }
        input.privateIpAddress?.let { field(PRIVATEIPADDRESS_DESCRIPTOR, it) }
        input.ramdiskId?.let { field(RAMDISKID_DESCRIPTOR, it) }
        if (input.securityGroupIds != null) {
            listField(SECURITYGROUPIDS_DESCRIPTOR) {
                for (el0 in input.securityGroupIds) {
                    serializeString(el0)
                }
            }
        }
        if (input.securityGroups != null) {
            listField(SECURITYGROUPS_DESCRIPTOR) {
                for (el0 in input.securityGroups) {
                    serializeString(el0)
                }
            }
        }
        input.subnetId?.let { field(SUBNETID_DESCRIPTOR, it) }
        if (input.tagSpecifications != null) {
            listField(TAGSPECIFICATIONS_DESCRIPTOR) {
                for (el0 in input.tagSpecifications) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagSpecificationDocument))
                }
            }
        }
        input.userData?.let { field(USERDATA_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
