// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2instanceconnect.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.ec2instanceconnect.model.Ec2InstanceConnectException
import aws.sdk.kotlin.services.ec2instanceconnect.model.SendSshPublicKeyResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class SendSSHPublicKeyOperationDeserializer: HttpDeserialize<SendSshPublicKeyResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): SendSshPublicKeyResponse {
        if (!response.status.isSuccess()) {
            throwSendSshPublicKeyError(context, response)
        }
        val builder = SendSshPublicKeyResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeSendSSHPublicKeyOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwSendSshPublicKeyError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw Ec2InstanceConnectException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AuthException" -> AuthExceptionDeserializer().deserialize(context, wrappedResponse)
        "EC2InstanceNotFoundException" -> Ec2InstanceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "EC2InstanceStateInvalidException" -> Ec2InstanceStateInvalidExceptionDeserializer().deserialize(context, wrappedResponse)
        "EC2InstanceUnavailableException" -> Ec2InstanceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidArgsException" -> InvalidArgsExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceException" -> ServiceExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> Ec2InstanceConnectException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeSendSSHPublicKeyOperationBody(builder: SendSshPublicKeyResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val REQUESTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RequestId"))
    val SUCCESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("Success"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(REQUESTID_DESCRIPTOR)
        field(SUCCESS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                REQUESTID_DESCRIPTOR.index -> builder.requestId = deserializeString()
                SUCCESS_DESCRIPTOR.index -> builder.success = deserializeBoolean()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
