// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.efs.model



/**
 * Provides a description of an EFS file system access point.
 */
class CreateAccessPointResponse private constructor(builder: Builder) {
    /**
     * The unique Amazon Resource Name (ARN) associated with the access point.
     */
    val accessPointArn: kotlin.String? = builder.accessPointArn
    /**
     * The ID of the access point, assigned by Amazon EFS.
     */
    val accessPointId: kotlin.String? = builder.accessPointId
    /**
     * The opaque string specified in the request to ensure idempotent creation.
     */
    val clientToken: kotlin.String? = builder.clientToken
    /**
     * The ID of the EFS file system that the access point applies to.
     */
    val fileSystemId: kotlin.String? = builder.fileSystemId
    /**
     * Identifies the lifecycle phase of the access point.
     */
    val lifeCycleState: aws.sdk.kotlin.services.efs.model.LifeCycleState? = builder.lifeCycleState
    /**
     * The name of the access point. This is the value of the `Name` tag.
     */
    val name: kotlin.String? = builder.name
    /**
     * Identified the Amazon Web Services account that owns the access point resource.
     */
    val ownerId: kotlin.String? = builder.ownerId
    /**
     * The full POSIX identity, including the user ID, group ID, and secondary group IDs on the access point that is used for all file operations by NFS clients using the access point.
     */
    val posixUser: aws.sdk.kotlin.services.efs.model.PosixUser? = builder.posixUser
    /**
     * The directory on the Amazon EFS file system that the access point exposes as the root directory to NFS clients using the access point.
     */
    val rootDirectory: aws.sdk.kotlin.services.efs.model.RootDirectory? = builder.rootDirectory
    /**
     * The tags associated with the access point, presented as an array of Tag objects.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.efs.model.CreateAccessPointResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAccessPointResponse(")
        append("accessPointArn=$accessPointArn,")
        append("accessPointId=$accessPointId,")
        append("clientToken=$clientToken,")
        append("fileSystemId=$fileSystemId,")
        append("lifeCycleState=$lifeCycleState,")
        append("name=$name,")
        append("ownerId=$ownerId,")
        append("posixUser=$posixUser,")
        append("rootDirectory=$rootDirectory,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessPointArn?.hashCode() ?: 0
        result = 31 * result + (accessPointId?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (fileSystemId?.hashCode() ?: 0)
        result = 31 * result + (lifeCycleState?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (posixUser?.hashCode() ?: 0)
        result = 31 * result + (rootDirectory?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateAccessPointResponse

        if (accessPointArn != other.accessPointArn) return false
        if (accessPointId != other.accessPointId) return false
        if (clientToken != other.clientToken) return false
        if (fileSystemId != other.fileSystemId) return false
        if (lifeCycleState != other.lifeCycleState) return false
        if (name != other.name) return false
        if (ownerId != other.ownerId) return false
        if (posixUser != other.posixUser) return false
        if (rootDirectory != other.rootDirectory) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.efs.model.CreateAccessPointResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The unique Amazon Resource Name (ARN) associated with the access point.
         */
        var accessPointArn: kotlin.String? = null
        /**
         * The ID of the access point, assigned by Amazon EFS.
         */
        var accessPointId: kotlin.String? = null
        /**
         * The opaque string specified in the request to ensure idempotent creation.
         */
        var clientToken: kotlin.String? = null
        /**
         * The ID of the EFS file system that the access point applies to.
         */
        var fileSystemId: kotlin.String? = null
        /**
         * Identifies the lifecycle phase of the access point.
         */
        var lifeCycleState: aws.sdk.kotlin.services.efs.model.LifeCycleState? = null
        /**
         * The name of the access point. This is the value of the `Name` tag.
         */
        var name: kotlin.String? = null
        /**
         * Identified the Amazon Web Services account that owns the access point resource.
         */
        var ownerId: kotlin.String? = null
        /**
         * The full POSIX identity, including the user ID, group ID, and secondary group IDs on the access point that is used for all file operations by NFS clients using the access point.
         */
        var posixUser: aws.sdk.kotlin.services.efs.model.PosixUser? = null
        /**
         * The directory on the Amazon EFS file system that the access point exposes as the root directory to NFS clients using the access point.
         */
        var rootDirectory: aws.sdk.kotlin.services.efs.model.RootDirectory? = null
        /**
         * The tags associated with the access point, presented as an array of Tag objects.
         */
        var tags: List<Tag>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.efs.model.CreateAccessPointResponse) : this() {
            this.accessPointArn = x.accessPointArn
            this.accessPointId = x.accessPointId
            this.clientToken = x.clientToken
            this.fileSystemId = x.fileSystemId
            this.lifeCycleState = x.lifeCycleState
            this.name = x.name
            this.ownerId = x.ownerId
            this.posixUser = x.posixUser
            this.rootDirectory = x.rootDirectory
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.efs.model.CreateAccessPointResponse = CreateAccessPointResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.efs.model.PosixUser] inside the given [block]
         */
        fun posixUser(block: aws.sdk.kotlin.services.efs.model.PosixUser.Builder.() -> kotlin.Unit) {
            this.posixUser = aws.sdk.kotlin.services.efs.model.PosixUser.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.efs.model.RootDirectory] inside the given [block]
         */
        fun rootDirectory(block: aws.sdk.kotlin.services.efs.model.RootDirectory.Builder.() -> kotlin.Unit) {
            this.rootDirectory = aws.sdk.kotlin.services.efs.model.RootDirectory.invoke(block)
        }
    }
}
