// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.efs.model



class CreateFileSystemRequest private constructor(builder: Builder) {
    /**
     * Used to create a file system that uses One Zone storage classes. It specifies the Amazon Web Services Availability Zone in which to create the file system. Use the format `us-east-1a` to specify the Availability Zone. For more information about One Zone storage classes, see [Using EFS storage classes](https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html) in the *Amazon EFS User Guide*.
     *
     * One Zone storage classes are not available in all Availability Zones in Amazon Web Services Regions where Amazon EFS is available.
     */
    val availabilityZoneName: kotlin.String? = builder.availabilityZoneName
    /**
     * Specifies whether automatic backups are enabled on the file system that you are creating. Set the value to `true` to enable automatic backups. If you are creating a file system that uses One Zone storage classes, automatic backups are enabled by default. For more information, see [Automatic backups](https://docs.aws.amazon.com/efs/latest/ug/awsbackup.html#automatic-backups) in the *Amazon EFS User Guide*.
     *
     * Default is `false`. However, if you specify an `AvailabilityZoneName`, the default is `true`.
     *
     * Backup is not available in all Amazon Web Services Regions where Amazon EFS is available.
     */
    val backup: kotlin.Boolean? = builder.backup
    /**
     * A string of up to 64 ASCII characters. Amazon EFS uses this to ensure idempotent creation.
     */
    val creationToken: kotlin.String? = builder.creationToken
    /**
     * A Boolean value that, if true, creates an encrypted file system. When creating an encrypted file system, you have the option of specifying an existing Key Management Service key (KMS key). If you don't specify a KMS key, then the default KMS key for Amazon EFS, `/aws/elasticfilesystem`, is used to protect the encrypted file system.
     */
    val encrypted: kotlin.Boolean? = builder.encrypted
    /**
     * The ID of the KMS key that you want to use to protect the encrypted file system. This parameter is required only if you want to use a non-default KMS key. If this parameter is not specified, the default KMS key for Amazon EFS is used. You can specify a KMS key ID using the following formats:
     * + Key ID - A unique identifier of the key, for example `1234abcd-12ab-34cd-56ef-1234567890ab`.
     * + ARN - An Amazon Resource Name (ARN) for the key, for example `arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`.
     * + Key alias - A previously created display name for a key, for example `alias/projectKey1`.
     * + Key alias ARN - An ARN for a key alias, for example `arn:aws:kms:us-west-2:444455556666:alias/projectKey1`.
     *
     * If you use `KmsKeyId`, you must set the CreateFileSystemRequest$Encrypted parameter to true.
     *
     * EFS accepts only symmetric KMS keys. You cannot use asymmetric KMS keys with Amazon EFS file systems.
     */
    val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The performance mode of the file system. We recommend `generalPurpose` performance mode for most file systems. File systems using the `maxIO` performance mode can scale to higher levels of aggregate throughput and operations per second with a tradeoff of slightly higher latencies for most file operations. The performance mode can't be changed after the file system has been created.
     *
     * The `maxIO` mode is not supported on file systems using One Zone storage classes.
     */
    val performanceMode: aws.sdk.kotlin.services.efs.model.PerformanceMode? = builder.performanceMode
    /**
     * The throughput, measured in MiB/s, that you want to provision for a file system that you're creating. Valid values are 1-1024. Required if `ThroughputMode` is set to `provisioned`. The upper limit for throughput is 1024 MiB/s. To increase this limit, contact Amazon Web Services Support. For more information, see [Amazon EFS quotas that you can increase](https://docs.aws.amazon.com/efs/latest/ug/limits.html#soft-limits) in the *Amazon EFS User Guide*.
     */
    val provisionedThroughputInMibps: kotlin.Double? = builder.provisionedThroughputInMibps
    /**
     * Use to create one or more tags associated with the file system. Each tag is a user-defined key-value pair. Name your file system on creation by including a `"Key":"Name","Value":"{value}"` key-value pair. Each key must be unique. For more information, see [Tagging Amazon Web Services resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *Amazon Web Services General Reference Guide*.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * Specifies the throughput mode for the file system, either `bursting` or `provisioned`. If you set `ThroughputMode` to `provisioned`, you must also set a value for `ProvisionedThroughputInMibps`. After you create the file system, you can decrease your file system's throughput in Provisioned Throughput mode or change between the throughput modes, as long as it’s been more than 24 hours since the last decrease or throughput mode change. For more information, see [Specifying throughput with provisioned mode](https://docs.aws.amazon.com/efs/latest/ug/performance.html#provisioned-throughput) in the *Amazon EFS User Guide*.
     *
     * Default is `bursting`.
     */
    val throughputMode: aws.sdk.kotlin.services.efs.model.ThroughputMode? = builder.throughputMode

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.efs.model.CreateFileSystemRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateFileSystemRequest(")
        append("availabilityZoneName=$availabilityZoneName,")
        append("backup=$backup,")
        append("creationToken=$creationToken,")
        append("encrypted=$encrypted,")
        append("kmsKeyId=$kmsKeyId,")
        append("performanceMode=$performanceMode,")
        append("provisionedThroughputInMibps=$provisionedThroughputInMibps,")
        append("tags=$tags,")
        append("throughputMode=$throughputMode)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZoneName?.hashCode() ?: 0
        result = 31 * result + (backup?.hashCode() ?: 0)
        result = 31 * result + (creationToken?.hashCode() ?: 0)
        result = 31 * result + (encrypted?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (performanceMode?.hashCode() ?: 0)
        result = 31 * result + (provisionedThroughputInMibps?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (throughputMode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateFileSystemRequest

        if (availabilityZoneName != other.availabilityZoneName) return false
        if (backup != other.backup) return false
        if (creationToken != other.creationToken) return false
        if (encrypted != other.encrypted) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (performanceMode != other.performanceMode) return false
        if (provisionedThroughputInMibps != other.provisionedThroughputInMibps) return false
        if (tags != other.tags) return false
        if (throughputMode != other.throughputMode) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.efs.model.CreateFileSystemRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Used to create a file system that uses One Zone storage classes. It specifies the Amazon Web Services Availability Zone in which to create the file system. Use the format `us-east-1a` to specify the Availability Zone. For more information about One Zone storage classes, see [Using EFS storage classes](https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html) in the *Amazon EFS User Guide*.
         *
         * One Zone storage classes are not available in all Availability Zones in Amazon Web Services Regions where Amazon EFS is available.
         */
        var availabilityZoneName: kotlin.String? = null
        /**
         * Specifies whether automatic backups are enabled on the file system that you are creating. Set the value to `true` to enable automatic backups. If you are creating a file system that uses One Zone storage classes, automatic backups are enabled by default. For more information, see [Automatic backups](https://docs.aws.amazon.com/efs/latest/ug/awsbackup.html#automatic-backups) in the *Amazon EFS User Guide*.
         *
         * Default is `false`. However, if you specify an `AvailabilityZoneName`, the default is `true`.
         *
         * Backup is not available in all Amazon Web Services Regions where Amazon EFS is available.
         */
        var backup: kotlin.Boolean? = null
        /**
         * A string of up to 64 ASCII characters. Amazon EFS uses this to ensure idempotent creation.
         */
        var creationToken: kotlin.String? = null
        /**
         * A Boolean value that, if true, creates an encrypted file system. When creating an encrypted file system, you have the option of specifying an existing Key Management Service key (KMS key). If you don't specify a KMS key, then the default KMS key for Amazon EFS, `/aws/elasticfilesystem`, is used to protect the encrypted file system.
         */
        var encrypted: kotlin.Boolean? = null
        /**
         * The ID of the KMS key that you want to use to protect the encrypted file system. This parameter is required only if you want to use a non-default KMS key. If this parameter is not specified, the default KMS key for Amazon EFS is used. You can specify a KMS key ID using the following formats:
         * + Key ID - A unique identifier of the key, for example `1234abcd-12ab-34cd-56ef-1234567890ab`.
         * + ARN - An Amazon Resource Name (ARN) for the key, for example `arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`.
         * + Key alias - A previously created display name for a key, for example `alias/projectKey1`.
         * + Key alias ARN - An ARN for a key alias, for example `arn:aws:kms:us-west-2:444455556666:alias/projectKey1`.
         *
         * If you use `KmsKeyId`, you must set the CreateFileSystemRequest$Encrypted parameter to true.
         *
         * EFS accepts only symmetric KMS keys. You cannot use asymmetric KMS keys with Amazon EFS file systems.
         */
        var kmsKeyId: kotlin.String? = null
        /**
         * The performance mode of the file system. We recommend `generalPurpose` performance mode for most file systems. File systems using the `maxIO` performance mode can scale to higher levels of aggregate throughput and operations per second with a tradeoff of slightly higher latencies for most file operations. The performance mode can't be changed after the file system has been created.
         *
         * The `maxIO` mode is not supported on file systems using One Zone storage classes.
         */
        var performanceMode: aws.sdk.kotlin.services.efs.model.PerformanceMode? = null
        /**
         * The throughput, measured in MiB/s, that you want to provision for a file system that you're creating. Valid values are 1-1024. Required if `ThroughputMode` is set to `provisioned`. The upper limit for throughput is 1024 MiB/s. To increase this limit, contact Amazon Web Services Support. For more information, see [Amazon EFS quotas that you can increase](https://docs.aws.amazon.com/efs/latest/ug/limits.html#soft-limits) in the *Amazon EFS User Guide*.
         */
        var provisionedThroughputInMibps: kotlin.Double? = null
        /**
         * Use to create one or more tags associated with the file system. Each tag is a user-defined key-value pair. Name your file system on creation by including a `"Key":"Name","Value":"{value}"` key-value pair. Each key must be unique. For more information, see [Tagging Amazon Web Services resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the *Amazon Web Services General Reference Guide*.
         */
        var tags: List<Tag>? = null
        /**
         * Specifies the throughput mode for the file system, either `bursting` or `provisioned`. If you set `ThroughputMode` to `provisioned`, you must also set a value for `ProvisionedThroughputInMibps`. After you create the file system, you can decrease your file system's throughput in Provisioned Throughput mode or change between the throughput modes, as long as it’s been more than 24 hours since the last decrease or throughput mode change. For more information, see [Specifying throughput with provisioned mode](https://docs.aws.amazon.com/efs/latest/ug/performance.html#provisioned-throughput) in the *Amazon EFS User Guide*.
         *
         * Default is `bursting`.
         */
        var throughputMode: aws.sdk.kotlin.services.efs.model.ThroughputMode? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.efs.model.CreateFileSystemRequest) : this() {
            this.availabilityZoneName = x.availabilityZoneName
            this.backup = x.backup
            this.creationToken = x.creationToken
            this.encrypted = x.encrypted
            this.kmsKeyId = x.kmsKeyId
            this.performanceMode = x.performanceMode
            this.provisionedThroughputInMibps = x.provisionedThroughputInMibps
            this.tags = x.tags
            this.throughputMode = x.throughputMode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.efs.model.CreateFileSystemRequest = CreateFileSystemRequest(this)
    }
}
