// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.efs.model



/**
 * Provides a description of a mount target.
 */
class CreateMountTargetResponse private constructor(builder: Builder) {
    /**
     * The unique and consistent identifier of the Availability Zone that the mount target resides in. For example, `use1-az1` is an AZ ID for the us-east-1 Region and it has the same location in every Amazon Web Services account.
     */
    val availabilityZoneId: kotlin.String? = builder.availabilityZoneId
    /**
     * The name of the Availability Zone in which the mount target is located. Availability Zones are independently mapped to names for each Amazon Web Services account. For example, the Availability Zone `us-east-1a` for your Amazon Web Services account might not be the same location as `us-east-1a` for another Amazon Web Services account.
     */
    val availabilityZoneName: kotlin.String? = builder.availabilityZoneName
    /**
     * The ID of the file system for which the mount target is intended.
     */
    val fileSystemId: kotlin.String? = builder.fileSystemId
    /**
     * Address at which the file system can be mounted by using the mount target.
     */
    val ipAddress: kotlin.String? = builder.ipAddress
    /**
     * Lifecycle state of the mount target.
     */
    val lifeCycleState: aws.sdk.kotlin.services.efs.model.LifeCycleState? = builder.lifeCycleState
    /**
     * System-assigned mount target ID.
     */
    val mountTargetId: kotlin.String? = builder.mountTargetId
    /**
     * The ID of the network interface that Amazon EFS created when it created the mount target.
     */
    val networkInterfaceId: kotlin.String? = builder.networkInterfaceId
    /**
     * Amazon Web Services account ID that owns the resource.
     */
    val ownerId: kotlin.String? = builder.ownerId
    /**
     * The ID of the mount target's subnet.
     */
    val subnetId: kotlin.String? = builder.subnetId
    /**
     * The virtual private cloud (VPC) ID that the mount target is configured in.
     */
    val vpcId: kotlin.String? = builder.vpcId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.efs.model.CreateMountTargetResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateMountTargetResponse(")
        append("availabilityZoneId=$availabilityZoneId,")
        append("availabilityZoneName=$availabilityZoneName,")
        append("fileSystemId=$fileSystemId,")
        append("ipAddress=$ipAddress,")
        append("lifeCycleState=$lifeCycleState,")
        append("mountTargetId=$mountTargetId,")
        append("networkInterfaceId=$networkInterfaceId,")
        append("ownerId=$ownerId,")
        append("subnetId=$subnetId,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZoneId?.hashCode() ?: 0
        result = 31 * result + (availabilityZoneName?.hashCode() ?: 0)
        result = 31 * result + (fileSystemId?.hashCode() ?: 0)
        result = 31 * result + (ipAddress?.hashCode() ?: 0)
        result = 31 * result + (lifeCycleState?.hashCode() ?: 0)
        result = 31 * result + (mountTargetId?.hashCode() ?: 0)
        result = 31 * result + (networkInterfaceId?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateMountTargetResponse

        if (availabilityZoneId != other.availabilityZoneId) return false
        if (availabilityZoneName != other.availabilityZoneName) return false
        if (fileSystemId != other.fileSystemId) return false
        if (ipAddress != other.ipAddress) return false
        if (lifeCycleState != other.lifeCycleState) return false
        if (mountTargetId != other.mountTargetId) return false
        if (networkInterfaceId != other.networkInterfaceId) return false
        if (ownerId != other.ownerId) return false
        if (subnetId != other.subnetId) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.efs.model.CreateMountTargetResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The unique and consistent identifier of the Availability Zone that the mount target resides in. For example, `use1-az1` is an AZ ID for the us-east-1 Region and it has the same location in every Amazon Web Services account.
         */
        var availabilityZoneId: kotlin.String? = null
        /**
         * The name of the Availability Zone in which the mount target is located. Availability Zones are independently mapped to names for each Amazon Web Services account. For example, the Availability Zone `us-east-1a` for your Amazon Web Services account might not be the same location as `us-east-1a` for another Amazon Web Services account.
         */
        var availabilityZoneName: kotlin.String? = null
        /**
         * The ID of the file system for which the mount target is intended.
         */
        var fileSystemId: kotlin.String? = null
        /**
         * Address at which the file system can be mounted by using the mount target.
         */
        var ipAddress: kotlin.String? = null
        /**
         * Lifecycle state of the mount target.
         */
        var lifeCycleState: aws.sdk.kotlin.services.efs.model.LifeCycleState? = null
        /**
         * System-assigned mount target ID.
         */
        var mountTargetId: kotlin.String? = null
        /**
         * The ID of the network interface that Amazon EFS created when it created the mount target.
         */
        var networkInterfaceId: kotlin.String? = null
        /**
         * Amazon Web Services account ID that owns the resource.
         */
        var ownerId: kotlin.String? = null
        /**
         * The ID of the mount target's subnet.
         */
        var subnetId: kotlin.String? = null
        /**
         * The virtual private cloud (VPC) ID that the mount target is configured in.
         */
        var vpcId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.efs.model.CreateMountTargetResponse) : this() {
            this.availabilityZoneId = x.availabilityZoneId
            this.availabilityZoneName = x.availabilityZoneName
            this.fileSystemId = x.fileSystemId
            this.ipAddress = x.ipAddress
            this.lifeCycleState = x.lifeCycleState
            this.mountTargetId = x.mountTargetId
            this.networkInterfaceId = x.networkInterfaceId
            this.ownerId = x.ownerId
            this.subnetId = x.subnetId
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.efs.model.CreateMountTargetResponse = CreateMountTargetResponse(this)
    }
}
