// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.efs.model



/**
 * Describes the destination file system to create in the replication configuration.
 */
class DestinationToCreate private constructor(builder: Builder) {
    /**
     * To create a file system that uses EFS One Zone storage, specify the name of the Availability Zone in which to create the destination file system.
     */
    val availabilityZoneName: kotlin.String? = builder.availabilityZoneName
    /**
     * Specifies the Key Management Service (KMS) key that you want to use to encrypt the destination file system. If you do not specify a KMS key, Amazon EFS uses your default KMS key for Amazon EFS, `/aws/elasticfilesystem`. This ID can be in one of the following formats:
     * + Key ID - The unique identifier of the key, for example `1234abcd-12ab-34cd-56ef-1234567890ab`.
     * + ARN - The Amazon Resource Name (ARN) for the key, for example `arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`.
     * + Key alias - A previously created display name for a key, for example `alias/projectKey1`.
     * + Key alias ARN - The ARN for a key alias, for example `arn:aws:kms:us-west-2:444455556666:alias/projectKey1`.
     */
    val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * To create a file system that uses Regional storage, specify the Amazon Web Services Region in which to create the destination file system.
     */
    val region: kotlin.String? = builder.region

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.efs.model.DestinationToCreate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DestinationToCreate(")
        append("availabilityZoneName=$availabilityZoneName,")
        append("kmsKeyId=$kmsKeyId,")
        append("region=$region)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZoneName?.hashCode() ?: 0
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DestinationToCreate

        if (availabilityZoneName != other.availabilityZoneName) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (region != other.region) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.efs.model.DestinationToCreate = Builder(this).apply(block).build()

    class Builder {
        /**
         * To create a file system that uses EFS One Zone storage, specify the name of the Availability Zone in which to create the destination file system.
         */
        var availabilityZoneName: kotlin.String? = null
        /**
         * Specifies the Key Management Service (KMS) key that you want to use to encrypt the destination file system. If you do not specify a KMS key, Amazon EFS uses your default KMS key for Amazon EFS, `/aws/elasticfilesystem`. This ID can be in one of the following formats:
         * + Key ID - The unique identifier of the key, for example `1234abcd-12ab-34cd-56ef-1234567890ab`.
         * + ARN - The Amazon Resource Name (ARN) for the key, for example `arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`.
         * + Key alias - A previously created display name for a key, for example `alias/projectKey1`.
         * + Key alias ARN - The ARN for a key alias, for example `arn:aws:kms:us-west-2:444455556666:alias/projectKey1`.
         */
        var kmsKeyId: kotlin.String? = null
        /**
         * To create a file system that uses Regional storage, specify the Amazon Web Services Region in which to create the destination file system.
         */
        var region: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.efs.model.DestinationToCreate) : this() {
            this.availabilityZoneName = x.availabilityZoneName
            this.kmsKeyId = x.kmsKeyId
            this.region = x.region
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.efs.model.DestinationToCreate = DestinationToCreate(this)
    }
}
