// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.efs.model



class PutLifecycleConfigurationRequest private constructor(builder: Builder) {
    /**
     * The ID of the file system for which you are creating the `LifecycleConfiguration` object (String).
     */
    val fileSystemId: kotlin.String? = requireNotNull(builder.fileSystemId) { "A non-null value must be provided for fileSystemId" }
    /**
     * An array of `LifecyclePolicy` objects that define the file system's `LifecycleConfiguration` object. A `LifecycleConfiguration` object informs EFS lifecycle management and EFS Intelligent-Tiering of the following:
     * + When to move files in the file system from primary storage to the IA storage class.
     * + When to move files that are in IA storage to primary storage.
     *
     * When using the `put-lifecycle-configuration` CLI command or the `PutLifecycleConfiguration` API action, Amazon EFS requires that each `LifecyclePolicy` object have only a single transition. This means that in a request body, `LifecyclePolicies` must be structured as an array of `LifecyclePolicy` objects, one object for each transition, `TransitionToIA`, `TransitionToPrimaryStorageClass`. See the example requests in the following section for more information.
     */
    val lifecyclePolicies: List<LifecyclePolicy>? = builder.lifecyclePolicies

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.efs.model.PutLifecycleConfigurationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutLifecycleConfigurationRequest(")
        append("fileSystemId=$fileSystemId,")
        append("lifecyclePolicies=$lifecyclePolicies)")
    }

    override fun hashCode(): kotlin.Int {
        var result = fileSystemId?.hashCode() ?: 0
        result = 31 * result + (lifecyclePolicies?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutLifecycleConfigurationRequest

        if (fileSystemId != other.fileSystemId) return false
        if (lifecyclePolicies != other.lifecyclePolicies) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.efs.model.PutLifecycleConfigurationRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ID of the file system for which you are creating the `LifecycleConfiguration` object (String).
         */
        var fileSystemId: kotlin.String? = null
        /**
         * An array of `LifecyclePolicy` objects that define the file system's `LifecycleConfiguration` object. A `LifecycleConfiguration` object informs EFS lifecycle management and EFS Intelligent-Tiering of the following:
         * + When to move files in the file system from primary storage to the IA storage class.
         * + When to move files that are in IA storage to primary storage.
         *
         * When using the `put-lifecycle-configuration` CLI command or the `PutLifecycleConfiguration` API action, Amazon EFS requires that each `LifecyclePolicy` object have only a single transition. This means that in a request body, `LifecyclePolicies` must be structured as an array of `LifecyclePolicy` objects, one object for each transition, `TransitionToIA`, `TransitionToPrimaryStorageClass`. See the example requests in the following section for more information.
         */
        var lifecyclePolicies: List<LifecyclePolicy>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.efs.model.PutLifecycleConfigurationRequest) : this() {
            this.fileSystemId = x.fileSystemId
            this.lifecyclePolicies = x.lifecyclePolicies
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.efs.model.PutLifecycleConfigurationRequest = PutLifecycleConfigurationRequest(this)
    }
}
