// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.efs.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.efs.model.BackupPolicy
import aws.sdk.kotlin.services.efs.model.EfsException
import aws.sdk.kotlin.services.efs.model.PutBackupPolicyResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PutBackupPolicyOperationDeserializer: HttpDeserialize<PutBackupPolicyResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): PutBackupPolicyResponse {
        if (!response.status.isSuccess()) {
            throwPutBackupPolicyError(context, response)
        }
        val builder = PutBackupPolicyResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializePutBackupPolicyOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwPutBackupPolicyError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw EfsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequest" -> BadRequestDeserializer().deserialize(context, wrappedResponse)
        "FileSystemNotFound" -> FileSystemNotFoundDeserializer().deserialize(context, wrappedResponse)
        "IncorrectFileSystemLifeCycleState" -> IncorrectFileSystemLifeCycleStateDeserializer().deserialize(context, wrappedResponse)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> EfsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePutBackupPolicyOperationBody(builder: PutBackupPolicyResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BACKUPPOLICY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("BackupPolicy"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BACKUPPOLICY_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BACKUPPOLICY_DESCRIPTOR.index -> builder.backupPolicy = deserializeBackupPolicyDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
