// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An Amazon EKS add-on. For more information, see [Amazon EKS add-ons](https://docs.aws.amazon.com/eks/latest/userguide/eks-add-ons.html) in the *Amazon EKS User Guide*.
 */
class Addon private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the add-on.
     */
    val addonArn: kotlin.String? = builder.addonArn
    /**
     * The name of the add-on.
     */
    val addonName: kotlin.String? = builder.addonName
    /**
     * The version of the add-on.
     */
    val addonVersion: kotlin.String? = builder.addonVersion
    /**
     * The name of the cluster.
     */
    val clusterName: kotlin.String? = builder.clusterName
    /**
     * The date and time that the add-on was created.
     */
    val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * An object that represents the health of the add-on.
     */
    val health: aws.sdk.kotlin.services.eks.model.AddonHealth? = builder.health
    /**
     * The date and time that the add-on was last modified.
     */
    val modifiedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.modifiedAt
    /**
     * The Amazon Resource Name (ARN) of the IAM role that is bound to the Kubernetes service account used by the add-on.
     */
    val serviceAccountRoleArn: kotlin.String? = builder.serviceAccountRoleArn
    /**
     * The status of the add-on.
     */
    val status: aws.sdk.kotlin.services.eks.model.AddonStatus? = builder.status
    /**
     * The metadata that you apply to the add-on to assist with categorization and organization. Each tag consists of a key and an optional value. You define both. Add-on tags do not propagate to any other resources associated with the cluster.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.Addon = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Addon(")
        append("addonArn=$addonArn,")
        append("addonName=$addonName,")
        append("addonVersion=$addonVersion,")
        append("clusterName=$clusterName,")
        append("createdAt=$createdAt,")
        append("health=$health,")
        append("modifiedAt=$modifiedAt,")
        append("serviceAccountRoleArn=$serviceAccountRoleArn,")
        append("status=$status,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = addonArn?.hashCode() ?: 0
        result = 31 * result + (addonName?.hashCode() ?: 0)
        result = 31 * result + (addonVersion?.hashCode() ?: 0)
        result = 31 * result + (clusterName?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (health?.hashCode() ?: 0)
        result = 31 * result + (modifiedAt?.hashCode() ?: 0)
        result = 31 * result + (serviceAccountRoleArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Addon

        if (addonArn != other.addonArn) return false
        if (addonName != other.addonName) return false
        if (addonVersion != other.addonVersion) return false
        if (clusterName != other.clusterName) return false
        if (createdAt != other.createdAt) return false
        if (health != other.health) return false
        if (modifiedAt != other.modifiedAt) return false
        if (serviceAccountRoleArn != other.serviceAccountRoleArn) return false
        if (status != other.status) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.Addon = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the add-on.
         */
        var addonArn: kotlin.String? = null
        /**
         * The name of the add-on.
         */
        var addonName: kotlin.String? = null
        /**
         * The version of the add-on.
         */
        var addonVersion: kotlin.String? = null
        /**
         * The name of the cluster.
         */
        var clusterName: kotlin.String? = null
        /**
         * The date and time that the add-on was created.
         */
        var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An object that represents the health of the add-on.
         */
        var health: aws.sdk.kotlin.services.eks.model.AddonHealth? = null
        /**
         * The date and time that the add-on was last modified.
         */
        var modifiedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role that is bound to the Kubernetes service account used by the add-on.
         */
        var serviceAccountRoleArn: kotlin.String? = null
        /**
         * The status of the add-on.
         */
        var status: aws.sdk.kotlin.services.eks.model.AddonStatus? = null
        /**
         * The metadata that you apply to the add-on to assist with categorization and organization. Each tag consists of a key and an optional value. You define both. Add-on tags do not propagate to any other resources associated with the cluster.
         */
        var tags: Map<String, String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.Addon) : this() {
            this.addonArn = x.addonArn
            this.addonName = x.addonName
            this.addonVersion = x.addonVersion
            this.clusterName = x.clusterName
            this.createdAt = x.createdAt
            this.health = x.health
            this.modifiedAt = x.modifiedAt
            this.serviceAccountRoleArn = x.serviceAccountRoleArn
            this.status = x.status
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.Addon = Addon(this)

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.AddonHealth] inside the given [block]
         */
        fun health(block: aws.sdk.kotlin.services.eks.model.AddonHealth.Builder.() -> kotlin.Unit) {
            this.health = aws.sdk.kotlin.services.eks.model.AddonHealth.invoke(block)
        }
    }
}
