// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An object representing an Amazon EKS cluster.
 */
class Cluster private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the cluster.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * The `certificate-authority-data` for your cluster.
     */
    val certificateAuthority: aws.sdk.kotlin.services.eks.model.Certificate? = builder.certificateAuthority
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The configuration used to connect to a cluster for registration.
     */
    val connectorConfig: aws.sdk.kotlin.services.eks.model.ConnectorConfigResponse? = builder.connectorConfig
    /**
     * The Unix epoch timestamp in seconds for when the cluster was created.
     */
    val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The encryption configuration for the cluster.
     */
    val encryptionConfig: List<EncryptionConfig>? = builder.encryptionConfig
    /**
     * The endpoint for your Kubernetes API server.
     */
    val endpoint: kotlin.String? = builder.endpoint
    /**
     * The identity provider information for the cluster.
     */
    val identity: aws.sdk.kotlin.services.eks.model.Identity? = builder.identity
    /**
     * The Kubernetes network configuration for the cluster.
     */
    val kubernetesNetworkConfig: aws.sdk.kotlin.services.eks.model.KubernetesNetworkConfigResponse? = builder.kubernetesNetworkConfig
    /**
     * The logging configuration for your cluster.
     */
    val logging: aws.sdk.kotlin.services.eks.model.Logging? = builder.logging
    /**
     * The name of the cluster.
     */
    val name: kotlin.String? = builder.name
    /**
     * The platform version of your Amazon EKS cluster. For more information, see [Platform Versions](https://docs.aws.amazon.com/eks/latest/userguide/platform-versions.html) in the **Amazon EKS User Guide**.
     */
    val platformVersion: kotlin.String? = builder.platformVersion
    /**
     * The VPC configuration used by the cluster control plane. Amazon EKS VPC resources have specific requirements to work properly with Kubernetes. For more information, see [Cluster VPC Considerations](https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html) and [Cluster Security Group Considerations](https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html) in the *Amazon EKS User Guide*.
     */
    val resourcesVpcConfig: aws.sdk.kotlin.services.eks.model.VpcConfigResponse? = builder.resourcesVpcConfig
    /**
     * The Amazon Resource Name (ARN) of the IAM role that provides permissions for the Kubernetes control plane to make calls to Amazon Web Services API operations on your behalf.
     */
    val roleArn: kotlin.String? = builder.roleArn
    /**
     * The current status of the cluster.
     */
    val status: aws.sdk.kotlin.services.eks.model.ClusterStatus? = builder.status
    /**
     * The metadata that you apply to the cluster to assist with categorization and organization. Each tag consists of a key and an optional value. You define both. Cluster tags do not propagate to any other resources associated with the cluster.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * The Kubernetes server version for the cluster.
     */
    val version: kotlin.String? = builder.version

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.Cluster = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Cluster(")
        append("arn=$arn,")
        append("certificateAuthority=$certificateAuthority,")
        append("clientRequestToken=$clientRequestToken,")
        append("connectorConfig=$connectorConfig,")
        append("createdAt=$createdAt,")
        append("encryptionConfig=$encryptionConfig,")
        append("endpoint=$endpoint,")
        append("identity=$identity,")
        append("kubernetesNetworkConfig=$kubernetesNetworkConfig,")
        append("logging=$logging,")
        append("name=$name,")
        append("platformVersion=$platformVersion,")
        append("resourcesVpcConfig=$resourcesVpcConfig,")
        append("roleArn=$roleArn,")
        append("status=$status,")
        append("tags=$tags,")
        append("version=$version)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (certificateAuthority?.hashCode() ?: 0)
        result = 31 * result + (clientRequestToken?.hashCode() ?: 0)
        result = 31 * result + (connectorConfig?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (encryptionConfig?.hashCode() ?: 0)
        result = 31 * result + (endpoint?.hashCode() ?: 0)
        result = 31 * result + (identity?.hashCode() ?: 0)
        result = 31 * result + (kubernetesNetworkConfig?.hashCode() ?: 0)
        result = 31 * result + (logging?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (platformVersion?.hashCode() ?: 0)
        result = 31 * result + (resourcesVpcConfig?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Cluster

        if (arn != other.arn) return false
        if (certificateAuthority != other.certificateAuthority) return false
        if (clientRequestToken != other.clientRequestToken) return false
        if (connectorConfig != other.connectorConfig) return false
        if (createdAt != other.createdAt) return false
        if (encryptionConfig != other.encryptionConfig) return false
        if (endpoint != other.endpoint) return false
        if (identity != other.identity) return false
        if (kubernetesNetworkConfig != other.kubernetesNetworkConfig) return false
        if (logging != other.logging) return false
        if (name != other.name) return false
        if (platformVersion != other.platformVersion) return false
        if (resourcesVpcConfig != other.resourcesVpcConfig) return false
        if (roleArn != other.roleArn) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (version != other.version) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.Cluster = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the cluster.
         */
        var arn: kotlin.String? = null
        /**
         * The `certificate-authority-data` for your cluster.
         */
        var certificateAuthority: aws.sdk.kotlin.services.eks.model.Certificate? = null
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         */
        var clientRequestToken: kotlin.String? = null
        /**
         * The configuration used to connect to a cluster for registration.
         */
        var connectorConfig: aws.sdk.kotlin.services.eks.model.ConnectorConfigResponse? = null
        /**
         * The Unix epoch timestamp in seconds for when the cluster was created.
         */
        var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The encryption configuration for the cluster.
         */
        var encryptionConfig: List<EncryptionConfig>? = null
        /**
         * The endpoint for your Kubernetes API server.
         */
        var endpoint: kotlin.String? = null
        /**
         * The identity provider information for the cluster.
         */
        var identity: aws.sdk.kotlin.services.eks.model.Identity? = null
        /**
         * The Kubernetes network configuration for the cluster.
         */
        var kubernetesNetworkConfig: aws.sdk.kotlin.services.eks.model.KubernetesNetworkConfigResponse? = null
        /**
         * The logging configuration for your cluster.
         */
        var logging: aws.sdk.kotlin.services.eks.model.Logging? = null
        /**
         * The name of the cluster.
         */
        var name: kotlin.String? = null
        /**
         * The platform version of your Amazon EKS cluster. For more information, see [Platform Versions](https://docs.aws.amazon.com/eks/latest/userguide/platform-versions.html) in the **Amazon EKS User Guide**.
         */
        var platformVersion: kotlin.String? = null
        /**
         * The VPC configuration used by the cluster control plane. Amazon EKS VPC resources have specific requirements to work properly with Kubernetes. For more information, see [Cluster VPC Considerations](https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html) and [Cluster Security Group Considerations](https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html) in the *Amazon EKS User Guide*.
         */
        var resourcesVpcConfig: aws.sdk.kotlin.services.eks.model.VpcConfigResponse? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role that provides permissions for the Kubernetes control plane to make calls to Amazon Web Services API operations on your behalf.
         */
        var roleArn: kotlin.String? = null
        /**
         * The current status of the cluster.
         */
        var status: aws.sdk.kotlin.services.eks.model.ClusterStatus? = null
        /**
         * The metadata that you apply to the cluster to assist with categorization and organization. Each tag consists of a key and an optional value. You define both. Cluster tags do not propagate to any other resources associated with the cluster.
         */
        var tags: Map<String, String>? = null
        /**
         * The Kubernetes server version for the cluster.
         */
        var version: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.Cluster) : this() {
            this.arn = x.arn
            this.certificateAuthority = x.certificateAuthority
            this.clientRequestToken = x.clientRequestToken
            this.connectorConfig = x.connectorConfig
            this.createdAt = x.createdAt
            this.encryptionConfig = x.encryptionConfig
            this.endpoint = x.endpoint
            this.identity = x.identity
            this.kubernetesNetworkConfig = x.kubernetesNetworkConfig
            this.logging = x.logging
            this.name = x.name
            this.platformVersion = x.platformVersion
            this.resourcesVpcConfig = x.resourcesVpcConfig
            this.roleArn = x.roleArn
            this.status = x.status
            this.tags = x.tags
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.Cluster = Cluster(this)

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.Certificate] inside the given [block]
         */
        fun certificateAuthority(block: aws.sdk.kotlin.services.eks.model.Certificate.Builder.() -> kotlin.Unit) {
            this.certificateAuthority = aws.sdk.kotlin.services.eks.model.Certificate.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.ConnectorConfigResponse] inside the given [block]
         */
        fun connectorConfig(block: aws.sdk.kotlin.services.eks.model.ConnectorConfigResponse.Builder.() -> kotlin.Unit) {
            this.connectorConfig = aws.sdk.kotlin.services.eks.model.ConnectorConfigResponse.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.Identity] inside the given [block]
         */
        fun identity(block: aws.sdk.kotlin.services.eks.model.Identity.Builder.() -> kotlin.Unit) {
            this.identity = aws.sdk.kotlin.services.eks.model.Identity.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.KubernetesNetworkConfigResponse] inside the given [block]
         */
        fun kubernetesNetworkConfig(block: aws.sdk.kotlin.services.eks.model.KubernetesNetworkConfigResponse.Builder.() -> kotlin.Unit) {
            this.kubernetesNetworkConfig = aws.sdk.kotlin.services.eks.model.KubernetesNetworkConfigResponse.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.Logging] inside the given [block]
         */
        fun logging(block: aws.sdk.kotlin.services.eks.model.Logging.Builder.() -> kotlin.Unit) {
            this.logging = aws.sdk.kotlin.services.eks.model.Logging.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.VpcConfigResponse] inside the given [block]
         */
        fun resourcesVpcConfig(block: aws.sdk.kotlin.services.eks.model.VpcConfigResponse.Builder.() -> kotlin.Unit) {
            this.resourcesVpcConfig = aws.sdk.kotlin.services.eks.model.VpcConfigResponse.invoke(block)
        }
    }
}
