// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model



class CreateClusterRequest private constructor(builder: Builder) {
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The encryption configuration for the cluster.
     */
    val encryptionConfig: List<EncryptionConfig>? = builder.encryptionConfig
    /**
     * The Kubernetes network configuration for the cluster.
     */
    val kubernetesNetworkConfig: aws.sdk.kotlin.services.eks.model.KubernetesNetworkConfigRequest? = builder.kubernetesNetworkConfig
    /**
     * Enable or disable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs. By default, cluster control plane logs aren't exported to CloudWatch Logs. For more information, see [Amazon EKS Cluster control plane logs](https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html) in the **Amazon EKS User Guide**.
     *
     * CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane logs. For more information, see [CloudWatch Pricing](http://aws.amazon.com/cloudwatch/pricing/).
     */
    val logging: aws.sdk.kotlin.services.eks.model.Logging? = builder.logging
    /**
     * The unique name to give to your cluster.
     */
    val name: kotlin.String? = builder.name
    /**
     * The VPC configuration that's used by the cluster control plane. Amazon EKS VPC resources have specific requirements to work properly with Kubernetes. For more information, see [Cluster VPC Considerations](https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html) and [Cluster Security Group Considerations](https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html) in the *Amazon EKS User Guide*. You must specify at least two subnets. You can specify up to five security groups. However, we recommend that you use a dedicated security group for your cluster control plane.
     */
    val resourcesVpcConfig: aws.sdk.kotlin.services.eks.model.VpcConfigRequest? = builder.resourcesVpcConfig
    /**
     * The Amazon Resource Name (ARN) of the IAM role that provides permissions for the Kubernetes control plane to make calls to Amazon Web Services API operations on your behalf. For more information, see [Amazon EKS Service IAM Role](https://docs.aws.amazon.com/eks/latest/userguide/service_IAM_role.html) in the **Amazon EKS User Guide**.
     */
    val roleArn: kotlin.String? = builder.roleArn
    /**
     * The metadata to apply to the cluster to assist with categorization and organization. Each tag consists of a key and an optional value. You define both.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * The desired Kubernetes version for your cluster. If you don't specify a value here, the latest version available in Amazon EKS is used.
     */
    val version: kotlin.String? = builder.version

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.CreateClusterRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateClusterRequest(")
        append("clientRequestToken=$clientRequestToken,")
        append("encryptionConfig=$encryptionConfig,")
        append("kubernetesNetworkConfig=$kubernetesNetworkConfig,")
        append("logging=$logging,")
        append("name=$name,")
        append("resourcesVpcConfig=$resourcesVpcConfig,")
        append("roleArn=$roleArn,")
        append("tags=$tags,")
        append("version=$version)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientRequestToken?.hashCode() ?: 0
        result = 31 * result + (encryptionConfig?.hashCode() ?: 0)
        result = 31 * result + (kubernetesNetworkConfig?.hashCode() ?: 0)
        result = 31 * result + (logging?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (resourcesVpcConfig?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateClusterRequest

        if (clientRequestToken != other.clientRequestToken) return false
        if (encryptionConfig != other.encryptionConfig) return false
        if (kubernetesNetworkConfig != other.kubernetesNetworkConfig) return false
        if (logging != other.logging) return false
        if (name != other.name) return false
        if (resourcesVpcConfig != other.resourcesVpcConfig) return false
        if (roleArn != other.roleArn) return false
        if (tags != other.tags) return false
        if (version != other.version) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.CreateClusterRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         */
        var clientRequestToken: kotlin.String? = null
        /**
         * The encryption configuration for the cluster.
         */
        var encryptionConfig: List<EncryptionConfig>? = null
        /**
         * The Kubernetes network configuration for the cluster.
         */
        var kubernetesNetworkConfig: aws.sdk.kotlin.services.eks.model.KubernetesNetworkConfigRequest? = null
        /**
         * Enable or disable exporting the Kubernetes control plane logs for your cluster to CloudWatch Logs. By default, cluster control plane logs aren't exported to CloudWatch Logs. For more information, see [Amazon EKS Cluster control plane logs](https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html) in the **Amazon EKS User Guide**.
         *
         * CloudWatch Logs ingestion, archive storage, and data scanning rates apply to exported control plane logs. For more information, see [CloudWatch Pricing](http://aws.amazon.com/cloudwatch/pricing/).
         */
        var logging: aws.sdk.kotlin.services.eks.model.Logging? = null
        /**
         * The unique name to give to your cluster.
         */
        var name: kotlin.String? = null
        /**
         * The VPC configuration that's used by the cluster control plane. Amazon EKS VPC resources have specific requirements to work properly with Kubernetes. For more information, see [Cluster VPC Considerations](https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html) and [Cluster Security Group Considerations](https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html) in the *Amazon EKS User Guide*. You must specify at least two subnets. You can specify up to five security groups. However, we recommend that you use a dedicated security group for your cluster control plane.
         */
        var resourcesVpcConfig: aws.sdk.kotlin.services.eks.model.VpcConfigRequest? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role that provides permissions for the Kubernetes control plane to make calls to Amazon Web Services API operations on your behalf. For more information, see [Amazon EKS Service IAM Role](https://docs.aws.amazon.com/eks/latest/userguide/service_IAM_role.html) in the **Amazon EKS User Guide**.
         */
        var roleArn: kotlin.String? = null
        /**
         * The metadata to apply to the cluster to assist with categorization and organization. Each tag consists of a key and an optional value. You define both.
         */
        var tags: Map<String, String>? = null
        /**
         * The desired Kubernetes version for your cluster. If you don't specify a value here, the latest version available in Amazon EKS is used.
         */
        var version: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.CreateClusterRequest) : this() {
            this.clientRequestToken = x.clientRequestToken
            this.encryptionConfig = x.encryptionConfig
            this.kubernetesNetworkConfig = x.kubernetesNetworkConfig
            this.logging = x.logging
            this.name = x.name
            this.resourcesVpcConfig = x.resourcesVpcConfig
            this.roleArn = x.roleArn
            this.tags = x.tags
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.CreateClusterRequest = CreateClusterRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.KubernetesNetworkConfigRequest] inside the given [block]
         */
        fun kubernetesNetworkConfig(block: aws.sdk.kotlin.services.eks.model.KubernetesNetworkConfigRequest.Builder.() -> kotlin.Unit) {
            this.kubernetesNetworkConfig = aws.sdk.kotlin.services.eks.model.KubernetesNetworkConfigRequest.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.Logging] inside the given [block]
         */
        fun logging(block: aws.sdk.kotlin.services.eks.model.Logging.Builder.() -> kotlin.Unit) {
            this.logging = aws.sdk.kotlin.services.eks.model.Logging.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.VpcConfigRequest] inside the given [block]
         */
        fun resourcesVpcConfig(block: aws.sdk.kotlin.services.eks.model.VpcConfigRequest.Builder.() -> kotlin.Unit) {
            this.resourcesVpcConfig = aws.sdk.kotlin.services.eks.model.VpcConfigRequest.invoke(block)
        }
    }
}
