// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model



class CreateNodegroupRequest private constructor(builder: Builder) {
    /**
     * The AMI type for your node group. GPU instance types should use the `AL2_x86_64_GPU` AMI type. Non-GPU instances should use the `AL2_x86_64` AMI type. Arm instances should use the `AL2_ARM_64` AMI type. All types use the Amazon EKS optimized Amazon Linux 2 AMI. If you specify `launchTemplate`, and your launch template uses a custom AMI, then don't specify `amiType`, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see [Launch template support](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html) in the *Amazon EKS User Guide*.
     */
    val amiType: aws.sdk.kotlin.services.eks.model.AmiTypes? = builder.amiType
    /**
     * The capacity type for your node group.
     */
    val capacityType: aws.sdk.kotlin.services.eks.model.CapacityTypes? = builder.capacityType
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The name of the cluster to create the node group in.
     */
    val clusterName: kotlin.String? = builder.clusterName
    /**
     * The root device disk size (in GiB) for your node group instances. The default disk size is 20 GiB. If you specify `launchTemplate`, then don't specify `diskSize`, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see [Launch template support](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html) in the *Amazon EKS User Guide*.
     */
    val diskSize: kotlin.Int? = builder.diskSize
    /**
     * Specify the instance types for a node group. If you specify a GPU instance type, be sure to specify `AL2_x86_64_GPU` with the `amiType` parameter. If you specify `launchTemplate`, then you can specify zero or one instance type in your launch template *or* you can specify 0-20 instance types for `instanceTypes`. If however, you specify an instance type in your launch template *and* specify any `instanceTypes`, the node group deployment will fail. If you don't specify an instance type in a launch template or for `instanceTypes`, then `t3.medium` is used, by default. If you specify `Spot` for `capacityType`, then we recommend specifying multiple values for `instanceTypes`. For more information, see [Managed node group capacity types](https://docs.aws.amazon.com/eks/latest/userguide/managed-node-groups.html#managed-node-group-capacity-types) and [Launch template support](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html) in the *Amazon EKS User Guide*.
     */
    val instanceTypes: List<String>? = builder.instanceTypes
    /**
     * The Kubernetes labels to be applied to the nodes in the node group when they are created.
     */
    val labels: Map<String, String>? = builder.labels
    /**
     * An object representing a node group's launch template specification. If specified, then do not specify `instanceTypes`, `diskSize`, or `remoteAccess` and make sure that the launch template meets the requirements in `launchTemplateSpecification`.
     */
    val launchTemplate: aws.sdk.kotlin.services.eks.model.LaunchTemplateSpecification? = builder.launchTemplate
    /**
     * The Amazon Resource Name (ARN) of the IAM role to associate with your node group. The Amazon EKS worker node `kubelet` daemon makes calls to Amazon Web Services APIs on your behalf. Nodes receive permissions for these API calls through an IAM instance profile and associated policies. Before you can launch nodes and register them into a cluster, you must create an IAM role for those nodes to use when they are launched. For more information, see [Amazon EKS node IAM role](https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html) in the **Amazon EKS User Guide**. If you specify `launchTemplate`, then don't specify `IamInstanceProfile`[](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_IamInstanceProfile.html) in your launch template, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see [Launch template support](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html) in the *Amazon EKS User Guide*.
     */
    val nodeRole: kotlin.String? = builder.nodeRole
    /**
     * The unique name to give your node group.
     */
    val nodegroupName: kotlin.String? = builder.nodegroupName
    /**
     * The AMI version of the Amazon EKS optimized AMI to use with your node group. By default, the latest available AMI version for the node group's current Kubernetes version is used. For more information, see [Amazon EKS optimized Amazon Linux 2 AMI versions](https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html) in the *Amazon EKS User Guide*. If you specify `launchTemplate`, and your launch template uses a custom AMI, then don't specify `releaseVersion`, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see [Launch template support](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html) in the *Amazon EKS User Guide*.
     */
    val releaseVersion: kotlin.String? = builder.releaseVersion
    /**
     * The remote access (SSH) configuration to use with your node group. If you specify `launchTemplate`, then don't specify `remoteAccess`, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see [Launch template support](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html) in the *Amazon EKS User Guide*.
     */
    val remoteAccess: aws.sdk.kotlin.services.eks.model.RemoteAccessConfig? = builder.remoteAccess
    /**
     * The scaling configuration details for the Auto Scaling group that is created for your node group.
     */
    val scalingConfig: aws.sdk.kotlin.services.eks.model.NodegroupScalingConfig? = builder.scalingConfig
    /**
     * The subnets to use for the Auto Scaling group that is created for your node group. If you specify `launchTemplate`, then don't specify `SubnetId`[](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInterface.html) in your launch template, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see [Launch template support](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html) in the *Amazon EKS User Guide*.
     */
    val subnets: List<String>? = builder.subnets
    /**
     * The metadata to apply to the node group to assist with categorization and organization. Each tag consists of a key and an optional value. You define both. Node group tags do not propagate to any other resources associated with the node group, such as the Amazon EC2 instances or subnets.
     */
    val tags: Map<String, String>? = builder.tags
    /**
     * The Kubernetes taints to be applied to the nodes in the node group. For more information, see [Node taints on managed node groups](https://docs.aws.amazon.com/eks/latest/userguide/node-taints-managed-node-groups.html).
     */
    val taints: List<Taint>? = builder.taints
    /**
     * The node group update configuration.
     */
    val updateConfig: aws.sdk.kotlin.services.eks.model.NodegroupUpdateConfig? = builder.updateConfig
    /**
     * The Kubernetes version to use for your managed nodes. By default, the Kubernetes version of the cluster is used, and this is the only accepted specified value. If you specify `launchTemplate`, and your launch template uses a custom AMI, then don't specify `version`, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see [Launch template support](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html) in the *Amazon EKS User Guide*.
     */
    val version: kotlin.String? = builder.version

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.CreateNodegroupRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateNodegroupRequest(")
        append("amiType=$amiType,")
        append("capacityType=$capacityType,")
        append("clientRequestToken=$clientRequestToken,")
        append("clusterName=$clusterName,")
        append("diskSize=$diskSize,")
        append("instanceTypes=$instanceTypes,")
        append("labels=$labels,")
        append("launchTemplate=$launchTemplate,")
        append("nodeRole=$nodeRole,")
        append("nodegroupName=$nodegroupName,")
        append("releaseVersion=$releaseVersion,")
        append("remoteAccess=$remoteAccess,")
        append("scalingConfig=$scalingConfig,")
        append("subnets=$subnets,")
        append("tags=$tags,")
        append("taints=$taints,")
        append("updateConfig=$updateConfig,")
        append("version=$version)")
    }

    override fun hashCode(): kotlin.Int {
        var result = amiType?.hashCode() ?: 0
        result = 31 * result + (capacityType?.hashCode() ?: 0)
        result = 31 * result + (clientRequestToken?.hashCode() ?: 0)
        result = 31 * result + (clusterName?.hashCode() ?: 0)
        result = 31 * result + (diskSize ?: 0)
        result = 31 * result + (instanceTypes?.hashCode() ?: 0)
        result = 31 * result + (labels?.hashCode() ?: 0)
        result = 31 * result + (launchTemplate?.hashCode() ?: 0)
        result = 31 * result + (nodeRole?.hashCode() ?: 0)
        result = 31 * result + (nodegroupName?.hashCode() ?: 0)
        result = 31 * result + (releaseVersion?.hashCode() ?: 0)
        result = 31 * result + (remoteAccess?.hashCode() ?: 0)
        result = 31 * result + (scalingConfig?.hashCode() ?: 0)
        result = 31 * result + (subnets?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (taints?.hashCode() ?: 0)
        result = 31 * result + (updateConfig?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateNodegroupRequest

        if (amiType != other.amiType) return false
        if (capacityType != other.capacityType) return false
        if (clientRequestToken != other.clientRequestToken) return false
        if (clusterName != other.clusterName) return false
        if (diskSize != other.diskSize) return false
        if (instanceTypes != other.instanceTypes) return false
        if (labels != other.labels) return false
        if (launchTemplate != other.launchTemplate) return false
        if (nodeRole != other.nodeRole) return false
        if (nodegroupName != other.nodegroupName) return false
        if (releaseVersion != other.releaseVersion) return false
        if (remoteAccess != other.remoteAccess) return false
        if (scalingConfig != other.scalingConfig) return false
        if (subnets != other.subnets) return false
        if (tags != other.tags) return false
        if (taints != other.taints) return false
        if (updateConfig != other.updateConfig) return false
        if (version != other.version) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.CreateNodegroupRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The AMI type for your node group. GPU instance types should use the `AL2_x86_64_GPU` AMI type. Non-GPU instances should use the `AL2_x86_64` AMI type. Arm instances should use the `AL2_ARM_64` AMI type. All types use the Amazon EKS optimized Amazon Linux 2 AMI. If you specify `launchTemplate`, and your launch template uses a custom AMI, then don't specify `amiType`, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see [Launch template support](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html) in the *Amazon EKS User Guide*.
         */
        var amiType: aws.sdk.kotlin.services.eks.model.AmiTypes? = null
        /**
         * The capacity type for your node group.
         */
        var capacityType: aws.sdk.kotlin.services.eks.model.CapacityTypes? = null
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         */
        var clientRequestToken: kotlin.String? = null
        /**
         * The name of the cluster to create the node group in.
         */
        var clusterName: kotlin.String? = null
        /**
         * The root device disk size (in GiB) for your node group instances. The default disk size is 20 GiB. If you specify `launchTemplate`, then don't specify `diskSize`, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see [Launch template support](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html) in the *Amazon EKS User Guide*.
         */
        var diskSize: kotlin.Int? = null
        /**
         * Specify the instance types for a node group. If you specify a GPU instance type, be sure to specify `AL2_x86_64_GPU` with the `amiType` parameter. If you specify `launchTemplate`, then you can specify zero or one instance type in your launch template *or* you can specify 0-20 instance types for `instanceTypes`. If however, you specify an instance type in your launch template *and* specify any `instanceTypes`, the node group deployment will fail. If you don't specify an instance type in a launch template or for `instanceTypes`, then `t3.medium` is used, by default. If you specify `Spot` for `capacityType`, then we recommend specifying multiple values for `instanceTypes`. For more information, see [Managed node group capacity types](https://docs.aws.amazon.com/eks/latest/userguide/managed-node-groups.html#managed-node-group-capacity-types) and [Launch template support](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html) in the *Amazon EKS User Guide*.
         */
        var instanceTypes: List<String>? = null
        /**
         * The Kubernetes labels to be applied to the nodes in the node group when they are created.
         */
        var labels: Map<String, String>? = null
        /**
         * An object representing a node group's launch template specification. If specified, then do not specify `instanceTypes`, `diskSize`, or `remoteAccess` and make sure that the launch template meets the requirements in `launchTemplateSpecification`.
         */
        var launchTemplate: aws.sdk.kotlin.services.eks.model.LaunchTemplateSpecification? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role to associate with your node group. The Amazon EKS worker node `kubelet` daemon makes calls to Amazon Web Services APIs on your behalf. Nodes receive permissions for these API calls through an IAM instance profile and associated policies. Before you can launch nodes and register them into a cluster, you must create an IAM role for those nodes to use when they are launched. For more information, see [Amazon EKS node IAM role](https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html) in the **Amazon EKS User Guide**. If you specify `launchTemplate`, then don't specify `IamInstanceProfile`[](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_IamInstanceProfile.html) in your launch template, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see [Launch template support](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html) in the *Amazon EKS User Guide*.
         */
        var nodeRole: kotlin.String? = null
        /**
         * The unique name to give your node group.
         */
        var nodegroupName: kotlin.String? = null
        /**
         * The AMI version of the Amazon EKS optimized AMI to use with your node group. By default, the latest available AMI version for the node group's current Kubernetes version is used. For more information, see [Amazon EKS optimized Amazon Linux 2 AMI versions](https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html) in the *Amazon EKS User Guide*. If you specify `launchTemplate`, and your launch template uses a custom AMI, then don't specify `releaseVersion`, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see [Launch template support](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html) in the *Amazon EKS User Guide*.
         */
        var releaseVersion: kotlin.String? = null
        /**
         * The remote access (SSH) configuration to use with your node group. If you specify `launchTemplate`, then don't specify `remoteAccess`, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see [Launch template support](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html) in the *Amazon EKS User Guide*.
         */
        var remoteAccess: aws.sdk.kotlin.services.eks.model.RemoteAccessConfig? = null
        /**
         * The scaling configuration details for the Auto Scaling group that is created for your node group.
         */
        var scalingConfig: aws.sdk.kotlin.services.eks.model.NodegroupScalingConfig? = null
        /**
         * The subnets to use for the Auto Scaling group that is created for your node group. If you specify `launchTemplate`, then don't specify `SubnetId`[](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInterface.html) in your launch template, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see [Launch template support](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html) in the *Amazon EKS User Guide*.
         */
        var subnets: List<String>? = null
        /**
         * The metadata to apply to the node group to assist with categorization and organization. Each tag consists of a key and an optional value. You define both. Node group tags do not propagate to any other resources associated with the node group, such as the Amazon EC2 instances or subnets.
         */
        var tags: Map<String, String>? = null
        /**
         * The Kubernetes taints to be applied to the nodes in the node group. For more information, see [Node taints on managed node groups](https://docs.aws.amazon.com/eks/latest/userguide/node-taints-managed-node-groups.html).
         */
        var taints: List<Taint>? = null
        /**
         * The node group update configuration.
         */
        var updateConfig: aws.sdk.kotlin.services.eks.model.NodegroupUpdateConfig? = null
        /**
         * The Kubernetes version to use for your managed nodes. By default, the Kubernetes version of the cluster is used, and this is the only accepted specified value. If you specify `launchTemplate`, and your launch template uses a custom AMI, then don't specify `version`, or the node group deployment will fail. For more information about using launch templates with Amazon EKS, see [Launch template support](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html) in the *Amazon EKS User Guide*.
         */
        var version: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.CreateNodegroupRequest) : this() {
            this.amiType = x.amiType
            this.capacityType = x.capacityType
            this.clientRequestToken = x.clientRequestToken
            this.clusterName = x.clusterName
            this.diskSize = x.diskSize
            this.instanceTypes = x.instanceTypes
            this.labels = x.labels
            this.launchTemplate = x.launchTemplate
            this.nodeRole = x.nodeRole
            this.nodegroupName = x.nodegroupName
            this.releaseVersion = x.releaseVersion
            this.remoteAccess = x.remoteAccess
            this.scalingConfig = x.scalingConfig
            this.subnets = x.subnets
            this.tags = x.tags
            this.taints = x.taints
            this.updateConfig = x.updateConfig
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.CreateNodegroupRequest = CreateNodegroupRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.LaunchTemplateSpecification] inside the given [block]
         */
        fun launchTemplate(block: aws.sdk.kotlin.services.eks.model.LaunchTemplateSpecification.Builder.() -> kotlin.Unit) {
            this.launchTemplate = aws.sdk.kotlin.services.eks.model.LaunchTemplateSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.RemoteAccessConfig] inside the given [block]
         */
        fun remoteAccess(block: aws.sdk.kotlin.services.eks.model.RemoteAccessConfig.Builder.() -> kotlin.Unit) {
            this.remoteAccess = aws.sdk.kotlin.services.eks.model.RemoteAccessConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.NodegroupScalingConfig] inside the given [block]
         */
        fun scalingConfig(block: aws.sdk.kotlin.services.eks.model.NodegroupScalingConfig.Builder.() -> kotlin.Unit) {
            this.scalingConfig = aws.sdk.kotlin.services.eks.model.NodegroupScalingConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.eks.model.NodegroupUpdateConfig] inside the given [block]
         */
        fun updateConfig(block: aws.sdk.kotlin.services.eks.model.NodegroupUpdateConfig.Builder.() -> kotlin.Unit) {
            this.updateConfig = aws.sdk.kotlin.services.eks.model.NodegroupUpdateConfig.invoke(block)
        }
    }
}
