// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An object representing an Fargate profile.
 */
class FargateProfile private constructor(builder: Builder) {
    /**
     * The name of the Amazon EKS cluster that the Fargate profile belongs to.
     */
    val clusterName: kotlin.String? = builder.clusterName
    /**
     * The Unix epoch timestamp in seconds for when the Fargate profile was created.
     */
    val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The full Amazon Resource Name (ARN) of the Fargate profile.
     */
    val fargateProfileArn: kotlin.String? = builder.fargateProfileArn
    /**
     * The name of the Fargate profile.
     */
    val fargateProfileName: kotlin.String? = builder.fargateProfileName
    /**
     * The Amazon Resource Name (ARN) of the pod execution role to use for pods that match the selectors in the Fargate profile. For more information, see [Pod Execution Role](https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html) in the *Amazon EKS User Guide*.
     */
    val podExecutionRoleArn: kotlin.String? = builder.podExecutionRoleArn
    /**
     * The selectors to match for pods to use this Fargate profile.
     */
    val selectors: List<FargateProfileSelector>? = builder.selectors
    /**
     * The current status of the Fargate profile.
     */
    val status: aws.sdk.kotlin.services.eks.model.FargateProfileStatus? = builder.status
    /**
     * The IDs of subnets to launch pods into.
     */
    val subnets: List<String>? = builder.subnets
    /**
     * The metadata applied to the Fargate profile to assist with categorization and organization. Each tag consists of a key and an optional value. You define both. Fargate profile tags do not propagate to any other resources associated with the Fargate profile, such as the pods that are scheduled with it.
     */
    val tags: Map<String, String>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.FargateProfile = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FargateProfile(")
        append("clusterName=$clusterName,")
        append("createdAt=$createdAt,")
        append("fargateProfileArn=$fargateProfileArn,")
        append("fargateProfileName=$fargateProfileName,")
        append("podExecutionRoleArn=$podExecutionRoleArn,")
        append("selectors=$selectors,")
        append("status=$status,")
        append("subnets=$subnets,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterName?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (fargateProfileArn?.hashCode() ?: 0)
        result = 31 * result + (fargateProfileName?.hashCode() ?: 0)
        result = 31 * result + (podExecutionRoleArn?.hashCode() ?: 0)
        result = 31 * result + (selectors?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (subnets?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FargateProfile

        if (clusterName != other.clusterName) return false
        if (createdAt != other.createdAt) return false
        if (fargateProfileArn != other.fargateProfileArn) return false
        if (fargateProfileName != other.fargateProfileName) return false
        if (podExecutionRoleArn != other.podExecutionRoleArn) return false
        if (selectors != other.selectors) return false
        if (status != other.status) return false
        if (subnets != other.subnets) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.FargateProfile = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the Amazon EKS cluster that the Fargate profile belongs to.
         */
        var clusterName: kotlin.String? = null
        /**
         * The Unix epoch timestamp in seconds for when the Fargate profile was created.
         */
        var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The full Amazon Resource Name (ARN) of the Fargate profile.
         */
        var fargateProfileArn: kotlin.String? = null
        /**
         * The name of the Fargate profile.
         */
        var fargateProfileName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the pod execution role to use for pods that match the selectors in the Fargate profile. For more information, see [Pod Execution Role](https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html) in the *Amazon EKS User Guide*.
         */
        var podExecutionRoleArn: kotlin.String? = null
        /**
         * The selectors to match for pods to use this Fargate profile.
         */
        var selectors: List<FargateProfileSelector>? = null
        /**
         * The current status of the Fargate profile.
         */
        var status: aws.sdk.kotlin.services.eks.model.FargateProfileStatus? = null
        /**
         * The IDs of subnets to launch pods into.
         */
        var subnets: List<String>? = null
        /**
         * The metadata applied to the Fargate profile to assist with categorization and organization. Each tag consists of a key and an optional value. You define both. Fargate profile tags do not propagate to any other resources associated with the Fargate profile, such as the pods that are scheduled with it.
         */
        var tags: Map<String, String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.FargateProfile) : this() {
            this.clusterName = x.clusterName
            this.createdAt = x.createdAt
            this.fargateProfileArn = x.fargateProfileArn
            this.fargateProfileName = x.fargateProfileName
            this.podExecutionRoleArn = x.podExecutionRoleArn
            this.selectors = x.selectors
            this.status = x.status
            this.subnets = x.subnets
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.FargateProfile = FargateProfile(this)
    }
}
