// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model



/**
 * An object representing an issue with an Amazon EKS resource.
 */
class Issue private constructor(builder: Builder) {
    /**
     * A brief description of the error.
     * + **AccessDenied**: Amazon EKS or one or more of your managed nodes is failing to authenticate or authorize with your Kubernetes cluster API server.
     * + **AsgInstanceLaunchFailures**: Your Auto Scaling group is experiencing failures while attempting to launch instances.
     * + **AutoScalingGroupNotFound**: We couldn't find the Auto Scaling group associated with the managed node group. You may be able to recreate an Auto Scaling group with the same settings to recover.
     * + **ClusterUnreachable**: Amazon EKS or one or more of your managed nodes is unable to to communicate with your Kubernetes cluster API server. This can happen if there are network disruptions or if API servers are timing out processing requests.
     * + **Ec2LaunchTemplateNotFound**: We couldn't find the Amazon EC2 launch template for your managed node group. You may be able to recreate a launch template with the same settings to recover.
     * + **Ec2LaunchTemplateVersionMismatch**: The Amazon EC2 launch template version for your managed node group does not match the version that Amazon EKS created. You may be able to revert to the version that Amazon EKS created to recover.
     * + **Ec2SecurityGroupDeletionFailure**: We could not delete the remote access security group for your managed node group. Remove any dependencies from the security group.
     * + **Ec2SecurityGroupNotFound**: We couldn't find the cluster security group for the cluster. You must recreate your cluster.
     * + **Ec2SubnetInvalidConfiguration**: One or more Amazon EC2 subnets specified for a node group do not automatically assign public IP addresses to instances launched into it. If you want your instances to be assigned a public IP address, then you need to enable the `auto-assign public IP address` setting for the subnet. See [Modifying the public IPv4 addressing attribute for your subnet](https://docs.aws.amazon.com/vpc/latest/userguide/vpc-ip-addressing.html#subnet-public-ip) in the *Amazon VPC User Guide*.
     * + **IamInstanceProfileNotFound**: We couldn't find the IAM instance profile for your managed node group. You may be able to recreate an instance profile with the same settings to recover.
     * + **IamNodeRoleNotFound**: We couldn't find the IAM role for your managed node group. You may be able to recreate an IAM role with the same settings to recover.
     * + **InstanceLimitExceeded**: Your Amazon Web Services account is unable to launch any more instances of the specified instance type. You may be able to request an Amazon EC2 instance limit increase to recover.
     * + **InsufficientFreeAddresses**: One or more of the subnets associated with your managed node group does not have enough available IP addresses for new nodes.
     * + **InternalFailure**: These errors are usually caused by an Amazon EKS server-side issue.
     * + **NodeCreationFailure**: Your launched instances are unable to register with your Amazon EKS cluster. Common causes of this failure are insufficient [node IAM role](https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html) permissions or lack of outbound internet access for the nodes.
     */
    val code: aws.sdk.kotlin.services.eks.model.NodegroupIssueCode? = builder.code
    /**
     * The error message associated with the issue.
     */
    val message: kotlin.String? = builder.message
    /**
     * The Amazon Web Services resources that are afflicted by this issue.
     */
    val resourceIds: List<String>? = builder.resourceIds

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.Issue = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Issue(")
        append("code=$code,")
        append("message=$message,")
        append("resourceIds=$resourceIds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = code?.hashCode() ?: 0
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (resourceIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Issue

        if (code != other.code) return false
        if (message != other.message) return false
        if (resourceIds != other.resourceIds) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.Issue = Builder(this).apply(block).build()

    class Builder {
        /**
         * A brief description of the error.
         * + **AccessDenied**: Amazon EKS or one or more of your managed nodes is failing to authenticate or authorize with your Kubernetes cluster API server.
         * + **AsgInstanceLaunchFailures**: Your Auto Scaling group is experiencing failures while attempting to launch instances.
         * + **AutoScalingGroupNotFound**: We couldn't find the Auto Scaling group associated with the managed node group. You may be able to recreate an Auto Scaling group with the same settings to recover.
         * + **ClusterUnreachable**: Amazon EKS or one or more of your managed nodes is unable to to communicate with your Kubernetes cluster API server. This can happen if there are network disruptions or if API servers are timing out processing requests.
         * + **Ec2LaunchTemplateNotFound**: We couldn't find the Amazon EC2 launch template for your managed node group. You may be able to recreate a launch template with the same settings to recover.
         * + **Ec2LaunchTemplateVersionMismatch**: The Amazon EC2 launch template version for your managed node group does not match the version that Amazon EKS created. You may be able to revert to the version that Amazon EKS created to recover.
         * + **Ec2SecurityGroupDeletionFailure**: We could not delete the remote access security group for your managed node group. Remove any dependencies from the security group.
         * + **Ec2SecurityGroupNotFound**: We couldn't find the cluster security group for the cluster. You must recreate your cluster.
         * + **Ec2SubnetInvalidConfiguration**: One or more Amazon EC2 subnets specified for a node group do not automatically assign public IP addresses to instances launched into it. If you want your instances to be assigned a public IP address, then you need to enable the `auto-assign public IP address` setting for the subnet. See [Modifying the public IPv4 addressing attribute for your subnet](https://docs.aws.amazon.com/vpc/latest/userguide/vpc-ip-addressing.html#subnet-public-ip) in the *Amazon VPC User Guide*.
         * + **IamInstanceProfileNotFound**: We couldn't find the IAM instance profile for your managed node group. You may be able to recreate an instance profile with the same settings to recover.
         * + **IamNodeRoleNotFound**: We couldn't find the IAM role for your managed node group. You may be able to recreate an IAM role with the same settings to recover.
         * + **InstanceLimitExceeded**: Your Amazon Web Services account is unable to launch any more instances of the specified instance type. You may be able to request an Amazon EC2 instance limit increase to recover.
         * + **InsufficientFreeAddresses**: One or more of the subnets associated with your managed node group does not have enough available IP addresses for new nodes.
         * + **InternalFailure**: These errors are usually caused by an Amazon EKS server-side issue.
         * + **NodeCreationFailure**: Your launched instances are unable to register with your Amazon EKS cluster. Common causes of this failure are insufficient [node IAM role](https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html) permissions or lack of outbound internet access for the nodes.
         */
        var code: aws.sdk.kotlin.services.eks.model.NodegroupIssueCode? = null
        /**
         * The error message associated with the issue.
         */
        var message: kotlin.String? = null
        /**
         * The Amazon Web Services resources that are afflicted by this issue.
         */
        var resourceIds: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.Issue) : this() {
            this.code = x.code
            this.message = x.message
            this.resourceIds = x.resourceIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.Issue = Issue(this)
    }
}
