// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model



/**
 * An object representing a node group launch template specification. The launch template cannot include `SubnetId`[](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInterface.html), `IamInstanceProfile`[](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_IamInstanceProfile.html), `RequestSpotInstances`[](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RequestSpotInstances.html), `HibernationOptions`[](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_HibernationOptionsRequest.html), or `TerminateInstances`[](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TerminateInstances.html), or the node group deployment or update will fail. For more information about launch templates, see `CreateLaunchTemplate`[](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLaunchTemplate.html) in the Amazon EC2 API Reference. For more information about using launch templates with Amazon EKS, see [Launch template support](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html) in the *Amazon EKS User Guide*.
 *
 * Specify either `name` or `id`, but not both.
 */
class LaunchTemplateSpecification private constructor(builder: Builder) {
    /**
     * The ID of the launch template.
     */
    val id: kotlin.String? = builder.id
    /**
     * The name of the launch template.
     */
    val name: kotlin.String? = builder.name
    /**
     * The version of the launch template to use. If no version is specified, then the template's default version is used.
     */
    val version: kotlin.String? = builder.version

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.LaunchTemplateSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LaunchTemplateSpecification(")
        append("id=$id,")
        append("name=$name,")
        append("version=$version)")
    }

    override fun hashCode(): kotlin.Int {
        var result = id?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LaunchTemplateSpecification

        if (id != other.id) return false
        if (name != other.name) return false
        if (version != other.version) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.LaunchTemplateSpecification = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ID of the launch template.
         */
        var id: kotlin.String? = null
        /**
         * The name of the launch template.
         */
        var name: kotlin.String? = null
        /**
         * The version of the launch template to use. If no version is specified, then the template's default version is used.
         */
        var version: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.LaunchTemplateSpecification) : this() {
            this.id = x.id
            this.name = x.name
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.LaunchTemplateSpecification = LaunchTemplateSpecification(this)
    }
}
