// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model



class ListClustersRequest private constructor(builder: Builder) {
    /**
     * Indicates whether external clusters are included in the returned list. Use '`all`' to return connected clusters, or blank to return only Amazon EKS clusters. '`all`' must be in lowercase otherwise an error occurs.
     */
    val include: List<String>? = builder.include
    /**
     * The maximum number of cluster results returned by `ListClusters` in paginated output. When you use this parameter, `ListClusters` returns only `maxResults` results in a single page along with a `nextToken` response element. You can see the remaining results of the initial request by sending another `ListClusters` request with the returned `nextToken` value. This value can be between 1 and 100. If you don't use this parameter, `ListClusters` returns up to 100 results and a `nextToken` value if applicable.
     */
    val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The `nextToken` value returned from a previous paginated `ListClusters` request where `maxResults` was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the `nextToken` value.
     *
     * This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and not for other programmatic purposes.
     */
    val nextToken: kotlin.String? = builder.nextToken

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.ListClustersRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListClustersRequest(")
        append("include=$include,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = include?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListClustersRequest

        if (include != other.include) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.ListClustersRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Indicates whether external clusters are included in the returned list. Use '`all`' to return connected clusters, or blank to return only Amazon EKS clusters. '`all`' must be in lowercase otherwise an error occurs.
         */
        var include: List<String>? = null
        /**
         * The maximum number of cluster results returned by `ListClusters` in paginated output. When you use this parameter, `ListClusters` returns only `maxResults` results in a single page along with a `nextToken` response element. You can see the remaining results of the initial request by sending another `ListClusters` request with the returned `nextToken` value. This value can be between 1 and 100. If you don't use this parameter, `ListClusters` returns up to 100 results and a `nextToken` value if applicable.
         */
        var maxResults: kotlin.Int? = null
        /**
         * The `nextToken` value returned from a previous paginated `ListClusters` request where `maxResults` was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the `nextToken` value.
         *
         * This token should be treated as an opaque identifier that is used only to retrieve the next items in a list and not for other programmatic purposes.
         */
        var nextToken: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.ListClustersRequest) : this() {
            this.include = x.include
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.ListClustersRequest = ListClustersRequest(this)
    }
}
