// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.eks.model



class ListIdentityProviderConfigsRequest private constructor(builder: Builder) {
    /**
     * The cluster name that you want to list identity provider configurations for.
     */
    val clusterName: kotlin.String? = builder.clusterName
    /**
     * The maximum number of identity provider configurations returned by `ListIdentityProviderConfigs` in paginated output. When you use this parameter, `ListIdentityProviderConfigs` returns only `maxResults` results in a single page along with a `nextToken` response element. You can see the remaining results of the initial request by sending another `ListIdentityProviderConfigs` request with the returned `nextToken` value. This value can be between 1 and 100. If you don't use this parameter, `ListIdentityProviderConfigs` returns up to 100 results and a `nextToken` value, if applicable.
     */
    val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The `nextToken` value returned from a previous paginated `IdentityProviderConfigsRequest` where `maxResults` was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the `nextToken` value.
     */
    val nextToken: kotlin.String? = builder.nextToken

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.eks.model.ListIdentityProviderConfigsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListIdentityProviderConfigsRequest(")
        append("clusterName=$clusterName,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clusterName?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListIdentityProviderConfigsRequest

        if (clusterName != other.clusterName) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.eks.model.ListIdentityProviderConfigsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The cluster name that you want to list identity provider configurations for.
         */
        var clusterName: kotlin.String? = null
        /**
         * The maximum number of identity provider configurations returned by `ListIdentityProviderConfigs` in paginated output. When you use this parameter, `ListIdentityProviderConfigs` returns only `maxResults` results in a single page along with a `nextToken` response element. You can see the remaining results of the initial request by sending another `ListIdentityProviderConfigs` request with the returned `nextToken` value. This value can be between 1 and 100. If you don't use this parameter, `ListIdentityProviderConfigs` returns up to 100 results and a `nextToken` value, if applicable.
         */
        var maxResults: kotlin.Int? = null
        /**
         * The `nextToken` value returned from a previous paginated `IdentityProviderConfigsRequest` where `maxResults` was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the `nextToken` value.
         */
        var nextToken: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.eks.model.ListIdentityProviderConfigsRequest) : this() {
            this.clusterName = x.clusterName
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.eks.model.ListIdentityProviderConfigsRequest = ListIdentityProviderConfigsRequest(this)
    }
}
